/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionDefinitionType;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CICSTypesRegistry;
import com.ibm.cics.core.model.CICSplexDefinitionType;
import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.CMASListType;
import com.ibm.cics.core.model.CSDGroupDefinitionType;
import com.ibm.cics.core.model.CSDListDefinitionType;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.GroupSystemGroupEntryType;
import com.ibm.cics.core.model.ICICSplexRepository;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.IInstallTargetRoot;
import com.ibm.cics.core.model.IParent;
import com.ibm.cics.core.model.ISystemGroupRoot;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.ResourceDescriptionDefinitionType;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.model.SystemSystemGroupEntryType;
import com.ibm.cics.core.model.WorkloadRouterType;
import com.ibm.cics.core.model.WorkloadTargetType;
import com.ibm.cics.core.model.WorkloadType;
import com.ibm.cics.core.model.context.IAssociationContextProvider;
import com.ibm.cics.core.model.internal.CICSplexRepository;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.adapters.AdapterUtility;
import com.ibm.cics.core.ui.adapters.CICSSystemsTreeAdapter;
import com.ibm.cics.core.ui.adapters.SystemGroupMemberInvocationHandler;
import com.ibm.cics.core.ui.adapters.SystemGroupParentTreeAdapter;
import com.ibm.cics.core.ui.adapters.WLMRoutersAdapter;
import com.ibm.cics.core.ui.adapters.WLMRoutingRulesAdapter;
import com.ibm.cics.core.ui.adapters.WLMWorkloadTreeAdapter;
import com.ibm.cics.core.ui.viewers.IGroupRegionMember;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.ICICSplexDefinition;
import com.ibm.cics.model.ICMASList;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.ICSDResourceDefinition;
import com.ibm.cics.model.IGroupSystemGroupEntry;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.model.IResourceGroupEntry;
import com.ibm.cics.model.ISystemSystemGroupEntry;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadRouter;
import com.ibm.cics.model.IWorkloadSpecification;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.model.ui.ModelUIPlugin;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class WorkbenchAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(WorkbenchAdapterFactory.class);
    private static final Debug detailedDebug = new Debug(WorkbenchAdapterFactory.class, Level.FINEST);
    public static IDeferredWorkbenchAdapter childlessCicsRegionDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public Object getParent(Object o) {
            return null;
        }

        public String toString() {
            return "IDeferredWorkbenchAdapter[systemDefinitionAdapter,childless]";
        }

        public boolean isContainer() {
            return false;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)CICSRegionDefinitionType.getInstance());
        }

        public String getLabel(Object o) {
            ICICSRegionDefinition definition = (ICICSRegionDefinition)o;
            return definition.getName();
        }
    };
    public static final IDeferredWorkbenchAdapter cpsmAdapterForCMASExplorer = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[cmasAdapter]";
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((ICPSM)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            try {
                Object[] cmasLists = ((ICPSM)object).getDefinitions2((ICICSType)CMASListType.getInstance(), (IContext)new Context(null));
                collector.add(cmasLists, monitor);
            }
            catch (CICSSystemManagerException e) {
                UIPlugin.logError(e);
            }
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }
    };
    private IDeferredWorkbenchAdapter cpsmAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[cpsmAdapter]";
        }

        public Object[] getChildren(Object o) {
            return WorkbenchAdapterFactory.getCICSplexes((ICPSM)o);
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((ICPSM)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            Object[] children = this.getChildren(object);
            collector.add(children, monitor);
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }
    };
    private IDeferredWorkbenchAdapter plexAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[plexAdapter]";
        }

        public Object[] getChildren(Object o) {
            IParent plex = (IParent)o;
            Object[] managedRegions = this.getManagedRegions(plex);
            return managedRegions;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)CICSplexType.getInstance());
        }

        public String getLabel(Object o) {
            ICICSplex plex = (ICICSplex)o;
            return plex.getName();
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            debug.enter("fetchDeferredChildren", (Object)this, object, (Object)collector, (Object)monitor);
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            DeferredElementCollector deferredCollector = new DeferredElementCollector(collector, monitor);
            ICICSplex cicsPlex = (ICICSplex)object;
            WLMWorkloadTreeAdapter workloadAdapter = new WLMWorkloadTreeAdapter(cicsPlex);
            try {
                workloadAdapter.checkForChildren(monitor);
                deferredCollector.add(workloadAdapter, monitor);
            }
            catch (CICSActionException e) {
                if (WorkbenchAdapterFactory.this.isExceptionMissingMaintenancePoint(e)) {
                    workloadAdapter.setErrorState(true);
                    deferredCollector.add(workloadAdapter, monitor);
                    UIPlugin.logWarning(Messages.getString("WorkbenchAdapterFactory.mpCmasUnavailable"), e);
                }
                debug.warning("plexAdapter.fetchDeferredChildren", (Object)e);
            }
            CICSSystemsTreeAdapter regionAdapter = new CICSSystemsTreeAdapter(cicsPlex);
            deferredCollector.add(regionAdapter, monitor);
            SystemGroupParentTreeAdapter sysGroupAdapter = new SystemGroupParentTreeAdapter(cicsPlex);
            try {
                sysGroupAdapter.checkForChildren(monitor);
                deferredCollector.add(sysGroupAdapter, monitor);
            }
            catch (CICSActionException e) {
                if (WorkbenchAdapterFactory.this.isExceptionMissingMaintenancePoint(e)) {
                    sysGroupAdapter.setErrorState(true);
                    deferredCollector.add(sysGroupAdapter, monitor);
                    UIPlugin.logWarning(Messages.getString("WorkbenchAdapterFactory.mpCmasUnavailable"), e);
                }
                debug.warning("plexAdapter.fetchDeferredChildren", (Object)e);
            }
            deferredCollector.done();
            monitor.done();
            debug.exit("fetchDeferredChildren");
        }

        private ICICSObject[] getManagedRegions(IParent plex) {
            ICICSObject[] managedRegions = plex.getChildrenAsArray((ICICSType)ManagedRegionType.getInstance());
            return managedRegions;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }
    };
    public static final IDeferredWorkbenchAdapter cicsPlexToGroupsAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[cicsPlexToGroupsAdapter]";
        }

        public Object[] getChildren(Object o) {
            return new String[]{"PLEX1", "PLEX2 "};
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)CICSplexType.getInstance());
        }

        public String getLabel(Object o) {
            return o.toString();
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            ICICSplex cicsPlex = (ICICSplex)object;
            ICoreObject coreObject = (ICoreObject)object;
            ICPSM cpsm = coreObject.getCPSM();
            Context context = new Context(cicsPlex.getName());
            WorkbenchAdapterFactory.getGroups(collector, monitor, cpsm, (IContext)context);
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }
    };
    private static IDeferredWorkbenchAdapter workloadSpecificationAdapter = new IDeferredWorkbenchAdapter(){

        public Object getParent(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return UIPlugin.IMGD_INACTIVE_WORKLOAD;
        }

        public String getLabel(Object o) {
            return ((IWorkloadSpecification)o).getName();
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public boolean isContainer() {
            return false;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }
    };
    private static IDeferredWorkbenchAdapter activeWorkloadAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[activeWorkloadAdapter]";
        }

        public Object[] getChildren(Object o) {
            IWorkload activeWorkload = (IWorkload)o;
            Object[] children = new Object[]{new WLMRoutersAdapter(activeWorkload), new WLMRoutingRulesAdapter(activeWorkload)};
            return children;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)WorkloadType.getInstance());
        }

        public String getLabel(Object o) {
            return String.format("%s %s", ((IWorkload)o).getName(), ((IWorkload)o).getOwningSystemID());
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            debug.enter("fetchDeferredChildren", (Object)this, object, (Object)collector, (Object)monitor);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            collector.add(this.getChildren(object), monitor);
            monitor.done();
            debug.exit("fetchDeferredChildren");
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }
    };
    private IDeferredWorkbenchAdapter activeAORAdapter = new AbstractDeferredWorkbenchAdapter(this){

        public String toString() {
            return "IDeferredWorkbenchAdapter[activeAORAdapter]";
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkloadTarget region = (IWorkloadTarget)object;
            ImageDescriptor descriptor = region.getStatus().equals((Object)IWorkloadTarget.StatusValue.QUIESCED) ? UIPlugin.IMGD_QUIESCED_ACTIVE_AOR : ModelUIPlugin.getTypeImageDescriptor((ICICSType)WorkloadTargetType.getInstance());
            return descriptor;
        }

        public String getLabel(Object o) {
            return ((IWorkloadTarget)o).getName();
        }

        public boolean isContainer() {
            return false;
        }
    };
    private IDeferredWorkbenchAdapter activeTORAdapter = new AbstractDeferredWorkbenchAdapter(this){

        public String toString() {
            return "IDeferredWorkbenchAdapter[activeTORAdapter]";
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)WorkloadRouterType.getInstance());
        }

        public String getLabel(Object o) {
            return ((IWorkloadRouter)o).getName();
        }

        @Override
        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public boolean isContainer() {
            return false;
        }
    };
    private IDeferredWorkbenchAdapter managedRegionAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[managedRegionAdapter]";
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IManagedRegion region = (IManagedRegion)object;
            ImageDescriptor descriptor = region.getState().equals((Object)IManagedRegion.StateValue.ACTIVE) ? ModelUIPlugin.getTypeImageDescriptor((ICICSType)ManagedRegionType.getInstance()) : UIPlugin.IMGD_DISABLED_MANAGED_REGION;
            return descriptor;
        }

        public String getLabel(Object o) {
            return ((IManagedRegion)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return false;
        }
    };
    private IDeferredWorkbenchAdapter cmasListAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[cmasListAdapter]";
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            ICMASList region = (ICMASList)object;
            ImageDescriptor descriptor = region.getStatus().equals((Object)ICMASList.StatusValue.ACTIVE) ? ModelUIPlugin.getTypeImageDescriptor((ICICSType)CMASListType.getInstance()) : UIPlugin.IMGD_DISABLED_CMASLIST;
            return descriptor;
        }

        public String getLabel(Object o) {
            return ((ICMASList)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return false;
        }
    };
    private IDeferredWorkbenchAdapter cicsPlexRepositoriesRootAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[cicsPlexRepositoriesRootAdapter]";
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            DeferredElementCollector deferredCollector = new DeferredElementCollector(collector, monitor);
            Object[] objectArray = this.getChildren(object);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                ICICSplex cicsPlex = (ICICSplex)child;
                CICSplexRepository repository = new CICSplexRepository(cicsPlex);
                deferredCollector.add(repository, monitor);
                ++n2;
            }
            deferredCollector.done();
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public Object[] getChildren(Object o) {
            ICoreObject coreObject = (ICoreObject)o;
            Object[] cicsPlexes = WorkbenchAdapterFactory.getCICSplexes(coreObject.getCPSM());
            return cicsPlexes;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((ISystemGroupRoot)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter plexDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[plexDefinitionAdapter]";
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            ICICSplexDefinition plexDefinition = (ICICSplexDefinition)object;
            ICoreObject coreObject = (ICoreObject)plexDefinition;
            ICPSM cpsm = coreObject.getCPSM();
            IContext context = ((IContextProvider)plexDefinition).getIContext();
            WorkbenchAdapterFactory.getGroups(collector, monitor, cpsm, context);
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)CICSplexDefinitionType.getInstance());
        }

        public String getLabel(Object o) {
            return ((ICICSplexDefinition)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter cicsRegionGroupDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[systemGroupAdapter]";
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            DeferredElementCollector deferredCollector = new DeferredElementCollector(collector, monitor);
            final ICICSRegionGroupDefinition parentGroup = (ICICSRegionGroupDefinition)object;
            IGroupSystemGroupEntry[] groupEntries = (IGroupSystemGroupEntry[])this.getResources((IParent)parentGroup, (ICICSType<?>)GroupSystemGroupEntryType.getInstance());
            debug.event("fetchDeferredChildren", (Object)groupEntries.length);
            if (groupEntries.length == 0) {
                ICPSM cpsm = ((ICoreObject)parentGroup).getCPSM();
                IAssociationContext context = new IAssociationContext(){

                    public String getContext() {
                        return ((IContextProvider)parentGroup).getIContext().getContext();
                    }

                    public String getResourceType() {
                        return CICSRegionGroupDefinitionType.getInstance().getResourceTableName();
                    }

                    public String getResourceName() {
                        return parentGroup.getName();
                    }

                    public String toString() {
                        return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "/" + this.getResourceType() + "=" + this.getResourceName() + "]";
                    }
                };
                ((IContextProvider)parentGroup).getIContext();
                try {
                    debug.event("fetchDeferredChildren", (Object)CICSRegionGroupDefinitionType.getInstance(), (Object)context);
                    ICICSRegionGroupDefinition[] regionGroups = (ICICSRegionGroupDefinition[])cpsm.getDefinitions2((ICICSType)CICSRegionGroupDefinitionType.getInstance(), (IContext)context);
                    debug.event("fetchDeferredChildren", (Object)regionGroups.length);
                    Object[] iRegionGroups = new ICICSRegionGroupDefinition[regionGroups.length];
                    int i = 0;
                    while (i < regionGroups.length) {
                        ICPSMDefinition grpDef = WorkbenchAdapterFactory.getSystemGroupMember((ICPSMDefinition)regionGroups[i], parentGroup);
                        if (grpDef instanceof ICICSRegionGroupDefinition) {
                            iRegionGroups[i] = (ICICSRegionGroupDefinition)grpDef;
                        }
                        ++i;
                    }
                    collector.add(iRegionGroups, monitor);
                }
                catch (CICSSystemManagerException e) {
                    UIPlugin.logError(e);
                }
            } else {
                ICICSRegionGroupDefinition[] groups = (ICICSRegionGroupDefinition[])this.getResources((IParent)parentGroup, (ICICSType<?>)CICSRegionGroupDefinitionType.getInstance());
                int g = 0;
                while (g < groups.length) {
                    int e = 0;
                    while (e < groupEntries.length) {
                        ICICSRegionGroupDefinition group = groups[g];
                        IGroupSystemGroupEntry entry = groupEntries[e];
                        if (entry.getName().equals(parentGroup.getName()) && entry.getGroupName().equals(group.getName())) {
                            deferredCollector.add(WorkbenchAdapterFactory.getSystemGroupMember((ICPSMDefinition)group, parentGroup), monitor);
                        }
                        ++e;
                    }
                    ++g;
                }
            }
            ISystemSystemGroupEntry[] systemEntries = (ISystemSystemGroupEntry[])this.getResources((IParent)parentGroup, (ICICSType<?>)SystemSystemGroupEntryType.getInstance());
            debug.event("fetchDeferredChildren", (Object)systemEntries.length);
            if (systemEntries.length == 0) {
                ICPSM cpsm = ((ICoreObject)parentGroup).getCPSM();
                IAssociationContext context = new IAssociationContext(){

                    public String getContext() {
                        return ((IContextProvider)parentGroup).getIContext().getContext();
                    }

                    public String getResourceType() {
                        return CICSRegionGroupDefinitionType.getInstance().getResourceTableName();
                    }

                    public String getResourceName() {
                        return parentGroup.getName();
                    }

                    public String toString() {
                        return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "/" + this.getResourceType() + "=" + this.getResourceName() + "]";
                    }
                };
                ((IContextProvider)parentGroup).getIContext();
                debug.event("fetchDeferredChildren", (Object)CICSRegionDefinitionType.getInstance(), (Object)context);
                try {
                    Object[] regionDefinitions = (ICICSRegionDefinition[])cpsm.getDefinitions2((ICICSType)CICSRegionDefinitionType.getInstance(), (IContext)context);
                    debug.event("fetchDeferredChildren", (Object)regionDefinitions.length);
                    int i = 0;
                    while (i < regionDefinitions.length) {
                        ICPSMDefinition regDef = WorkbenchAdapterFactory.getSystemGroupMember((ICPSMDefinition)regionDefinitions[i], parentGroup);
                        if (regDef instanceof ICICSRegionDefinition) {
                            regionDefinitions[i] = (ICICSRegionDefinition)regDef;
                        }
                        ++i;
                    }
                    deferredCollector.add(regionDefinitions, monitor);
                }
                catch (CICSSystemManagerException e) {
                    UIPlugin.logError(e);
                }
            } else {
                ICICSRegionDefinition[] definitions = (ICICSRegionDefinition[])this.getResources((IParent)parentGroup, (ICICSType<?>)CICSRegionDefinitionType.getInstance());
                int d = 0;
                while (d < definitions.length) {
                    int e = 0;
                    while (e < systemEntries.length) {
                        ICICSRegionDefinition definition = definitions[d];
                        ISystemSystemGroupEntry entry = systemEntries[e];
                        if (entry.getName().equals(parentGroup.getName()) && entry.getSystemName().equals(definition.getName())) {
                            deferredCollector.add(WorkbenchAdapterFactory.getSystemGroupMember((ICPSMDefinition)definition, parentGroup), monitor);
                        }
                        ++e;
                    }
                    ++d;
                }
            }
            deferredCollector.done();
            monitor.done();
        }

        private ICICSObject[] getResources(IParent parent, ICICSType<?> resourceType) {
            ICICSObject[] resources = parent.getChildrenAsArray(resourceType);
            return resources;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)CICSRegionGroupDefinitionType.getInstance());
        }

        public String getLabel(Object o) {
            return ((ICICSRegionGroupDefinition)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter cicsRegionDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[systemDefinitionAdapter]";
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            Object[] children = this.getChildren(object);
            collector.add(children, monitor);
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public Object[] getChildren(Object o) {
            ICICSObject[] csdLists = ((IParent)o).getChildrenAsArray((ICICSType)CSDListDefinitionType.getInstance());
            ICICSObject[] csdGroups = ((IParent)o).getChildrenAsArray((ICICSType)CSDGroupDefinitionType.getInstance());
            Object[] allChildren = new Object[csdLists.length + csdGroups.length];
            System.arraycopy(csdLists, 0, allChildren, 0, csdLists.length);
            System.arraycopy(csdGroups, 0, allChildren, csdLists.length, csdGroups.length);
            return allChildren;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return ModelUIPlugin.getTypeImageDescriptor((ICICSType)CICSRegionDefinitionType.getInstance());
        }

        public String getLabel(Object o) {
            ICICSRegionDefinition definition = (ICICSRegionDefinition)o;
            return definition.getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter resourceGroupAdapter = new AbstractDeferredWorkbenchAdapter(this){

        public String toString() {
            return "IDeferredWorkbenchAdapter[resourceGroupAdapter]";
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return UIPlugin.IMGD_RESOURCE_GROUP_DEFINITION;
        }

        public String getLabel(Object o) {
            return ((IResourceGroupDefinition)o).getName();
        }

        @Override
        public Object getParent(Object o) {
            return null;
        }

        public boolean isContainer() {
            return false;
        }
    };
    private IDeferredWorkbenchAdapter resourceGroupEntryAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[resourceGroupEntryAdapter]";
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return false;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IResourceGroupEntry entry = (IResourceGroupEntry)object;
            ICICSType type = CICSTypesRegistry.findForResourceTableName((String)entry.getDefinitionType());
            if (type != null) {
                return ModelUIPlugin.getTypeImageDescriptor((ICICSType)type);
            }
            return null;
        }

        public String getLabel(Object o) {
            return ((ICICSObject)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter installTargetRootAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[installTargetRootAdapter]";
        }

        public Object[] getChildren(Object o) {
            return ((IInstallTargetRoot)o).getTargets();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((IInstallTargetRoot)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            debug.enter("fetchDeferredChildren", (Object)this, object, (Object)collector, (Object)monitor);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            Object[] children = this.getChildren(object);
            debug.event("fetchDeferredChildren", Arrays.asList(children));
            collector.add(children, monitor);
            monitor.done();
            debug.exit("fetchDeferredChildren");
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }
    };
    private IDeferredWorkbenchAdapter csdGroupDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return false;
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return UIPlugin.IMGD_CSD_GROUP_DEFINITION;
        }

        public String getLabel(Object o) {
            return ((ICSDGroupDefinition)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter csdListDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            try {
                ICSDListDefinition list = (ICSDListDefinition)object;
                IAssociationContextProvider contextProvider = (IAssociationContextProvider)Platform.getAdapterManager().getAdapter((Object)list, IAssociationContextProvider.class);
                IAssociationContext context = contextProvider.getContext((ICICSObject)list);
                Object[] children = ((ICoreObject)list).getCPSM().getDefinitions2((ICICSType)CSDGroupDefinitionType.getInstance(), (IContext)context);
                collector.add(children, monitor);
            }
            catch (CICSSystemManagerException e) {
                UIPlugin.logError(e);
            }
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return UIPlugin.IMGD_CSD_LIST_DEFINITION;
        }

        public String getLabel(Object o) {
            return ((ICSDListDefinition)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter csdResourceDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public String toString() {
            return "IDeferredWorkbenchAdapter[csdResourceDefinitionAdapter]";
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return false;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            ICSDResourceDefinition entry = (ICSDResourceDefinition)object;
            ICICSType type = CICSTypesRegistry.findForResourceTableName((String)entry.getDefname());
            if (type != null) {
                return ModelUIPlugin.getTypeImageDescriptor((ICICSType)type);
            }
            return null;
        }

        public String getLabel(Object o) {
            return ((ICICSObject)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IDeferredWorkbenchAdapter resourceDescriptionDefinitionAdapter = new IDeferredWorkbenchAdapter(){

        public Object getParent(Object o) {
            return null;
        }

        public String getLabel(Object o) {
            return ((IResourceDescriptionDefinition)o).getName();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return UIPlugin.IMGD_RESOURCE_DESCRIPTION_DEFINITION;
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public boolean isContainer() {
            return true;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            try {
                ICPSM cpsm = ((ICoreObject)object).getCPSM();
                IResourceDescriptionDefinition list = (IResourceDescriptionDefinition)object;
                IAssociationContextProvider contextProvider = (IAssociationContextProvider)Platform.getAdapterManager().getAdapter((Object)list, IAssociationContextProvider.class);
                IAssociationContext context = contextProvider.getContext((ICICSObject)list);
                Object[] children = cpsm.getDefinitions2((ICICSType)ResourceGroupDefinitionType.getInstance(), (IContext)context);
                collector.add(children, monitor);
            }
            catch (CICSSystemManagerException e) {
                UIPlugin.logError(e);
            }
            monitor.done();
        }
    };

    public WorkbenchAdapterFactory() {
        debug.event("<init>", (Object)this);
    }

    private static ICICSplex[] getCICSplexes(ICPSM cpsm) {
        debug.enter("getCICSplexes", (Object)cpsm);
        Map<String, ICICSplex> allCICSplexes = AdapterUtility.getUniqueCICSplexes(cpsm);
        debug.event("getCICSplexes", allCICSplexes);
        Object[] cicsPlexes = allCICSplexes.values().toArray(new ICICSplex[allCICSplexes.size()]);
        debug.exit("getCICSplexes", (Object)Arrays.toString(cicsPlexes));
        return cicsPlexes;
    }

    private boolean isExceptionMissingMaintenancePoint(CICSActionException e) {
        SystemManagerConnectionException exception;
        return e.getCause() instanceof SystemManagerConnectionException && (exception = (SystemManagerConnectionException)e.getCause()).getReason() == 1323 && exception.getResponse() == 1034;
    }

    private static void getGroups(IElementCollector collector, IProgressMonitor monitor, ICPSM cpsm, IContext context) {
        String METHOD_NAME = "getGroups";
        if (cpsm.checkPermission(ICICSOperation.GET, (ICICSType)ResourceDescriptionDefinitionType.getInstance())) {
            try {
                Object[] resDescs = (IResourceDescriptionDefinition[])cpsm.getDefinitions2((ICICSType)ResourceDescriptionDefinitionType.getInstance(), context);
                collector.add(resDescs, monitor);
            }
            catch (CICSSystemManagerException e) {
                debug.warning("getGroups", (Object)e);
            }
        }
        if (cpsm.checkPermission(ICICSOperation.GET, (ICICSType)ResourceGroupDefinitionType.getInstance())) {
            try {
                Object[] resGroups = (IResourceGroupDefinition[])cpsm.getDefinitions2((ICICSType)ResourceGroupDefinitionType.getInstance(), context);
                collector.add(resGroups, monitor);
            }
            catch (CICSSystemManagerException e) {
                debug.warning("getGroups", (Object)e);
            }
        }
        AdapterUtility.getSystemGroups(collector, monitor, cpsm, context);
        if (cpsm.checkPermission(ICICSOperation.GET, (ICICSType)CICSRegionDefinitionType.getInstance())) {
            try {
                Object[] definitions = (ICICSRegionDefinition[])cpsm.getDefinitions2((ICICSType)CICSRegionDefinitionType.getInstance(), context);
                collector.add(definitions, monitor);
            }
            catch (CICSSystemManagerException e) {
                debug.warning("getGroups", (Object)e);
            }
        }
    }

    private static ICPSMDefinition getSystemGroupMember(ICPSMDefinition def, ICICSRegionGroupDefinition parentGroup) {
        HashSet interfaces = new HashSet();
        Class<?> current = def.getClass();
        do {
            Class<?>[] classInterfaces = current.getInterfaces();
            interfaces.addAll(Arrays.asList(classInterfaces));
            Class<?>[] classArray = classInterfaces;
            int n = classInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                do {
                    interfaces.add(iface);
                } while ((iface = iface.getSuperclass()) != null);
                ++n2;
            }
        } while ((current = current.getSuperclass()) != null);
        interfaces.add(IGroupRegionMember.class);
        return (ICPSMDefinition)Proxy.newProxyInstance(WorkbenchAdapterFactory.class.getClassLoader(), interfaces.toArray(new Class[0]), (InvocationHandler)new SystemGroupMemberInvocationHandler(def, parentGroup));
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        detailedDebug.enter("getAdapter", (Object)this, adaptableObject, (Object)adapterType);
        Object adapter = null;
        if (adapterType == IWorkbenchAdapter.class) {
            if (adaptableObject instanceof ICPSM) {
                adapter = this.cpsmAdapter;
            }
            if (adaptableObject instanceof ICICSplex) {
                adapter = this.plexAdapter;
            }
            if (adaptableObject instanceof IManagedRegion) {
                adapter = this.managedRegionAdapter;
            }
        } else if (adapterType == IDeferredWorkbenchAdapter.class) {
            if (adaptableObject instanceof ICPSM) {
                adapter = this.cpsmAdapter;
            } else if (adaptableObject instanceof ICICSplex) {
                adapter = this.plexAdapter;
            } else if (adaptableObject instanceof IWorkloadTarget) {
                adapter = this.activeAORAdapter;
            } else if (adaptableObject instanceof IWorkload) {
                adapter = activeWorkloadAdapter;
            } else if (adaptableObject instanceof IWorkloadRouter) {
                adapter = this.activeTORAdapter;
            } else if (adaptableObject instanceof IManagedRegion) {
                adapter = this.managedRegionAdapter;
            } else if (adaptableObject instanceof IWorkloadSpecification) {
                adapter = workloadSpecificationAdapter;
            } else if (adaptableObject instanceof ISystemGroupRoot) {
                adapter = this.cicsPlexRepositoriesRootAdapter;
            } else if (adaptableObject instanceof ICICSplexRepository) {
                adapter = new CICSplexRepositoryAdapter((ICICSplexRepository)adaptableObject);
            } else if (adaptableObject instanceof ICICSplexDefinition) {
                adapter = this.plexDefinitionAdapter;
            } else if (adaptableObject instanceof ICICSRegionGroupDefinition) {
                adapter = this.cicsRegionGroupDefinitionAdapter;
            } else if (adaptableObject instanceof ICICSRegionDefinition) {
                adapter = this.cicsRegionDefinitionAdapter;
            } else if (adaptableObject instanceof IResourceDescriptionDefinition) {
                adapter = this.resourceDescriptionDefinitionAdapter;
            } else if (adaptableObject instanceof IResourceGroupDefinition) {
                adapter = this.resourceGroupAdapter;
            } else if (adaptableObject instanceof IResourceGroupEntry) {
                adapter = this.resourceGroupEntryAdapter;
            } else if (adaptableObject instanceof ICSDGroupDefinition) {
                adapter = this.csdGroupDefinitionAdapter;
            } else if (adaptableObject instanceof ICSDListDefinition) {
                adapter = this.csdListDefinitionAdapter;
            } else if (adaptableObject instanceof ICSDResourceDefinition) {
                adapter = this.csdResourceDefinitionAdapter;
            } else if (adaptableObject instanceof ICMASList) {
                adapter = this.cmasListAdapter;
            } else if (adaptableObject instanceof IInstallTargetRoot) {
                adapter = this.installTargetRootAdapter;
            } else if (adaptableObject instanceof IDeferredWorkbenchAdapter) {
                adapter = adaptableObject;
            }
        }
        detailedDebug.exit("getAdapter", adapter);
        return adapter;
    }

    public Class[] getAdapterList() {
        return new Class[]{IWorkbenchAdapter.class, IDeferredWorkbenchAdapter.class};
    }

    private abstract class AbstractDeferredWorkbenchAdapter
    implements IDeferredWorkbenchAdapter {
        private AbstractDeferredWorkbenchAdapter() {
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        }

        public Object getParent(Object o) {
            return null;
        }
    }

    private static class CICSplexRepositoryAdapter
    implements IDeferredWorkbenchAdapter {
        private final ICICSplexRepository repository;

        public CICSplexRepositoryAdapter(ICICSplexRepository cicsPlexRepository) {
            this.repository = cicsPlexRepository;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString()), -1);
            ICICSplexRepository repository = (ICICSplexRepository)object;
            ICPSM cpsm = ((ICoreObject)repository).getCPSM();
            IContext context = repository.getIContext();
            WorkbenchAdapterFactory.getGroups(collector, monitor, cpsm, context);
            monitor.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return this.repository.mpCMASActive();
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            ICICSplexRepository repository = (ICICSplexRepository)object;
            ImageDescriptor descriptor = repository.mpCMASActive() ? UIPlugin.IMGD_CICSPLEX_REPOSITORY : UIPlugin.IMGD_INACTIVE_CICSPLEX_REPOSITORY;
            return descriptor;
        }

        public String getLabel(Object o) {
            return ((ICICSplexRepository)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }

    private static class DeferredElementCollector
    implements IElementCollector {
        private List<Object> allElements = new ArrayList<Object>();
        private IElementCollector collector;
        private IProgressMonitor monitor;

        public DeferredElementCollector(IElementCollector elementCollector, IProgressMonitor progressMonitor) {
            this.collector = elementCollector;
            this.monitor = progressMonitor;
        }

        public void add(Object[] elements, IProgressMonitor monitor) {
            this.allElements.addAll(Arrays.asList(elements));
        }

        public void add(Object element, IProgressMonitor monitor) {
            this.allElements.add(element);
        }

        public void done() {
            this.collector.add(this.allElements.toArray(), this.monitor);
        }
    }
}

