/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.decorators;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IChild;
import com.ibm.cics.core.model.ManagedRegionStatusType;
import com.ibm.cics.core.model.ModelUtilities;
import com.ibm.cics.core.model.extra.IWLMRoutersNode;
import com.ibm.cics.core.model.extra.IWLMTargetsNode;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.adapters.AdapterUtility;
import com.ibm.cics.explorer.tables.ui.TablesUIPlugin;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IManagedRegionStatus;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.sm.comm.IContext;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class CICSplexLabelDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CICSplexLabelDecorator.class.getPackage().getName());
    private static final String WORKLOAD_TARGET_DUMPING = " DUMPING";
    private static final String WORKLOAD_TARGET_SHORT_ON_STORAGE = " SOS";
    private static final String WORKLOAD_TARGET_AT_MAXTASKS = " MAXTASKS";
    private static final String WORKLOAD_TARGET_STALLED = " STALLED";

    public void decorate(Object element, IDecoration decoration) {
        Debug.enter((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)this, (Object)element, (Object)decoration);
        if (element instanceof ICICSplex) {
            ICPSM cpsm = (ICPSM)((IChild)element).getParent();
            if (cpsm.getConnection().isConnected() && AdapterUtility.cmasNameIsAvailable((ICICSplex)element)) {
                try {
                    int activeCount = cpsm.count(ManagedRegionStatusType.getInstance().getResourceTableName(), (IContext)new FilteredContext((IContext)new Context(((ICICSplex)element).getName()), new AttributeValue[]{AttributeValue.av((ICICSAttribute)ManagedRegionStatusType.CICSSTATE, (Object)IManagedRegionStatus.CicsstateValue.ACTIVE), AttributeValue.av((ICICSAttribute)ManagedRegionStatusType.RPTCMAS, (Object)((ICICSplex)element).getCMASName())}));
                    int inactiveCount = cpsm.count(ManagedRegionStatusType.getInstance().getResourceTableName(), (IContext)new FilteredContext((IContext)new Context(((ICICSplex)element).getName()), new AttributeValue[]{AttributeValue.av((ICICSAttribute)ManagedRegionStatusType.CICSSTATE, (Object)IManagedRegionStatus.CicsstateValue.INACTIVE), AttributeValue.av((ICICSAttribute)ManagedRegionStatusType.RPTCMAS, (Object)((ICICSplex)element).getCMASName())}));
                    int totalCount = activeCount + inactiveCount;
                    String suffix = " (" + activeCount + "/" + totalCount + ")";
                    Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)suffix);
                    decoration.addSuffix(suffix);
                }
                catch (CICSSystemManagerException e) {
                    Debug.error((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"Failed to decorate plex", (Throwable)e);
                }
            }
        } else if (element instanceof IManagedRegion && element instanceof IChild) {
            IManagedRegion managedRegion = (IManagedRegion)element;
            if (managedRegion.getState() == IManagedRegion.StateValue.ACTIVE) {
                IRegion region;
                ICICSplex cicsPlex = (ICICSplex)((IChild)element).getParent();
                String applId = managedRegion.getApplid();
                if ((applId == ICICSAttributeConstants.UNSUPPORTED_STRING || applId == null || applId.isEmpty()) && (region = ModelUtilities.findRegion((ICICSplex)cicsPlex, (String)managedRegion.getName())) != null) {
                    applId = region.getApplID();
                }
                String suffix = " (" + applId + ")";
                Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)managedRegion, (Object)suffix);
                decoration.addSuffix(suffix);
                ICPSM cpsm = (ICPSM)((IChild)cicsPlex).getParent();
                if (applId.equals(cpsm.getName())) {
                    Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)applId);
                    decoration.addOverlay(UIPlugin.IMGD_WUI, 2);
                }
            }
        } else if (element instanceof IWorkload) {
            IWorkload activeWorkload = (IWorkload)element;
            IWorkload.WorkloadStatusValue status = activeWorkload.getWorkloadStatus();
            String suffix = " (" + status + ")";
            decoration.addSuffix(suffix);
            if (status == IWorkload.WorkloadStatusValue.FROZEN) {
                Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate", (Object)activeWorkload);
                decoration.addOverlay(TablesUIPlugin.IMGD_ERROR_CONTENT_OVERLAY, 3);
            }
        } else if (element instanceof IWLMRoutersNode) {
            IWLMRoutersNode routersNode = (IWLMRoutersNode)element;
            String suffix = " (" + routersNode.getActiveRoutingRegions() + ")";
            decoration.addSuffix(suffix);
        } else if (element instanceof IWLMTargetsNode) {
            IWLMTargetsNode targetsNode = (IWLMTargetsNode)element;
            String suffix = " (" + targetsNode.getActiveTargetRegions() + ")";
            decoration.addSuffix(suffix);
        } else if (element instanceof IWorkloadTarget) {
            decoration.addSuffix(this.getWorkloadTargetDecorationSuffix((IWorkloadTarget)element));
        }
        Debug.exit((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"decorate");
    }

    private String getWorkloadTargetDecorationSuffix(IWorkloadTarget workloadTarget) {
        StringBuilder sb = new StringBuilder(" (");
        sb.append(workloadTarget.getStatus());
        if (workloadTarget.getHealthDump() == IWorkloadTarget.HealthDumpValue.YES) {
            sb.append(WORKLOAD_TARGET_DUMPING);
        }
        if (workloadTarget.getHealthShortOnStorage() == IWorkloadTarget.HealthShortOnStorageValue.YES) {
            sb.append(WORKLOAD_TARGET_SHORT_ON_STORAGE);
        }
        if (workloadTarget.getHealthMaxtasks() == IWorkloadTarget.HealthMaxtasksValue.YES) {
            sb.append(WORKLOAD_TARGET_AT_MAXTASKS);
        }
        if (workloadTarget.getHealthStall() == IWorkloadTarget.HealthStallValue.YES) {
            sb.append(WORKLOAD_TARGET_STALLED);
        }
        sb.append(")");
        return sb.toString();
    }

    public void addListener(ILabelProviderListener listener) {
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"addListener", (Object)(" " + this + " listener=" + listener));
        }
    }

    public void dispose() {
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)CICSplexLabelDecorator.class.getName(), (String)"dispose");
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

