/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.eclipse.common.WidgetProperties;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.ui.views.ContextScopeAutoCompleteField;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.TextContextDataLoader;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.explorer.tables.ui.DecoratorHelper;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSplex;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class TextContextComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(TextContextComposite.class);
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ICPSM cpsm;
    private Text scopeBox;
    private Text contextBox;
    private Button applyButton;
    Map<String, ICICSplex> cicsplexMap = new HashMap<String, ICICSplex>();
    Map<String, ICICSObject> regionAndGroupMap = new HashMap<String, ICICSObject>();
    private ContextScopeAutoCompleteField contextAutoCompleteField;
    private ContextScopeAutoCompleteField scopeAutoCompleteField;
    private TextContextDataLoader dataLoader;
    private static final int TYPING_DELAY_MILLIS = 300;
    IObservableValue<String> delayedContextText;

    public TextContextComposite(Composite parent) {
        super(parent, 0);
        this.createTextContextComposite();
    }

    protected void createTextContextComposite() {
        this.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.contextBox = new Text((Composite)this, 2048);
        this.contextBox.setMessage(Messages.getString("TextContextComposite.cicsplex", new Object[0]));
        this.contextBox.setToolTipText(Messages.getString("TextContextComposite.typeACicsplex", new Object[0]));
        this.contextBox.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).hint(80, -1).indent(5, 0).create());
        EnsureUppercaseListener.attach((Text)this.contextBox);
        this.contextAutoCompleteField = new ContextScopeAutoCompleteField((Control)this.contextBox);
        this.scopeBox = new Text((Composite)this, 2048);
        this.scopeBox.setMessage(Messages.getString("TextContextComposite.systemOrGroup", new Object[0]));
        this.scopeBox.setToolTipText(Messages.getString("TextContextComposite.typeASystem", new Object[0]));
        this.scopeBox.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).hint(80, -1).create());
        EnsureUppercaseListener.attach((Text)this.scopeBox);
        this.scopeAutoCompleteField = new ContextScopeAutoCompleteField((Control)this.scopeBox);
        this.applyButton = new Button((Composite)this, 8);
        this.applyButton.setText(Messages.getString("TextContextComposite.goButton", new Object[0]));
        this.applyButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).create());
        this.applyButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TextContextComposite.this.applyContext();
            }
        });
        this.delayedContextText = WidgetProperties.text((int)24).observeDelayed(300, (Widget)this.contextBox);
        this.delayedContextText.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                TextContextComposite.this.contextBox.setForeground(Display.getCurrent().getSystemColor(2));
                DecoratorHelper.clearInfo((Control)TextContextComposite.this.contextBox);
                TextContextComposite.this.validateInput();
                if (!TextContextComposite.this.scopeBox.getText().contentEquals(TextContextComposite.EMPTY_STRING)) {
                    TextContextComposite.this.scopeBox.setText(TextContextComposite.EMPTY_STRING);
                }
                TextContextComposite.this.clearScope();
            }
        });
        this.scopeBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextContextComposite.this.validateInput();
                TextContextComposite.this.scopeBox.setForeground(Display.getCurrent().getSystemColor(2));
                TextContextComposite.this.contextBox.setForeground(Display.getCurrent().getSystemColor(2));
            }
        });
        this.contextBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TextContextComposite.this.contextBox.setForeground(Display.getCurrent().getSystemColor(2));
            }

            public void focusLost(FocusEvent e) {
                TextContextComposite.this.contextBox.setForeground(Display.getCurrent().getSystemColor(2));
            }
        });
        this.contextBox.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 13 && this.validateInput()) {
                this.scopeBox.setFocus();
            }
        }));
        this.scopeBox.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            boolean valid = this.validateInput();
            if (e.keyCode == 13 && valid) {
                this.applyContext();
            }
        }));
        this.setEnabled(false);
    }

    private void applyContext() {
        String context = this.contextBox.getText();
        String scope = this.scopeBox.getText();
        ICICSObject selection = (ICICSObject)this.cicsplexMap.get(context);
        ICICSObject regionOrGroup = this.regionAndGroupMap != null ? this.regionAndGroupMap.get(scope) : null;
        debug.event("applyContext", new Object[]{context, selection, scope, regionOrGroup});
        if (regionOrGroup != null) {
            selection = regionOrGroup;
        }
        this.textContextSelection(selection);
    }

    public void setContextAndScope(String context, String scope) {
        this.contextAutoCompleteField.setEnabled(false);
        this.contextBox.setText(context);
        this.delayedContextText.getValue();
        this.contextAutoCompleteField.setEnabled(true);
        this.scopeAutoCompleteField.setEnabled(false);
        this.scopeBox.setText(scope);
        this.scopeAutoCompleteField.setEnabled(true);
        this.validateInput();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.contextBox.setEnabled(enabled);
        this.scopeBox.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
    }

    private boolean validateInput() {
        boolean validScope;
        boolean validContext;
        String context = this.contextBox.getText();
        String scope = this.scopeBox.getText();
        debug.enter("validateInput", (Object)context, (Object)scope);
        ICICSplex plex = this.cicsplexMap.get(context);
        boolean bl = validContext = plex != null;
        if (validContext) {
            DecoratorHelper.clearError((Control)this.contextBox);
        } else if (context.isEmpty() && scope.isEmpty()) {
            DecoratorHelper.clearError((Control)this.contextBox);
        } else {
            DecoratorHelper.errorControl((Control)this.contextBox, (String)Messages.getString("TextContextComposite.cicsplexNotFound", new Object[0]));
        }
        if (validContext && this.regionAndGroupMap == null) {
            this.dataLoader.loadRegionsAndGroups(plex, new TextContextDataLoader.RegionAndGroupLoaderListener(){

                @Override
                public void loadedRegionsOrGroups(ICICSplex cicsplex, Map<String, ICICSObject> regionsAndGroups) {
                    Display.getDefault().asyncExec(() -> {
                        if (cicsplex.getName().equals(TextContextComposite.this.contextBox.getText())) {
                            TextContextComposite.this.regionAndGroupMap = regionsAndGroups;
                            TextContextComposite.this.scopeAutoCompleteField.setProposals(TextContextComposite.this.regionAndGroupMap.keySet().toArray(EMPTY_STRING_ARRAY));
                            TextContextComposite.this.validateInput();
                        }
                    });
                }
            });
        }
        boolean bl2 = validScope = scope.isEmpty() || this.regionAndGroupMap != null && this.regionAndGroupMap.containsKey(scope);
        if (validScope || context.isEmpty()) {
            DecoratorHelper.clearError((Control)this.scopeBox);
        } else {
            DecoratorHelper.errorControl((Control)this.scopeBox, (String)Messages.getString("TextContextComposite.systemNotFound", new Object[0]));
        }
        if (context.isEmpty() && !scope.isEmpty()) {
            DecoratorHelper.errorControl((Control)this.contextBox, (String)Messages.getString("TextContextComposite.cicsplexRequired", new Object[0]));
        }
        this.applyButton.setEnabled(!context.isEmpty() && validContext && validScope && this.getEnabled());
        debug.exit("validateInput", Arrays.asList(validContext, validScope));
        return validContext && validScope;
    }

    public void setCPSM(ICPSM cpsm) {
        this.cpsm = cpsm;
        this.setEnabled(cpsm != null);
        this.validateInput();
        this.reset();
    }

    private void clearCICSplexes() {
        this.cicsplexMap.clear();
        this.contextAutoCompleteField.setProposals(EMPTY_STRING_ARRAY);
    }

    private void clearScope() {
        this.regionAndGroupMap = null;
        this.scopeAutoCompleteField.setProposals(EMPTY_STRING_ARRAY);
    }

    public void reset() {
        this.contextBox.setText(EMPTY_STRING);
        this.scopeBox.setText(EMPTY_STRING);
        this.clearCICSplexes();
        this.clearScope();
        if (this.cpsm != null) {
            this.dataLoader = new TextContextDataLoader(this.cpsm);
            this.dataLoader.loadCICSplexes(new TextContextDataLoader.CICSplexLoaderListener(){

                @Override
                public void loadedCICSplexes(Map<String, ICICSplex> cicsplexes) {
                    TextContextComposite.this.cicsplexMap = cicsplexes;
                    TextContextComposite.this.contextAutoCompleteField.setProposals(cicsplexes.keySet().toArray(EMPTY_STRING_ARRAY));
                    Display.getDefault().asyncExec(() -> TextContextComposite.this.validateInput());
                }
            });
        }
    }

    protected abstract void textContextSelection(ICICSObject var1);
}

