/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSDefinitionReference;
import com.ibm.cics.core.model.ResourceGroupEntryType;
import com.ibm.cics.core.model.ToReferenceAttribute;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSDefinitionReference;
import com.ibm.cics.model.ICICSDefinitionType;
import com.ibm.cics.model.IResourceGroupEntry;
import com.ibm.cics.model.IToReferenceAttribute;
import java.util.Arrays;
import java.util.List;

public class ResourceGroupEntryDefinitionReference<T extends ICICSDefinition>
extends ToReferenceAttribute<IResourceGroupEntry, T, ICICSDefinitionReference<T>>
implements IToReferenceAttribute<IResourceGroupEntry, T, ICICSDefinitionReference<T>> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final List<ICICSAttribute<?>> ATTRIBUTES = Arrays.asList(ResourceGroupEntryType.DEFINITION_NAME, ResourceGroupEntryType.DEFINITION_TYPE, ResourceGroupEntryType.DEFINITION_VERSION);
    private final ICICSDefinitionType<T> type;

    public ResourceGroupEntryDefinitionReference(ICICSDefinitionType<T> type) {
        super(type.getResourceTableName(), type);
        this.type = type;
    }

    public List<ICICSAttribute<?>> getAttributesUsedInReference() {
        return ATTRIBUTES;
    }

    public ICICSDefinitionReference<T> getTo(IResourceGroupEntry from) {
        return new CICSDefinitionReference<T>(this.type, from.getCICSContainer().getDREP(), from.getName(), from.getDefinitionVersion());
    }
}

