/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IChild;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.IParent;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.RegionsModel;
import com.ibm.cics.core.model.ResourcesModel;
import com.ibm.cics.core.model.internal.CICSplexGen;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMManagerContainer;
import com.ibm.cics.model.IList;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.HashMap;
import java.util.Map;

public class CICSplex
extends CICSplexGen
implements IContextProvider,
IChild,
IParent {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CICSplex.class);
    private ICPSM cpsm;
    private Map<ICICSType<?>, ICICSObject[]> childCache = new HashMap();
    private RegionsModel regions;

    public CICSplex(ICPSM parent, IContext context, SMConnectionRecord record) {
        super(parent, context, record);
        this.cpsm = parent;
    }

    public CICSplex(ICPSMManagerContainer container, AttributeValueMap avm) {
        super(container, avm);
    }

    public void dispose() {
        this.childCache.clear();
        this.regions = null;
    }

    @Override
    public String toString() {
        return "CICSplex@" + Integer.toHexString(this.hashCode()) + "[" + this.getName() + ", " + this.getCMASStatus() + ", " + this.getMPStatus() + "]";
    }

    private RegionsModel getRegions() {
        if (this.regions == null) {
            this.regions = this.cpsm.getRegions(this.getName());
        }
        return this.regions;
    }

    @Override
    public IList getChildren(ICICSType<?> type) {
        return null;
    }

    @Override
    public ICICSObject[] getChildrenAsArray(ICICSType<?> type) {
        ICICSObject[] toReturn = null;
        if (this.childCache.containsKey(type)) {
            toReturn = this.childCache.get(type);
        } else if (type == ManagedRegionType.getInstance()) {
            IManagedRegion[] managedRegionsObjectArray = this.cpsm.getManagedRegions(this);
            toReturn = managedRegionsObjectArray;
            this.childCache.put(ManagedRegionType.getInstance(), toReturn);
        } else if (type == RegionType.getInstance()) {
            try {
                toReturn = this.cpsm.getDefinitions2(RegionType.getInstance(), new Context(this.getName()));
                this.childCache.put(RegionType.getInstance(), toReturn);
            }
            catch (CICSSystemManagerException e) {
                debug.error("getChildrenAsArray", (Throwable)((Object)e));
            }
        }
        return toReturn;
    }

    @Override
    public ResourcesModel getChildrenAsModel(ICICSType<?> type) {
        if (type == RegionType.getInstance()) {
            return this.getRegions();
        }
        return null;
    }

    @Override
    public ICICSObject getParent() {
        return this.cpsm;
    }

    @Override
    public IContext getIContext() {
        return new Context(this.getName());
    }
}

