/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPIConnectionReference;
import com.ibm.cics.core.model.FEPIConnectionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IFEPIConnection;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class FEPIConnection
extends CICSResource
implements IFEPIConnection {
    private String _targetname;
    private String _nodename;
    private String _poolname;
    private Long _acquires;
    private Long _conversatns;
    private Long _unsolicinp;
    private Long _charssent;
    private Long _charsrecvd;
    private Long _recvtimeout;
    private Long _errors;
    private IFEPIConnection.AcqstatusValue _acqstatus;
    private IFEPIConnection.InstlstatusValue _instlstatus;
    private Long _lastacqcode;
    private IFEPIConnection.ServstatusValue _servstatus;
    private IFEPIConnection.StateValue _state;
    private Long _waitconvnum;
    private String _userdata;

    public FEPIConnection(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._targetname = (String)avm.getAttributeValue(FEPIConnectionType.TARGETNAME);
        this._nodename = (String)avm.getAttributeValue(FEPIConnectionType.NODENAME);
        this._poolname = (String)avm.getAttributeValue(FEPIConnectionType.POOLNAME, true);
        this._acquires = (Long)avm.getAttributeValue(FEPIConnectionType.ACQUIRES, true);
        this._conversatns = (Long)avm.getAttributeValue(FEPIConnectionType.CONVERSATNS, true);
        this._unsolicinp = (Long)avm.getAttributeValue(FEPIConnectionType.UNSOLICINP, true);
        this._charssent = (Long)avm.getAttributeValue(FEPIConnectionType.CHARSSENT, true);
        this._charsrecvd = (Long)avm.getAttributeValue(FEPIConnectionType.CHARSRECVD, true);
        this._recvtimeout = (Long)avm.getAttributeValue(FEPIConnectionType.RECVTIMEOUT, true);
        this._errors = (Long)avm.getAttributeValue(FEPIConnectionType.ERRORS, true);
        this._acqstatus = (IFEPIConnection.AcqstatusValue)avm.getAttributeValue(FEPIConnectionType.ACQSTATUS, true);
        this._instlstatus = (IFEPIConnection.InstlstatusValue)avm.getAttributeValue(FEPIConnectionType.INSTLSTATUS, true);
        this._lastacqcode = (Long)avm.getAttributeValue(FEPIConnectionType.LASTACQCODE, true);
        this._servstatus = (IFEPIConnection.ServstatusValue)avm.getAttributeValue(FEPIConnectionType.SERVSTATUS, true);
        this._state = (IFEPIConnection.StateValue)avm.getAttributeValue(FEPIConnectionType.STATE, true);
        this._waitconvnum = (Long)avm.getAttributeValue(FEPIConnectionType.WAITCONVNUM, true);
        this._userdata = (String)avm.getAttributeValue(FEPIConnectionType.USERDATA, true);
    }

    public FEPIConnection(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("TARGETNAME");
        this._targetname = (String)((CICSAttribute)FEPIConnectionType.TARGETNAME).get(stringValue, normalizers);
        stringValue = record.get("NODENAME");
        this._nodename = (String)((CICSAttribute)FEPIConnectionType.NODENAME).get(stringValue, normalizers);
        stringValue = record.get("POOLNAME");
        this._poolname = (String)((CICSAttribute)FEPIConnectionType.POOLNAME).get(stringValue, normalizers);
        stringValue = record.get("ACQUIRES");
        this._acquires = (Long)((CICSAttribute)FEPIConnectionType.ACQUIRES).get(stringValue, normalizers);
        stringValue = record.get("CONVERSATNS");
        this._conversatns = (Long)((CICSAttribute)FEPIConnectionType.CONVERSATNS).get(stringValue, normalizers);
        stringValue = record.get("UNSOLICINP");
        this._unsolicinp = (Long)((CICSAttribute)FEPIConnectionType.UNSOLICINP).get(stringValue, normalizers);
        stringValue = record.get("CHARSSENT");
        this._charssent = (Long)((CICSAttribute)FEPIConnectionType.CHARSSENT).get(stringValue, normalizers);
        stringValue = record.get("CHARSRECVD");
        this._charsrecvd = (Long)((CICSAttribute)FEPIConnectionType.CHARSRECVD).get(stringValue, normalizers);
        stringValue = record.get("RECVTIMEOUT");
        this._recvtimeout = (Long)((CICSAttribute)FEPIConnectionType.RECVTIMEOUT).get(stringValue, normalizers);
        stringValue = record.get("ERRORS");
        this._errors = (Long)((CICSAttribute)FEPIConnectionType.ERRORS).get(stringValue, normalizers);
        stringValue = record.get("ACQSTATUS");
        this._acqstatus = (IFEPIConnection.AcqstatusValue)((CICSAttribute)FEPIConnectionType.ACQSTATUS).get(stringValue, normalizers);
        stringValue = record.get("INSTLSTATUS");
        this._instlstatus = (IFEPIConnection.InstlstatusValue)((CICSAttribute)FEPIConnectionType.INSTLSTATUS).get(stringValue, normalizers);
        stringValue = record.get("LASTACQCODE");
        this._lastacqcode = (Long)((CICSAttribute)FEPIConnectionType.LASTACQCODE).get(stringValue, normalizers);
        stringValue = record.get("SERVSTATUS");
        this._servstatus = (IFEPIConnection.ServstatusValue)((CICSAttribute)FEPIConnectionType.SERVSTATUS).get(stringValue, normalizers);
        stringValue = record.get("STATE");
        this._state = (IFEPIConnection.StateValue)((CICSAttribute)FEPIConnectionType.STATE).get(stringValue, normalizers);
        stringValue = record.get("WAITCONVNUM");
        this._waitconvnum = (Long)((CICSAttribute)FEPIConnectionType.WAITCONVNUM).get(stringValue, normalizers);
        stringValue = record.get("USERDATA");
        this._userdata = (String)((CICSAttribute)FEPIConnectionType.USERDATA).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return FEPIConnectionType.TARGETNAME.internalToExternal((Object)this.getTargetname());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getTargetname() {
        return this._targetname;
    }

    public String getNodename() {
        return this._nodename;
    }

    public String getPoolname() {
        return this._poolname;
    }

    public Long getAcquires() {
        return this._acquires;
    }

    public Long getConversatns() {
        return this._conversatns;
    }

    public Long getUnsolicinp() {
        return this._unsolicinp;
    }

    public Long getCharssent() {
        return this._charssent;
    }

    public Long getCharsrecvd() {
        return this._charsrecvd;
    }

    public Long getRecvtimeout() {
        return this._recvtimeout;
    }

    public Long getErrors() {
        return this._errors;
    }

    public IFEPIConnection.AcqstatusValue getAcqstatus() {
        return this._acqstatus;
    }

    public IFEPIConnection.InstlstatusValue getInstlstatus() {
        return this._instlstatus;
    }

    public Long getLastacqcode() {
        return this._lastacqcode;
    }

    public IFEPIConnection.ServstatusValue getServstatus() {
        return this._servstatus;
    }

    public IFEPIConnection.StateValue getState() {
        return this._state;
    }

    public Long getWaitconvnum() {
        return this._waitconvnum;
    }

    public String getUserdata() {
        return this._userdata;
    }

    public FEPIConnectionType getObjectType() {
        return FEPIConnectionType.getInstance();
    }

    @Override
    public FEPIConnectionReference getCICSObjectReference() {
        return new FEPIConnectionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPIConnectionType.TARGETNAME) {
            return (V)this.getTargetname();
        }
        if (attribute == FEPIConnectionType.NODENAME) {
            return (V)this.getNodename();
        }
        if (attribute == FEPIConnectionType.POOLNAME) {
            return (V)this.getPoolname();
        }
        if (attribute == FEPIConnectionType.ACQUIRES) {
            return (V)this.getAcquires();
        }
        if (attribute == FEPIConnectionType.CONVERSATNS) {
            return (V)this.getConversatns();
        }
        if (attribute == FEPIConnectionType.UNSOLICINP) {
            return (V)this.getUnsolicinp();
        }
        if (attribute == FEPIConnectionType.CHARSSENT) {
            return (V)this.getCharssent();
        }
        if (attribute == FEPIConnectionType.CHARSRECVD) {
            return (V)this.getCharsrecvd();
        }
        if (attribute == FEPIConnectionType.RECVTIMEOUT) {
            return (V)this.getRecvtimeout();
        }
        if (attribute == FEPIConnectionType.ERRORS) {
            return (V)this.getErrors();
        }
        if (attribute == FEPIConnectionType.ACQSTATUS) {
            return (V)this.getAcqstatus();
        }
        if (attribute == FEPIConnectionType.INSTLSTATUS) {
            return (V)this.getInstlstatus();
        }
        if (attribute == FEPIConnectionType.LASTACQCODE) {
            return (V)this.getLastacqcode();
        }
        if (attribute == FEPIConnectionType.SERVSTATUS) {
            return (V)this.getServstatus();
        }
        if (attribute == FEPIConnectionType.STATE) {
            return (V)this.getState();
        }
        if (attribute == FEPIConnectionType.WAITCONVNUM) {
            return (V)this.getWaitconvnum();
        }
        if (attribute == FEPIConnectionType.USERDATA) {
            return (V)this.getUserdata();
        }
        return super.getAttributeValue(attribute);
    }
}

