/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPIConnectionReference;
import com.ibm.cics.core.model.FEPIConnectionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IFEPIConnection;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableFEPIConnection;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableFEPIConnection
extends MutableCICSResource
implements IMutableFEPIConnection {
    private IFEPIConnection delegate;
    private MutableSMRecord record;

    public MutableFEPIConnection(ICPSM cpsm, IContext context, IFEPIConnection cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("FEPICONN");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getTargetname() {
        return this.delegate.getTargetname();
    }

    public String getNodename() {
        return this.delegate.getNodename();
    }

    public String getPoolname() {
        return this.delegate.getPoolname();
    }

    public Long getAcquires() {
        return this.delegate.getAcquires();
    }

    public Long getConversatns() {
        return this.delegate.getConversatns();
    }

    public Long getUnsolicinp() {
        return this.delegate.getUnsolicinp();
    }

    public Long getCharssent() {
        return this.delegate.getCharssent();
    }

    public Long getCharsrecvd() {
        return this.delegate.getCharsrecvd();
    }

    public Long getRecvtimeout() {
        return this.delegate.getRecvtimeout();
    }

    public Long getErrors() {
        return this.delegate.getErrors();
    }

    public IFEPIConnection.AcqstatusValue getAcqstatus() {
        String result = this.record.get("ACQSTATUS");
        if (result == null) {
            return this.delegate.getAcqstatus();
        }
        return (IFEPIConnection.AcqstatusValue)((CICSAttribute)FEPIConnectionType.ACQSTATUS).get(result, this.record.getNormalizers());
    }

    public IFEPIConnection.InstlstatusValue getInstlstatus() {
        return this.delegate.getInstlstatus();
    }

    public Long getLastacqcode() {
        return this.delegate.getLastacqcode();
    }

    public IFEPIConnection.ServstatusValue getServstatus() {
        String result = this.record.get("SERVSTATUS");
        if (result == null) {
            return this.delegate.getServstatus();
        }
        return (IFEPIConnection.ServstatusValue)((CICSAttribute)FEPIConnectionType.SERVSTATUS).get(result, this.record.getNormalizers());
    }

    public IFEPIConnection.StateValue getState() {
        return this.delegate.getState();
    }

    public Long getWaitconvnum() {
        return this.delegate.getWaitconvnum();
    }

    public String getUserdata() {
        String result = this.record.get("USERDATA");
        if (result == null) {
            return this.delegate.getUserdata();
        }
        return (String)((CICSAttribute)FEPIConnectionType.USERDATA).get(result, this.record.getNormalizers());
    }

    public void setAcqstatus(IFEPIConnection.AcqstatusValue _acqstatus) {
        if (_acqstatus.equals((Object)this.delegate.getAcqstatus())) {
            this.record.set("ACQSTATUS", null);
        } else {
            FEPIConnectionType.ACQSTATUS.validate((Object)_acqstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPIConnectionType.ACQSTATUS).set(_acqstatus, this.record.getNormalizers());
            this.record.set("ACQSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setServstatus(IFEPIConnection.ServstatusValue _servstatus) {
        if (_servstatus.equals((Object)this.delegate.getServstatus())) {
            this.record.set("SERVSTATUS", null);
        } else {
            FEPIConnectionType.SERVSTATUS.validate((Object)_servstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPIConnectionType.SERVSTATUS).set(_servstatus, this.record.getNormalizers());
            this.record.set("SERVSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setUserdata(String _userdata) {
        if (_userdata.equals(this.delegate.getUserdata())) {
            this.record.set("USERDATA", null);
        } else {
            FEPIConnectionType.USERDATA.validate((Object)_userdata);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPIConnectionType.USERDATA).set(_userdata, this.record.getNormalizers());
            this.record.set("USERDATA", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPIConnectionType.TARGETNAME) {
            return (V)this.getTargetname();
        }
        if (attribute == FEPIConnectionType.NODENAME) {
            return (V)this.getNodename();
        }
        if (attribute == FEPIConnectionType.POOLNAME) {
            return (V)this.getPoolname();
        }
        if (attribute == FEPIConnectionType.ACQUIRES) {
            return (V)this.getAcquires();
        }
        if (attribute == FEPIConnectionType.CONVERSATNS) {
            return (V)this.getConversatns();
        }
        if (attribute == FEPIConnectionType.UNSOLICINP) {
            return (V)this.getUnsolicinp();
        }
        if (attribute == FEPIConnectionType.CHARSSENT) {
            return (V)this.getCharssent();
        }
        if (attribute == FEPIConnectionType.CHARSRECVD) {
            return (V)this.getCharsrecvd();
        }
        if (attribute == FEPIConnectionType.RECVTIMEOUT) {
            return (V)this.getRecvtimeout();
        }
        if (attribute == FEPIConnectionType.ERRORS) {
            return (V)this.getErrors();
        }
        if (attribute == FEPIConnectionType.ACQSTATUS) {
            return (V)this.getAcqstatus();
        }
        if (attribute == FEPIConnectionType.INSTLSTATUS) {
            return (V)this.getInstlstatus();
        }
        if (attribute == FEPIConnectionType.LASTACQCODE) {
            return (V)this.getLastacqcode();
        }
        if (attribute == FEPIConnectionType.SERVSTATUS) {
            return (V)this.getServstatus();
        }
        if (attribute == FEPIConnectionType.STATE) {
            return (V)this.getState();
        }
        if (attribute == FEPIConnectionType.WAITCONVNUM) {
            return (V)this.getWaitconvnum();
        }
        if (attribute == FEPIConnectionType.USERDATA) {
            return (V)this.getUserdata();
        }
        return super.getAttributeValue(attribute);
    }

    public FEPIConnectionType getObjectType() {
        return FEPIConnectionType.getInstance();
    }

    @Override
    public FEPIConnectionReference getCICSObjectReference() {
        return new FEPIConnectionReference(this.getCICSContainer(), this.getTargetname(), this.getNodename());
    }
}

