/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPIPoolReference;
import com.ibm.cics.core.model.FEPIPoolType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IFEPIPool;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableFEPIPool;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableFEPIPool
extends MutableCICSResource
implements IMutableFEPIPool {
    private IFEPIPool delegate;
    private MutableSMRecord record;

    public MutableFEPIPool(ICPSM cpsm, IContext context, IFEPIPool cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("FEPIPOOL");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getPoolname() {
        return this.delegate.getPoolname();
    }

    public Long getTargets() {
        return this.delegate.getTargets();
    }

    public Long getNodes() {
        return this.delegate.getNodes();
    }

    public Long getConnections() {
        return this.delegate.getConnections();
    }

    public Long getPeakconns() {
        return this.delegate.getPeakconns();
    }

    public Long getCurallcs() {
        return this.delegate.getCurallcs();
    }

    public Long getPeakallcs() {
        return this.delegate.getPeakallcs();
    }

    public Long getCurallcwait() {
        return this.delegate.getCurallcwait();
    }

    public Long getPeakallcwait() {
        return this.delegate.getPeakallcwait();
    }

    public Long getTotallocwait() {
        return this.delegate.getTotallocwait();
    }

    public Long getTotalloctout() {
        return this.delegate.getTotalloctout();
    }

    public String getBeginsession() {
        return this.delegate.getBeginsession();
    }

    public IFEPIPool.ContentionValue getContention() {
        return this.delegate.getContention();
    }

    public IFEPIPool.DeviceValue getDevice() {
        return this.delegate.getDevice();
    }

    public String getEndsession() {
        return this.delegate.getEndsession();
    }

    public String getExceptionq() {
        return this.delegate.getExceptionq();
    }

    public Long getFjournalnum() {
        return this.delegate.getFjournalnum();
    }

    public IFEPIPool.FormatValue getFormat() {
        return this.delegate.getFormat();
    }

    public IFEPIPool.InitialdataValue getInitialdata() {
        return this.delegate.getInitialdata();
    }

    public IFEPIPool.InstlstatusValue getInstlstatus() {
        return this.delegate.getInstlstatus();
    }

    public Long getMaxflength() {
        return this.delegate.getMaxflength();
    }

    public IFEPIPool.MsgjrnlValue getMsgjrnl() {
        return this.delegate.getMsgjrnl();
    }

    public String getPropertyset() {
        return this.delegate.getPropertyset();
    }

    public IFEPIPool.ServstatusValue getServstatus() {
        String result = this.record.get("SERVSTATUS");
        if (result == null) {
            return this.delegate.getServstatus();
        }
        return (IFEPIPool.ServstatusValue)((CICSAttribute)FEPIPoolType.SERVSTATUS).get(result, this.record.getNormalizers());
    }

    public String getStsn() {
        return this.delegate.getStsn();
    }

    public String getUnsoldata() {
        return this.delegate.getUnsoldata();
    }

    public IFEPIPool.UnsoldatackValue getUnsoldatack() {
        return this.delegate.getUnsoldatack();
    }

    public Long getWaitconvnum() {
        return this.delegate.getWaitconvnum();
    }

    public String getUserdata() {
        String result = this.record.get("USERDATA");
        if (result == null) {
            return this.delegate.getUserdata();
        }
        return (String)((CICSAttribute)FEPIPoolType.USERDATA).get(result, this.record.getNormalizers());
    }

    public String getFjournalname() {
        return this.delegate.getFjournalname();
    }

    public void setServstatus(IFEPIPool.ServstatusValue _servstatus) {
        if (_servstatus.equals((Object)this.delegate.getServstatus())) {
            this.record.set("SERVSTATUS", null);
        } else {
            FEPIPoolType.SERVSTATUS.validate((Object)_servstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPIPoolType.SERVSTATUS).set(_servstatus, this.record.getNormalizers());
            this.record.set("SERVSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setUserdata(String _userdata) {
        if (_userdata.equals(this.delegate.getUserdata())) {
            this.record.set("USERDATA", null);
        } else {
            FEPIPoolType.USERDATA.validate((Object)_userdata);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPIPoolType.USERDATA).set(_userdata, this.record.getNormalizers());
            this.record.set("USERDATA", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPIPoolType.POOLNAME) {
            return (V)this.getPoolname();
        }
        if (attribute == FEPIPoolType.TARGETS) {
            return (V)this.getTargets();
        }
        if (attribute == FEPIPoolType.NODES) {
            return (V)this.getNodes();
        }
        if (attribute == FEPIPoolType.CONNECTIONS) {
            return (V)this.getConnections();
        }
        if (attribute == FEPIPoolType.PEAKCONNS) {
            return (V)this.getPeakconns();
        }
        if (attribute == FEPIPoolType.CURALLCS) {
            return (V)this.getCurallcs();
        }
        if (attribute == FEPIPoolType.PEAKALLCS) {
            return (V)this.getPeakallcs();
        }
        if (attribute == FEPIPoolType.CURALLCWAIT) {
            return (V)this.getCurallcwait();
        }
        if (attribute == FEPIPoolType.PEAKALLCWAIT) {
            return (V)this.getPeakallcwait();
        }
        if (attribute == FEPIPoolType.TOTALLOCWAIT) {
            return (V)this.getTotallocwait();
        }
        if (attribute == FEPIPoolType.TOTALLOCTOUT) {
            return (V)this.getTotalloctout();
        }
        if (attribute == FEPIPoolType.BEGINSESSION) {
            return (V)this.getBeginsession();
        }
        if (attribute == FEPIPoolType.CONTENTION) {
            return (V)this.getContention();
        }
        if (attribute == FEPIPoolType.DEVICE) {
            return (V)this.getDevice();
        }
        if (attribute == FEPIPoolType.ENDSESSION) {
            return (V)this.getEndsession();
        }
        if (attribute == FEPIPoolType.EXCEPTIONQ) {
            return (V)this.getExceptionq();
        }
        if (attribute == FEPIPoolType.FJOURNALNUM) {
            return (V)this.getFjournalnum();
        }
        if (attribute == FEPIPoolType.FORMAT) {
            return (V)this.getFormat();
        }
        if (attribute == FEPIPoolType.INITIALDATA) {
            return (V)this.getInitialdata();
        }
        if (attribute == FEPIPoolType.INSTLSTATUS) {
            return (V)this.getInstlstatus();
        }
        if (attribute == FEPIPoolType.MAXFLENGTH) {
            return (V)this.getMaxflength();
        }
        if (attribute == FEPIPoolType.MSGJRNL) {
            return (V)this.getMsgjrnl();
        }
        if (attribute == FEPIPoolType.PROPERTYSET) {
            return (V)this.getPropertyset();
        }
        if (attribute == FEPIPoolType.SERVSTATUS) {
            return (V)this.getServstatus();
        }
        if (attribute == FEPIPoolType.STSN) {
            return (V)this.getStsn();
        }
        if (attribute == FEPIPoolType.UNSOLDATA) {
            return (V)this.getUnsoldata();
        }
        if (attribute == FEPIPoolType.UNSOLDATACK) {
            return (V)this.getUnsoldatack();
        }
        if (attribute == FEPIPoolType.WAITCONVNUM) {
            return (V)this.getWaitconvnum();
        }
        if (attribute == FEPIPoolType.USERDATA) {
            return (V)this.getUserdata();
        }
        if (attribute == FEPIPoolType.FJOURNALNAME) {
            return (V)this.getFjournalname();
        }
        return super.getAttributeValue(attribute);
    }

    public FEPIPoolType getObjectType() {
        return FEPIPoolType.getInstance();
    }

    @Override
    public FEPIPoolReference getCICSObjectReference() {
        return new FEPIPoolReference(this.getCICSContainer(), this.getPoolname());
    }
}

