/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ModeNameReference;
import com.ibm.cics.core.model.ModeNameType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IModeName;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableModeName;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableModeName
extends MutableCICSResource
implements IMutableModeName {
    private IModeName delegate;
    private MutableSMRecord record;

    public MutableModeName(ICPSM cpsm, IContext context, IModeName cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("MODENAME");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getConnection() {
        return this.delegate.getConnection();
    }

    public IModeName.AutoconnValue getAutoconn() {
        return this.delegate.getAutoconn();
    }

    public IModeName.ConnstatusValue getConnstatus() {
        String result = this.record.get("CONNSTATUS");
        if (result == null) {
            return this.delegate.getConnstatus();
        }
        return (IModeName.ConnstatusValue)((CICSAttribute)ModeNameType.CONNSTATUS).get(result, this.record.getNormalizers());
    }

    public Long getSessactv() {
        return this.delegate.getSessactv();
    }

    public Long getSessavail() {
        String result = this.record.get("SESSAVAIL");
        if (result == null) {
            return this.delegate.getSessavail();
        }
        return (Long)((CICSAttribute)ModeNameType.SESSAVAIL).get(result, this.record.getNormalizers());
    }

    public Long getSessmax() {
        return this.delegate.getSessmax();
    }

    public Long getSessmaxwin() {
        return this.delegate.getSessmaxwin();
    }

    public void setConnstatus(IModeName.ConnstatusValue _connstatus) {
        if (_connstatus.equals((Object)this.delegate.getConnstatus())) {
            this.record.set("CONNSTATUS", null);
        } else {
            ModeNameType.CONNSTATUS.validate((Object)_connstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ModeNameType.CONNSTATUS).set(_connstatus, this.record.getNormalizers());
            this.record.set("CONNSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setSessavail(Long _sessavail) {
        if (_sessavail.equals(this.delegate.getSessavail())) {
            this.record.set("SESSAVAIL", null);
        } else {
            ModeNameType.SESSAVAIL.validate((Object)_sessavail);
            String connectionSpecificExternalValue = ((CICSAttribute)ModeNameType.SESSAVAIL).set(_sessavail, this.record.getNormalizers());
            this.record.set("SESSAVAIL", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ModeNameType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ModeNameType.CONNECTION) {
            return (V)this.getConnection();
        }
        if (attribute == ModeNameType.AUTOCONN) {
            return (V)this.getAutoconn();
        }
        if (attribute == ModeNameType.CONNSTATUS) {
            return (V)this.getConnstatus();
        }
        if (attribute == ModeNameType.SESSACTV) {
            return (V)this.getSessactv();
        }
        if (attribute == ModeNameType.SESSAVAIL) {
            return (V)this.getSessavail();
        }
        if (attribute == ModeNameType.SESSMAX) {
            return (V)this.getSessmax();
        }
        if (attribute == ModeNameType.SESSMAXWIN) {
            return (V)this.getSessmaxwin();
        }
        return super.getAttributeValue(attribute);
    }

    public ModeNameType getObjectType() {
        return ModeNameType.getInstance();
    }

    @Override
    public ModeNameReference getCICSObjectReference() {
        return new ModeNameReference(this.getCICSContainer(), this.getConnection(), this.getName());
    }
}

