/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static boolean DEBUG_GENERAL = true;
    public static boolean FULL_RESPONSE_TRACE = !"true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.cics.sm.comm.sm/reducedTrace"));
    public static final String PLUGIN_ID = "com.ibm.cics.sm.comm.sm";
    private static String userAgent = "UNKNOWN";
    private static Activator plugin;
    private Logger logger;

    public void start(BundleContext context) throws Exception {
        this.logger = Logger.getLogger(PLUGIN_ID);
        if (DEBUG_GENERAL) {
            this.logger.setLevel(Level.FINER);
        }
        super.start(context);
        plugin = this;
        String cicsExplorerVersion = Activator.getFeatureVersion("com.ibm.cics.core.feature");
        String zosExplorerVersion = Activator.getFeatureVersion("com.ibm.cics.zos.feature");
        String jreVersion = System.getProperty("java.version", "unknown");
        String osName = System.getProperty("os.name");
        userAgent = "IBM_CICS_Explorer/" + cicsExplorerVersion + " IBM_zOS_Explorer/" + zosExplorerVersion + " JRE/" + jreVersion + " (" + osName + ")";
    }

    public static String getUserAgentString() {
        return userAgent;
    }

    private static String getFeatureVersion(String feature) {
        IBundleGroupProvider[] bundleGroupProviders = Platform.getBundleGroupProviders();
        if (bundleGroupProviders != null) {
            IBundleGroupProvider[] iBundleGroupProviderArray = bundleGroupProviders;
            int n = bundleGroupProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup[] bundleGroups;
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                int n3 = bundleGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup group = iBundleGroupArray[n4];
                    if (group.getIdentifier().equals(feature)) {
                        return group.getVersion();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return "unknown";
    }

    public static void logWarningToEclipse(String warning, Throwable exception) {
        ILog log = Activator.getDefault().getLog();
        log.log((IStatus)new Status(2, PLUGIN_ID, warning, exception));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

