/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.sm.comm.sm.internal.WorkingCriteria;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;

public final class SMCPSMComplexFilterVisitor
implements IFilterVisitor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Stack<WorkingCriteria> criteriaStack = new Stack();

    public void or() {
        WorkingCriteria operandTwo = this.criteriaStack.pop();
        WorkingCriteria operandOne = this.criteriaStack.pop();
        this.criteriaStack.push(operandOne.or(operandTwo));
    }

    public void and() {
        WorkingCriteria operandTwo = this.criteriaStack.pop();
        WorkingCriteria operandOne = this.criteriaStack.pop();
        this.criteriaStack.push(operandOne.and(operandTwo));
    }

    public void not() {
        this.criteriaStack.push(this.criteriaStack.pop().not());
    }

    public <T> void eq(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, FilterExpression.AttributeOperator.EQ, value));
    }

    public <T> void is(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, FilterExpression.AttributeOperator.IS, value));
    }

    public <T> void le(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, FilterExpression.AttributeOperator.LE, value));
    }

    public <T> void lt(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, FilterExpression.AttributeOperator.LT, value));
    }

    public <T> void ge(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, FilterExpression.AttributeOperator.GE, value));
    }

    public <T> void gt(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, FilterExpression.AttributeOperator.GT, value));
    }

    public <T> void ne(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, FilterExpression.AttributeOperator.NE, value));
    }

    private <T> WorkingCriteria getAttributeExpression(ICICSAttribute<T> attribute, FilterExpression.AttributeOperator operator, T value) {
        String extValue = attribute.internalToExternal(value);
        if (attribute.getType() == Date.class) {
            SimpleDateFormat cpsmCriteriaFormatter = new SimpleDateFormat("MM/dd/yyyy-HH:mm:ss");
            extValue = cpsmCriteriaFormatter.format((Date)value);
        }
        return WorkingCriteria.criterion(attribute.getCicsName(), extValue, operator);
    }

    public WorkingCriteria getWorkingCriteria() {
        if (this.criteriaStack.size() == 0) {
            return WorkingCriteria.nullCriteria();
        }
        if (this.criteriaStack.size() == 1) {
            return (WorkingCriteria)this.criteriaStack.get(0);
        }
        throw new IllegalStateException();
    }
}

