/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.core.connections.internal.IConnectionCustomizerDescriptor;
import com.ibm.cics.core.ui.internal.ConnectionCustomizerDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ConnectionCustomizerRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG_CUSTOMIZER = "customizer";
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_CONNECTIONID = "connectionId";
    private Set<IConnectionCustomizerDescriptor> customizers = new HashSet<IConnectionCustomizerDescriptor>();

    public ConnectionCustomizerRegistry() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cics.core.ui", "connectionCustomizers");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }

    private void readExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
    }

    private void readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_CUSTOMIZER)) {
            this.readCustomizer(element);
        }
    }

    private void readCustomizer(IConfigurationElement element) {
        this.customizers.add(new ConnectionCustomizerDescriptor(element));
    }

    public Set<IConnectionCustomizerDescriptor> getConnectionCustomizers() {
        return this.customizers;
    }
}

