/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.UnsupportedTypeException;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.AbstractRegionTypeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMManager;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;

public abstract class RootDeferredWorkbenchAdapter<M extends ICPSMManager, D extends IDefinition>
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(AbstractRegionTypeDeferredWorkbenchAdapter.class);
    private final ICICSType<M> objectType;
    private final ICICSType<D> definitionType;
    private IContext context;

    public RootDeferredWorkbenchAdapter(CloudInput cloudInput, IContext context, ICICSType<M> objectType, ICICSType<D> definitionType) {
        super(cloudInput);
        this.context = context;
        this.objectType = objectType;
        this.definitionType = definitionType;
    }

    @Override
    public Object[] getDataChildren(Object o) {
        List<Object> objectDefinitions;
        List<Object> objects;
        DEBUG.enter("getDataChildren");
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            objects = this.getObjects(this.context, this.objectType);
        }
        catch (SystemManagerConnectionException e) {
            objects = Collections.emptyList();
            children.add(new ErrorWrapper(e));
        }
        try {
            objectDefinitions = this.getObjects(this.context, this.definitionType);
        }
        catch (SystemManagerConnectionException e) {
            objectDefinitions = Collections.emptyList();
            children.add(new ErrorWrapper(e));
        }
        this.addMergedDefinitionsAndObjects(children, objects, objectDefinitions);
        DEBUG.exit("getDataChildren", children);
        return children.toArray();
    }

    private void addMergedDefinitionsAndObjects(List<Object> children, List<M> objects, List<D> definitions) {
        Iterator<D> iterator = definitions.iterator();
        while (iterator.hasNext()) {
            IDefinition definition = (IDefinition)iterator.next();
            M manager = this.findManager(objects, definition);
            if (manager == null) continue;
            iterator.remove();
        }
        Collections.sort(objects, new Comparator<M>(){

            @Override
            public int compare(M manager1, M manager2) {
                return RootDeferredWorkbenchAdapter.this.compare(manager1, manager2);
            }
        });
        children.addAll(objects);
        children.addAll(definitions);
    }

    private M findManager(List<M> objects, D definition) {
        for (ICPSMManager manager : objects) {
            if (!this.isDefinitionForObject(definition, manager)) continue;
            return (M)manager;
        }
        return null;
    }

    private <T extends ICICSObject> List<T> getObjects(IContext context, ICICSType<T> objectType) throws SystemManagerConnectionException {
        List results = Collections.emptyList();
        try {
            results = this.getCICSObjects(objectType, context);
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() instanceof UnsupportedTypeException) {
                DEBUG.event("getObjects, type " + ((UnsupportedTypeException)e.getCause()).getResourceTableName() + " unsupported", (Object)e);
            }
            if (e.getCause() != null && e.getCause() instanceof SystemManagerConnectionException) {
                DEBUG.event("getObjects", (Object)e);
                throw (SystemManagerConnectionException)e.getCause();
            }
            DEBUG.error("getObjects", (Throwable)e);
        }
        return results;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.getCloudInput().getCICSPlexName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return new RootJobRule();
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    protected abstract boolean isDefinitionForObject(D var1, M var2);

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_objects, null);
    }

    protected abstract int compare(M var1, M var2);

    private class RootJobRule
    implements ISchedulingRule {
        private RootJobRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof RootJobRule;
        }
    }
}

