/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.LocalFileType;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.PluginConstants;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.NewDefinitionWizardDropdownAction;
import com.ibm.cics.core.ui.adapters.CICSSystemsTreeAdapter;
import com.ibm.cics.core.ui.adapters.WorkbenchAdapterFactory;
import com.ibm.cics.core.ui.viewers.ExplorerTreeContentProvider;
import com.ibm.cics.core.ui.views.AbstractResourcesTreeView;
import com.ibm.cics.core.ui.views.EnableDisableDecoratorsAction;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.TextContextComposite;
import com.ibm.cics.explorer.tables.ui.internal.ContextAdapter;
import com.ibm.cics.explorer.tables.ui.internal.InternalTablesUIPlugin;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.ui.ICICSWorkbenchActionConstants;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class CICSplexView
extends AbstractResourcesTreeView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private EnableDisableDecoratorsAction enableDisableDecoratorsAction;
    private String initialMasNameToFocusOn;
    private String initialCICSPlexName;
    private ITreeViewerListener expansionListener;
    private ExplorerTreeContentProvider.Listener cicsplexChildrenResolvedListener;
    private Set<ICICSplex> watching = new HashSet<ICICSplex>();
    private static final Logger logger = Logger.getLogger(UIPlugin.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.core.ui.view.cicsplexes";
    private TextContextComposite textView;
    private boolean propagateSelectionChanges = true;
    private List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private ISelectionProvider selectionProvider = new ISelectionProvider(){

        public void setSelection(ISelection arg0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            List list = CICSplexView.this.selectionChangedListeners;
            synchronized (list) {
                CICSplexView.this.selectionChangedListeners.remove(listener);
            }
        }

        public ISelection getSelection() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            List list = CICSplexView.this.selectionChangedListeners;
            synchronized (list) {
                CICSplexView.this.selectionChangedListeners.add(listener);
            }
        }
    };

    @Override
    protected void fillContextMenu(IMenuManager aMenuManager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && this.showNewMenuForSelection(selection.getFirstElement())) {
            NewDefinitionWizardDropdownAction action = new NewDefinitionWizardDropdownAction();
            boolean enabled = UIPlugin.getDefault().getConnectionContextManager().canCreateCICSDefinition();
            action.setEnabled(enabled);
            aMenuManager.add((IAction)action);
        }
        for (String separatorName : ICICSWorkbenchActionConstants.getMenuSeparatorNames()) {
            aMenuManager.add((IContributionItem)new Separator(separatorName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySelectionChanged(ISelection selection) {
        SelectionChangedEvent newEvent = new SelectionChangedEvent(this.selectionProvider, selection);
        List<ISelectionChangedListener> list = this.selectionChangedListeners;
        synchronized (list) {
            for (ISelectionChangedListener selectionChangedListener : this.selectionChangedListeners) {
                selectionChangedListener.selectionChanged(newEvent);
            }
        }
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    protected void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IContributionItem)new Separator("enableDecorators"));
        toolBar.appendToGroup("enableDecorators", (IAction)this.enableDisableDecoratorsAction);
        super.fillToolBar(toolBar);
    }

    @Override
    protected void makeActions(IWorkbenchWindow window) {
        this.enableDisableDecoratorsAction = EnableDisableDecoratorsAction.getInstance();
        this.enableDisableDecoratorsAction.setToolTipText(EnableDisableDecoratorsAction.ACTION_STRING);
        this.enableDisableDecoratorsAction.setImageDescriptor(UIPlugin.IMGD_TOGGLE_SIMPLE);
        this.enableDisableDecoratorsAction.setChecked(this.enableDisableDecoratorsAction.areDecorationsOn());
        super.makeActions(window);
    }

    private boolean showNewMenuForSelection(Object selection) {
        return selection instanceof IManagedRegion || selection instanceof ICICSRegionDefinition || selection instanceof ICICSplex;
    }

    @Override
    protected void accessibilitySelectionHandling(AccessibleEvent e, Object selected) {
        if (selected != null && selected instanceof IManagedRegion) {
            IManagedRegion managedRegion = (IManagedRegion)selected;
            e.result = String.valueOf(managedRegion.getName()) + " " + (managedRegion.getState().equals((Object)IManagedRegion.StateValue.ACTIVE) ? Messages.getString("ResourcesView.status.active", new Object[0]) : Messages.getString("ResourcesView.status.inactive", new Object[0]));
        } else if (selected != null && selected instanceof ICICSplex) {
            e.result = ((ICICSplex)selected).getName();
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.expansionListener = new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                if (event.getElement() instanceof ICICSplex) {
                    CICSplexView.this.watching.add((ICICSplex)event.getElement());
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getElement() instanceof ICICSplex) {
                    CICSplexView.this.watching.remove((ICICSplex)event.getElement());
                }
            }
        };
        this.cicsplexChildrenResolvedListener = new ExplorerTreeContentProvider.Listener(){

            @Override
            public void updateComplete(ExplorerTreeContentProvider.ExplorerPendingUpdateAdapter adapter) {
                TreePath path = adapter.getPath();
                TreePath parentPath = path.getParentPath();
                Object element = parentPath.getLastSegment();
                if (element instanceof ICICSplex && CICSplexView.this.watching.remove(element)) {
                    IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)CICSplexView.this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                    progressService.schedule((Job)new AutoExpandJob((ICICSplex)element, parentPath));
                }
            }
        };
        this.contentProvider.addUpdateCompleteListener(this.cicsplexChildrenResolvedListener);
        this.viewer.addTreeListener(this.expansionListener);
        this.contentProvider.addUpdateCompleteListener(new ExplorerTreeContentProvider.Listener(){

            @Override
            public void updateComplete(ExplorerTreeContentProvider.ExplorerPendingUpdateAdapter adapter) {
                CICSplexView.this.attemptFocusTo(CICSplexView.this.initialCICSPlexName, CICSplexView.this.initialMasNameToFocusOn);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CICSplexView.this.propagateSelectionChanges) {
                    CICSplexView.this.notifySelectionChanged(event.getSelection());
                }
            }
        });
        InternalTablesUIPlugin.getDefault().getNavigationProvider().addNavigator((IWorkbenchPart)this);
    }

    @Override
    protected void createCompositeBar(Composite parent) {
        this.textView = new TextContextComposite(parent){

            @Override
            protected void textContextSelection(ICICSObject object) {
                try {
                    CICSplexView.this.propagateSelectionChanges = false;
                    CICSplexView.this.viewer.setSelection(null);
                }
                finally {
                    CICSplexView.this.propagateSelectionChanges = true;
                }
                CICSplexView.this.notifySelectionChanged((ISelection)new StructuredSelection((Object)object));
            }
        };
    }

    @Override
    protected void partControlsCreated() {
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                Object object = selection.getFirstElement();
                if (object != null) {
                    String context = "";
                    String scope = "";
                    IContext contextFor = ContextAdapter.getContextFor((ICICSType)LocalFileType.getInstance(), (Object)object);
                    if (contextFor != null) {
                        context = contextFor.getContext();
                        if (contextFor instanceof IScopedContext) {
                            scope = ((IScopedContext)contextFor).getScope();
                        }
                        CICSplexView.this.textView.setContextAndScope(context, scope);
                    }
                }
            }
        });
    }

    private void attemptFocusTo(String cicsPlexName, String masName) {
        if (cicsPlexName != null) {
            TreeItem[] treeItemArray = this.viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem cicsPlexTreeItem = treeItemArray[n2];
                Object data = cicsPlexTreeItem.getData();
                if (data instanceof ICICSplex && ((ICICSplex)data).getName().equals(cicsPlexName)) {
                    cicsPlexName = null;
                    this.viewer.getTree().showItem(cicsPlexTreeItem);
                    this.viewer.getTree().select(cicsPlexTreeItem);
                    if (masName == null) {
                        this.viewer.setSelection((ISelection)new StructuredSelection(data));
                    }
                    this.viewer.expandToLevel(data, 2);
                    break;
                }
                ++n2;
            }
            cicsPlexName = null;
        } else if (masName != null && this.viewer.getTree().getSelectionCount() == 1) {
            TreeItem cicsPlexTreeItem = this.viewer.getTree().getSelection()[0];
            TreeItem[] treeItemArray = cicsPlexTreeItem.getItems();
            int n = treeItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TreeItem regionTreeItem = treeItemArray[n3];
                Object data = regionTreeItem.getData();
                if (data instanceof IManagedRegion && ((IManagedRegion)data).getName().equals(masName)) {
                    this.viewer.getTree().showItem(regionTreeItem);
                    this.viewer.setSelection((ISelection)new StructuredSelection(data));
                    masName = null;
                    break;
                }
                ++n3;
            }
        }
    }

    @Override
    protected void connected(IConnectable cpsm) {
        if (Debug.DEBUG_CONNECTION) {
            Debug.enter((Logger)logger, (String)CICSplexView.class.getName(), (String)"connected", (Object)("cpsm=" + cpsm));
        }
        super.connected(cpsm);
        this.textView.setCPSM((ICPSM)cpsm);
        if (Debug.DEBUG_CONNECTION) {
            Debug.exit((Logger)logger, (String)CICSplexView.class.getName(), (String)"connected");
        }
    }

    @Override
    protected void disconnected(IConnectable cpms) {
        this.watching.clear();
        this.textView.setCPSM(null);
        super.disconnected(cpms);
    }

    @Override
    protected void refresh() {
        this.watching.clear();
        this.textView.reset();
        super.refresh();
    }

    @Override
    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof ICICSRegionDefinition) {
            return WorkbenchAdapterFactory.childlessCicsRegionDefinitionAdapter;
        }
        return super.getAdapter(element);
    }

    public void focusOn(String aCICSPlexName, String aMasName) {
        this.initialMasNameToFocusOn = aMasName;
        this.initialCICSPlexName = aCICSPlexName;
    }

    @Override
    protected String getHelpContextID() {
        return PluginConstants.CICSPLEX_VIEW_HELP_CTX_ID;
    }

    private class AutoExpandJob
    extends Job {
        private static final int SYSTEMS_EXPAND_LIMIT = 30;
        private ICICSplex plex;
        private TreePath path;

        public AutoExpandJob(ICICSplex plex, TreePath path) {
            super("Auto-expand systems node");
            this.plex = plex;
            this.path = path;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            final CICSSystemsTreeAdapter adapter = new CICSSystemsTreeAdapter(this.plex);
            try {
                if (adapter.getCICSSystemCount() <= 30) {
                    CICSplexView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!((AutoExpandJob)AutoExpandJob.this).CICSplexView.this.viewer.getTree().isDisposed()) {
                                ((AutoExpandJob)AutoExpandJob.this).CICSplexView.this.viewer.expandToLevel((Object)AutoExpandJob.this.path.createChildPath((Object)adapter), 2);
                            }
                        }
                    });
                }
            }
            catch (CICSSystemManagerException e) {
                logger.log(Level.INFO, "Failed to get the region count", e);
            }
            return Status.OK_STATUS;
        }
    }
}

