/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BiDiMap<K, V> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<K, V> keysMap = new HashMap();
    private Map<V, Set<K>> valuesMap = new HashMap<V, Set<K>>();

    public Map<K, V> getKeysMap() {
        return new KeysMap();
    }

    public Map<V, Set<K>> getValuesMap() {
        return new ValuesMap();
    }

    private class KeySet
    implements Set<K> {
        private V value;
        private HashSet<K> myKeys = new HashSet();

        public KeySet(V value) {
            this.value = value;
        }

        @Override
        public boolean add(K object) {
            if (!this.contains(object)) {
                this.myKeys.add(object);
                BiDiMap.this.getKeysMap().put(object, this.value);
                return true;
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            boolean changed = false;
            for (Object key : collection) {
                changed |= this.add((K)key);
            }
            return changed;
        }

        @Override
        public void clear() {
            Iterator keyIterator = this.iterator();
            while (keyIterator.hasNext()) {
                keyIterator.remove();
            }
        }

        @Override
        public boolean contains(Object object) {
            return this.myKeys.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.myKeys.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.myKeys.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private Iterator<K> myKeysIterator;
                private K lastKey;
                {
                    this.myKeysIterator = KeySet.this.myKeys.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.myKeysIterator.hasNext();
                }

                @Override
                public K next() {
                    this.lastKey = this.myKeysIterator.next();
                    return this.lastKey;
                }

                @Override
                public void remove() {
                    if (this.lastKey == null) {
                        throw new IllegalStateException();
                    }
                    this.myKeysIterator.remove();
                    BiDiMap.this.getKeysMap().remove(this.lastKey);
                    this.lastKey = null;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            if (this.myKeys.remove(object)) {
                BiDiMap.this.getKeysMap().remove(object);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object object : collection) {
                changed |= this.remove(object);
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean changed = false;
            Iterator kIterator = this.iterator();
            while (kIterator.hasNext()) {
                Object k = kIterator.next();
                if (collection.contains(k)) continue;
                changed = true;
                kIterator.remove();
            }
            return changed;
        }

        @Override
        public int size() {
            return this.myKeys.size();
        }

        @Override
        public Object[] toArray() {
            return this.myKeys.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.myKeys.toArray(array);
        }
    }

    private class KeysMap
    implements Map<K, V> {
        private KeysMap() {
        }

        @Override
        public void clear() {
            BiDiMap.this.keysMap.clear();
            BiDiMap.this.getValuesMap().clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return BiDiMap.this.keysMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return BiDiMap.this.keysMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private Iterator<Map.Entry<K, V>> keysIterator;
                        private Map.Entry<K, V> lastEntry;
                        {
                            this.keysIterator = BiDiMap.this.keysMap.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.keysIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            this.lastEntry = this.keysIterator.next();
                            return this.lastEntry;
                        }

                        @Override
                        public void remove() {
                            if (this.lastEntry == null) {
                                throw new IllegalStateException();
                            }
                            this.keysIterator.remove();
                            Object value = this.lastEntry.getValue();
                            BiDiMap.this.getValuesMap().get(value).remove(this.lastEntry.getKey());
                            this.lastEntry = null;
                        }
                    };
                }

                @Override
                public int size() {
                    return BiDiMap.this.keysMap.size();
                }
            };
        }

        @Override
        public V get(Object key) {
            return BiDiMap.this.keysMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return BiDiMap.this.keysMap.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private Iterator<K> keysIterator;
                        private K lastKey;
                        {
                            this.keysIterator = BiDiMap.this.keysMap.keySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.keysIterator.hasNext();
                        }

                        @Override
                        public K next() {
                            this.lastKey = this.keysIterator.next();
                            return this.lastKey;
                        }

                        @Override
                        public void remove() {
                            if (this.lastKey == null) {
                                throw new IllegalStateException();
                            }
                            Object value = BiDiMap.this.keysMap.get(this.lastKey);
                            this.keysIterator.remove();
                            BiDiMap.this.getValuesMap().get(value).remove(this.lastKey);
                            this.lastKey = null;
                        }
                    };
                }

                @Override
                public int size() {
                    return BiDiMap.this.keysMap.size();
                }
            };
        }

        @Override
        public V put(K key, V value) {
            Object currentValue = this.get(key);
            if (value == null && currentValue == null || value != null && value.equals(currentValue)) {
                return value;
            }
            Object oldValue = this.remove(key);
            BiDiMap.this.keysMap.put(key, value);
            Set keys = (Set)BiDiMap.this.valuesMap.get(value);
            if (keys == null) {
                keys = new KeySet(value);
                BiDiMap.this.valuesMap.put(value, keys);
            }
            keys.add(key);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            Set keys;
            Object oldValue = BiDiMap.this.keysMap.remove(key);
            if (oldValue != null && (keys = (Set)BiDiMap.this.valuesMap.get(oldValue)) != null) {
                keys.remove(key);
            }
            return oldValue;
        }

        @Override
        public int size() {
            return BiDiMap.this.keysMap.size();
        }

        @Override
        public Collection<V> values() {
            return new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<V> valuesIterator;
                        private V lastValue;
                        {
                            this.valuesIterator = BiDiMap.this.keysMap.values().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.valuesIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            this.lastValue = this.valuesIterator.next();
                            return this.lastValue;
                        }

                        @Override
                        public void remove() {
                            this.valuesIterator.remove();
                            BiDiMap.this.getValuesMap().remove(this.lastValue);
                            this.lastValue = null;
                        }
                    };
                }

                @Override
                public int size() {
                    return BiDiMap.this.keysMap.size();
                }
            };
        }
    }

    private class ValuesMap
    implements Map<V, Set<K>> {
        private ValuesMap() {
        }

        @Override
        public void clear() {
            for (Set keys : this.values()) {
                keys.clear();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            Set keysSet = (Set)BiDiMap.this.valuesMap.get(key);
            return keysSet != null && !keysSet.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            Set keys = (Set)BiDiMap.this.valuesMap.get(value);
            return keys != null && !keys.isEmpty();
        }

        @Override
        public Set<Map.Entry<V, Set<K>>> entrySet() {
            return new AbstractSet<Map.Entry<V, Set<K>>>(){

                @Override
                public Iterator<Map.Entry<V, Set<K>>> iterator() {
                    return new Iterator<Map.Entry<V, Set<K>>>(){
                        private Iterator<Map.Entry<V, Set<K>>> entryIterator;
                        private Map.Entry<V, Set<K>> lastEntry;
                        {
                            this.entryIterator = BiDiMap.this.valuesMap.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.entryIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<V, Set<K>> next() {
                            this.lastEntry = this.entryIterator.next();
                            return this.lastEntry;
                        }

                        @Override
                        public void remove() {
                            if (this.lastEntry == null) {
                                throw new IllegalStateException();
                            }
                            this.lastEntry.getValue().clear();
                            this.lastEntry = null;
                        }
                    };
                }

                @Override
                public int size() {
                    return BiDiMap.this.valuesMap.size();
                }
            };
        }

        @Override
        public Set<K> get(Object key) {
            return (Set)BiDiMap.this.valuesMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return BiDiMap.this.valuesMap.isEmpty();
        }

        @Override
        public Set<V> keySet() {
            return new AbstractSet<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<V> vIterator;
                        private V lastValue;
                        {
                            this.vIterator = BiDiMap.this.valuesMap.keySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.vIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            this.lastValue = this.vIterator.next();
                            return this.lastValue;
                        }

                        @Override
                        public void remove() {
                            if (this.lastValue == null) {
                                throw new IllegalStateException();
                            }
                            Set set = (Set)BiDiMap.this.valuesMap.get(this.lastValue);
                            set.clear();
                            this.lastValue = null;
                        }
                    };
                }

                @Override
                public int size() {
                    return BiDiMap.this.valuesMap.size();
                }
            };
        }

        @Override
        public Set<K> put(V key, Set<K> value) {
            throw new UnsupportedOperationException("Not sure what to do here.  The set must be a KeySet to function the right way...");
        }

        @Override
        public void putAll(Map<? extends V, ? extends Set<K>> map) {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<K> remove(Object key) {
            Set keySet = (Set)BiDiMap.this.valuesMap.get(key);
            if (keySet != null) {
                HashSet oldKeys = new HashSet();
                if (!keySet.isEmpty()) {
                    oldKeys.addAll(keySet);
                    keySet.clear();
                }
                return oldKeys;
            }
            return null;
        }

        @Override
        public int size() {
            return BiDiMap.this.valuesMap.size();
        }

        @Override
        public Collection<Set<K>> values() {
            return new AbstractCollection<Set<K>>(){

                @Override
                public Iterator<Set<K>> iterator() {
                    return new Iterator<Set<K>>(){
                        private Iterator<Set<K>> keySetsIterator;
                        private Set<K> lastKeySet;
                        {
                            this.keySetsIterator = BiDiMap.this.valuesMap.values().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.keySetsIterator.hasNext();
                        }

                        @Override
                        public Set<K> next() {
                            this.lastKeySet = this.keySetsIterator.next();
                            return this.lastKeySet;
                        }

                        @Override
                        public void remove() {
                            if (this.lastKeySet == null) {
                                throw new IllegalStateException();
                            }
                            this.lastKeySet.clear();
                            this.lastKeySet = null;
                        }
                    };
                }

                @Override
                public int size() {
                    return ValuesMap.this.size();
                }
            };
        }
    }
}

