/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.internal.AbstractCredentialsComposite;
import com.ibm.cics.core.connections.internal.CertificateComposite;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.UsernameAndPasswordComposite;
import com.ibm.cics.eclipse.common.editor.TitleAreaDialogErrorStateManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PasswordComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String hostName;
    private CredentialsMode credentialsMode;
    Combo credentialsCombo;
    private CredentialsConfiguration credentialsConfiguration;
    private List<CredentialsConfiguration> allCredentials = new ArrayList<CredentialsConfiguration>();
    Button createNewCredentialButton;
    Button useExistingCredentialButton;
    private String connectionDescription;
    private Label credentialsInfoLabel;
    private String thisIsTheFirstTimeToConnectMsg;
    private List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>(1);
    private ComboViewer credentialTypeCombo;
    private Composite stackComposite;
    private StackLayout stackLayout;
    private CredentialType initialCredentialType;
    private boolean canSwitchCredentialsMode;
    private AbstractCredentialsComposite currentCredentialsComposite;
    private UsernameAndPasswordComposite usernameAndPasswordComposite;
    private UsernameAndPasswordComposite oneTimePasswordComposite;
    private CertificateComposite keystoreComposite;
    private CertificateComposite smartcardComposite;
    private TitleAreaDialogErrorStateManager errorStateManager;
    private boolean supportsCertificateAuth;
    private boolean supportsMfaAuth;

    public PasswordComposite(Composite parent, boolean showUserID, boolean aPasswordSaveable, CredentialsMode mode, Collection<CredentialsConfiguration> allCredentials, boolean supportsCertificateAuth, boolean supportsMfaAuth, CredentialsConfiguration credentialsConfiguration, TitleAreaDialogErrorStateManager errorStateManager) {
        super(parent, 0);
        this.credentialsMode = mode;
        this.supportsCertificateAuth = supportsCertificateAuth;
        this.supportsMfaAuth = supportsMfaAuth;
        this.allCredentials.addAll(allCredentials);
        this.errorStateManager = errorStateManager;
        this.canSwitchCredentialsMode = this.doesModeSupportSwitchingCredentialType() && supportsCertificateAuth;
        this.credentialsConfiguration = credentialsConfiguration;
        if (credentialsConfiguration != null) {
            this.initialCredentialType = !credentialsConfiguration.isCertificateCredential() ? (credentialsConfiguration.isOneTimePassword() ? CredentialType.ONETIMEPASSWORD : CredentialType.PASSWORD) : (credentialsConfiguration.getCertificate().getSource().equals("SOURCE_CARD") ? CredentialType.SMARTCARD : CredentialType.KEYSTORE);
        }
        GridLayout gridLayout = new GridLayout(3, false);
        this.setLayout((Layout)gridLayout);
        if (mode == CredentialsMode.CREATE_FIRST_CREDENTIAL) {
            this.createUserInterfaceForFirstCredential();
        } else if (mode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL) {
            this.createUserInterfaceForNoCredential();
        }
        Composite createNewCredentialComposite = new Composite((Composite)this, 0);
        GridData layout = new GridData(4, 4, true, true);
        layout.horizontalSpan = 3;
        createNewCredentialComposite.setLayout((Layout)new GridLayout(3, false));
        createNewCredentialComposite.setLayoutData((Object)layout);
        this.createCredentialTypeCombo(createNewCredentialComposite, aPasswordSaveable, mode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL);
        this.stackComposite = new Composite(createNewCredentialComposite, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        GridData stackData = new GridData(4, 4, true, true);
        stackData.widthHint = 550;
        stackData.verticalIndent = 10;
        if (mode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL) {
            stackData.horizontalIndent = 20;
        }
        this.stackComposite.setLayoutData((Object)stackData);
        boolean addCredentialsTextbox = mode != CredentialsMode.AUTHENTICATE_CREDENTIAL;
        this.usernameAndPasswordComposite = new UsernameAndPasswordComposite(this.stackComposite, mode, aPasswordSaveable, this.hostName, addCredentialsTextbox, true);
        this.oneTimePasswordComposite = new UsernameAndPasswordComposite(this.stackComposite, mode, false, this.hostName, addCredentialsTextbox, mode == CredentialsMode.AUTHENTICATE_CREDENTIAL);
        this.keystoreComposite = new CertificateComposite(this.stackComposite, this.hostName, addCredentialsTextbox, "SOURCE_FILE");
        this.smartcardComposite = new CertificateComposite(this.stackComposite, this.hostName, addCredentialsTextbox, "SOURCE_CARD");
        if (this.initialCredentialType == CredentialType.KEYSTORE) {
            this.currentCredentialsComposite = this.keystoreComposite;
            this.keystoreComposite.populateCertificates(errorStateManager);
        } else if (this.initialCredentialType == CredentialType.SMARTCARD) {
            this.currentCredentialsComposite = this.smartcardComposite;
            this.smartcardComposite.populateCertificates(errorStateManager);
        } else {
            this.currentCredentialsComposite = this.initialCredentialType == CredentialType.ONETIMEPASSWORD ? this.oneTimePasswordComposite : this.usernameAndPasswordComposite;
        }
        this.stackLayout.topControl = this.currentCredentialsComposite;
        this.addListeners();
        if (mode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL) {
            this.useExistingCredentialButton.setSelection(true);
            this.currentCredentialsComposite.setEnabled(false);
            this.credentialsCombo.setEnabled(true);
            if (this.credentialsCombo.getSelectionIndex() == -1 && this.credentialsCombo.getItemCount() > 0) {
                this.credentialsCombo.select(0);
                this.credentialsConfiguration = this.allCredentials.get(0);
            }
        }
        if (mode == CredentialsMode.EDIT_CREDENTIAL && this.initialCredentialType == CredentialType.KEYSTORE) {
            this.keystoreComposite.selectCertificate(credentialsConfiguration);
        } else if (mode == CredentialsMode.EDIT_CREDENTIAL && this.initialCredentialType == CredentialType.SMARTCARD) {
            this.smartcardComposite.selectCertificate(credentialsConfiguration);
        }
    }

    private void createCredentialTypeCombo(Composite parent, boolean passwordSaveable, boolean indent) {
        List<CredentialType> credentialTypes = Arrays.asList(CredentialType.PASSWORD, CredentialType.ONETIMEPASSWORD, CredentialType.KEYSTORE, CredentialType.SMARTCARD);
        GridData data = new GridData(4, 4, true, true);
        if (indent) {
            data.horizontalIndent = 20;
        }
        data.verticalIndent = 5;
        data.horizontalSpan = 3;
        this.credentialTypeCombo = new ComboViewer(parent, 8);
        this.credentialTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == CredentialType.PASSWORD) {
                    return Messages.PasswordComposite_usernameAndPassword;
                }
                if (element == CredentialType.ONETIMEPASSWORD) {
                    return Messages.PasswordComposite_usernameMultiFactor;
                }
                if (element == CredentialType.KEYSTORE) {
                    return Messages.PasswordComposite_certificateFromKeystore;
                }
                return Messages.PasswordComposite_certificateFromSmartcard;
            }
        });
        this.credentialTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.credentialTypeCombo.setInput(credentialTypes);
        this.credentialTypeCombo.getCombo().setEnabled(this.canSwitchCredentialsMode);
        this.credentialTypeCombo.getCombo().setLayoutData((Object)data);
        if (this.initialCredentialType == null) {
            this.credentialTypeCombo.getCombo().select(credentialTypes.indexOf((Object)CredentialType.PASSWORD));
        }
        this.credentialTypeCombo.getCombo().select(credentialTypes.indexOf((Object)this.initialCredentialType));
        this.credentialTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CredentialType selectedCredentialType = (CredentialType)((Object)((StructuredSelection)event.getSelection()).getFirstElement());
                switch (selectedCredentialType) {
                    case ONETIMEPASSWORD: {
                        ((PasswordComposite)PasswordComposite.this).stackLayout.topControl = PasswordComposite.this.oneTimePasswordComposite;
                        PasswordComposite.this.currentCredentialsComposite = PasswordComposite.this.oneTimePasswordComposite;
                        break;
                    }
                    case PASSWORD: {
                        ((PasswordComposite)PasswordComposite.this).stackLayout.topControl = PasswordComposite.this.usernameAndPasswordComposite;
                        PasswordComposite.this.currentCredentialsComposite = PasswordComposite.this.usernameAndPasswordComposite;
                        break;
                    }
                    case KEYSTORE: {
                        ((PasswordComposite)PasswordComposite.this).stackLayout.topControl = PasswordComposite.this.keystoreComposite;
                        PasswordComposite.this.currentCredentialsComposite = PasswordComposite.this.keystoreComposite;
                        CertificateDetails currentCertificateKeystore = PasswordComposite.this.keystoreComposite.getCertificate();
                        if (PasswordComposite.this.keystoreComposite.getCertificateCombo().getItemCount() <= 0) {
                            PasswordComposite.this.keystoreComposite.populateCertificates(PasswordComposite.this.errorStateManager);
                        }
                        if (currentCertificateKeystore == null) break;
                        PasswordComposite.this.keystoreComposite.selectCertificate(currentCertificateKeystore);
                        break;
                    }
                    case SMARTCARD: {
                        ((PasswordComposite)PasswordComposite.this).stackLayout.topControl = PasswordComposite.this.smartcardComposite;
                        PasswordComposite.this.currentCredentialsComposite = PasswordComposite.this.smartcardComposite;
                        CertificateDetails currentCertificateSmartcard = PasswordComposite.this.smartcardComposite.getCertificate();
                        if (PasswordComposite.this.smartcardComposite.getCertificateCombo().getItemCount() <= 0) {
                            PasswordComposite.this.smartcardComposite.populateCertificates(PasswordComposite.this.errorStateManager);
                        }
                        if (currentCertificateSmartcard == null) break;
                        PasswordComposite.this.keystoreComposite.selectCertificate(currentCertificateSmartcard);
                        break;
                    }
                }
                PasswordComposite.this.stackComposite.layout();
                for (ModifyListener modifyListenber : PasswordComposite.this.modifyListeners) {
                    modifyListenber.modifyText(null);
                }
            }
        });
        if (this.credentialsMode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL || this.credentialsMode == CredentialsMode.EDIT_CREDENTIAL) {
            this.credentialTypeCombo.getCombo().setEnabled(false);
        }
    }

    private String getSomeCredentialTypesUnsupportedMessage(boolean supportsCertificate, boolean supportsMfa) {
        if (!supportsCertificate && !supportsMfa) {
            return Messages.PasswordComposite_certAndMfaUnsupported;
        }
        if (!supportsCertificate) {
            return Messages.PasswordComposite_certUnsupported;
        }
        if (!supportsMfa) {
            return Messages.PasswordComposite_mfaUnsupported;
        }
        return null;
    }

    private void createUserInterfaceForNoCredential() {
        this.credentialsInfoLabel = new Label((Composite)this, 64);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        data.widthHint = 350;
        this.credentialsInfoLabel.setLayoutData((Object)data);
        this.thisIsTheFirstTimeToConnectMsg = Messages.PasswordComposite_NoCrededneitials_Info;
        this.credentialsInfoLabel.setText(this.thisIsTheFirstTimeToConnectMsg);
        String unsupportedMessage = this.getSomeCredentialTypesUnsupportedMessage(this.supportsCertificateAuth, this.supportsMfaAuth);
        if (unsupportedMessage != null) {
            data = new GridData(16384, 0, false, false);
            data.horizontalIndent = 25;
            Label imageLabel = new Label((Composite)this, 0);
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(ConnectionsImages.getImage("WARNING"));
            Label textLabel = new Label((Composite)this, 64);
            data = new GridData(16384, 0, true, false);
            textLabel.setLayoutData((Object)data);
            textLabel.setText(unsupportedMessage);
        }
        this.useExistingCredentialButton = new Button((Composite)this, 16);
        this.useExistingCredentialButton.setText(Messages.PasswordComposite_UseExistingCredentialsInfo);
        data = new GridData(4, 0, true, false);
        data.verticalIndent = 5;
        data.horizontalSpan = 3;
        this.useExistingCredentialButton.setLayoutData((Object)data);
        Composite useOldCredentialComposite = new Composite((Composite)this, 0);
        GridData layout = new GridData(4, 4, true, true);
        layout.horizontalSpan = 3;
        useOldCredentialComposite.setLayout((Layout)new GridLayout(3, false));
        useOldCredentialComposite.setLayoutData((Object)layout);
        Label credentialsLabel = new Label(useOldCredentialComposite, 0);
        credentialsLabel.setText(Messages.PasswordComposite_credentialsLabel);
        data = new GridData(0, 0, false, false);
        data.horizontalIndent = 20;
        data.verticalIndent = 10;
        credentialsLabel.setLayoutData((Object)data);
        this.credentialsCombo = new Combo(useOldCredentialComposite, 2056);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 15;
        data.widthHint = 250;
        data.horizontalSpan = 2;
        data.verticalIndent = 7;
        this.credentialsCombo.setLayoutData((Object)data);
        for (CredentialsConfiguration credentialsConfiguration : this.allCredentials) {
            this.credentialsCombo.add(credentialsConfiguration.getName());
        }
        this.createNewCredentialButton = new Button((Composite)this, 16);
        this.createNewCredentialButton.setText(Messages.PasswordComposite_CreateLoginDetailsInfo);
        data = new GridData(4, 128, true, true);
        data.horizontalSpan = 3;
        data.verticalIndent = 10;
        this.createNewCredentialButton.setLayoutData((Object)data);
        this.credentialsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasswordComposite.this.credentialsConfiguration = (CredentialsConfiguration)PasswordComposite.this.allCredentials.get(PasswordComposite.this.credentialsCombo.getSelectionIndex());
            }
        });
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useExistingCredentials = PasswordComposite.this.useExistingCredentialButton.getSelection();
                PasswordComposite.this.credentialsCombo.setEnabled(useExistingCredentials);
                PasswordComposite.this.createNewCredentialButton.setSelection(!useExistingCredentials);
                PasswordComposite.this.credentialTypeCombo.getCombo().setEnabled(!useExistingCredentials && PasswordComposite.this.canSwitchCredentialsMode);
                PasswordComposite.this.currentCredentialsComposite.setEnabled(!useExistingCredentials);
                for (ModifyListener modifyListenber : PasswordComposite.this.modifyListeners) {
                    modifyListenber.modifyText(null);
                }
            }
        };
        this.createNewCredentialButton.addSelectionListener((SelectionListener)radioListener);
        this.useExistingCredentialButton.addSelectionListener((SelectionListener)radioListener);
        this.useExistingCredentialButton.setSelection(true);
    }

    private void createUserInterfaceForFirstCredential() {
        new Label((Composite)this, 0);
        Label credentialsInfoLabel = new Label((Composite)this, 64);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        data.widthHint = 400;
        credentialsInfoLabel.setLayoutData((Object)data);
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.PasswordComposite_MustAssignOrCreateForConfigurationWithNoCredentials);
        buffer.append(" ");
        buffer.append(Messages.PasswordComposite_NameHelpsToIdentifyInfo);
        credentialsInfoLabel.setText(buffer.toString());
    }

    private void addListeners() {
        ModifyListener controlModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (ModifyListener modifyListener : PasswordComposite.this.modifyListeners) {
                    modifyListener.modifyText(e);
                }
            }
        };
        this.usernameAndPasswordComposite.addListeners(controlModifyListener);
        this.oneTimePasswordComposite.addListeners(controlModifyListener);
        if (this.keystoreComposite != null) {
            this.keystoreComposite.addListeners(controlModifyListener);
        }
        if (this.smartcardComposite != null) {
            this.smartcardComposite.addListeners(controlModifyListener);
        }
        this.credentialTypeCombo.getCombo().addModifyListener(controlModifyListener);
    }

    public void setCredentials(CredentialsConfiguration credentialsConfiguration) {
        if (credentialsConfiguration == null) {
            return;
        }
        this.credentialsConfiguration = credentialsConfiguration;
        if (this.credentialsMode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL) {
            this.credentialsCombo.select(this.allCredentials.indexOf(credentialsConfiguration));
        } else if (this.credentialsMode != CredentialsMode.AUTHENTICATE_CREDENTIAL && this.credentialsMode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL) {
            this.currentCredentialsComposite.setCredentialsName(credentialsConfiguration.getName());
        }
    }

    public CredentialsConfiguration getCredentialsConfiguration() {
        return this.credentialsConfiguration;
    }

    public void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    public void setConnectionDescription(String aConnectionDescription) {
        this.connectionDescription = aConnectionDescription;
        if (this.credentialsInfoLabel != null) {
            String credentialsInfoLblMessage = MessageFormat.format(this.thisIsTheFirstTimeToConnectMsg, this.connectionDescription);
            this.credentialsInfoLabel.setText(credentialsInfoLblMessage);
        }
    }

    public boolean shouldCreateNewCredentials() {
        return this.createNewCredentialButton == null ? false : this.createNewCredentialButton.getSelection();
    }

    public CredentialType getCredentialType() {
        if (this.currentCredentialsComposite instanceof CertificateComposite) {
            String certificateSource = ((CertificateComposite)this.currentCredentialsComposite).getCertificateSource();
            if (certificateSource.equals("SOURCE_FILE")) {
                return CredentialType.KEYSTORE;
            }
            return CredentialType.SMARTCARD;
        }
        if (this.currentCredentialsComposite == this.oneTimePasswordComposite) {
            return CredentialType.ONETIMEPASSWORD;
        }
        return CredentialType.PASSWORD;
    }

    public void addModifyListener(ModifyListener aModifyListener) {
        this.modifyListeners.add(aModifyListener);
    }

    public AbstractCredentialsComposite getCurrentCredentialsComposite() {
        return this.currentCredentialsComposite;
    }

    public UsernameAndPasswordComposite getUsernameAndPasswordComposite() {
        return this.usernameAndPasswordComposite;
    }

    public UsernameAndPasswordComposite getOneTimePasswordComposite() {
        return this.oneTimePasswordComposite;
    }

    public CertificateComposite getKeystoreComposite() {
        return this.keystoreComposite;
    }

    public CertificateComposite getSmartcardComposite() {
        return this.smartcardComposite;
    }

    public void setInitialFocus() {
        if (this.currentCredentialsComposite.isEnabled()) {
            if (this.credentialsMode == CredentialsMode.CHANGE_PASSWORD || this.credentialsMode == CredentialsMode.AUTHENTICATE_CREDENTIAL) {
                if (this.getCredentialType() == CredentialType.ONETIMEPASSWORD) {
                    this.oneTimePasswordComposite.setPasswordTextFocus();
                    this.oneTimePasswordComposite.selectAllPassword();
                } else {
                    this.usernameAndPasswordComposite.setPasswordTextFocus();
                    this.usernameAndPasswordComposite.selectAllPassword();
                }
            } else if (this.getCredentialType() == CredentialType.PASSWORD) {
                if (StringUtil.hasContent((String)this.usernameAndPasswordComposite.getPassword())) {
                    this.usernameAndPasswordComposite.setPasswordTextFocus();
                    this.usernameAndPasswordComposite.selectAllPassword();
                } else {
                    this.currentCredentialsComposite.setUserIdTextFocus();
                    this.currentCredentialsComposite.selectAllUserId();
                }
            } else {
                this.currentCredentialsComposite.setUserIdTextFocus();
                this.currentCredentialsComposite.selectAllUserId();
            }
        }
    }

    public String getTitleMessage() {
        return this.currentCredentialsComposite.getTitleMessage();
    }

    private boolean doesModeSupportSwitchingCredentialType() {
        return this.credentialsMode != CredentialsMode.EDIT_CREDENTIAL && this.credentialsMode != CredentialsMode.CHANGE_PASSWORD && this.credentialsMode != CredentialsMode.AUTHENTICATE_CREDENTIAL;
    }

    public static enum CredentialType {
        PASSWORD,
        KEYSTORE,
        SMARTCARD,
        ONETIMEPASSWORD;

    }
}

