/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.AbstractFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FilteredContext
extends AbstractFilteredContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, String> filterCriteria = new HashMap<String, String>();

    public FilteredContext(IContext context, AttributeValue ... attributeValues) {
        super(context);
        AttributeValue[] attributeValueArray = attributeValues;
        int n = attributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeValue av = attributeValueArray[n2];
            this.setAttributeValue(av.ATTRIBUTE, av.VALUE);
            ++n2;
        }
    }

    public void setAttributeValue(String attribute, String value) {
        this.filterCriteria.put(attribute, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.filterCriteria.keySet();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.filterCriteria.get(attributeName);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Criteria: " + this.filterCriteria.toString();
    }

    public static AttributeValue av(String attribute, String value) {
        return new AttributeValue(attribute, value);
    }

    public static class AttributeValue {
        private final String ATTRIBUTE;
        private final String VALUE;

        public AttributeValue(String attribute, String value) {
            this.ATTRIBUTE = attribute;
            this.VALUE = value;
        }
    }
}

