/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.Activator;
import com.ibm.cics.core.comm.ExplorerHostnameVerifier;
import com.ibm.cics.core.comm.ExplorerKeyStoreManager;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.io.File;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CertificatesPreference
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CertificatesPreference.class);
    private static final String[] DBTYPES = new String[]{"JKS", "JCEKS", "PKCS12"};
    private static final String[] PROTOCOLS = new String[]{Messages.CertificatesPreference_default, "TLSv1.2", "TLSv1.3"};
    private static final String DBTYPE_DEFAULT = "JKS";
    private Text trustFileText;
    private Text trustPhraseText;
    private Text keyPhraseText;
    private Text keyFileText;
    private Combo keycombo;
    private Combo trustcombo;
    private Button useSameForBoth;
    private Button disableCheckBox;
    private Group trustGroup;
    private Group keyGroup;
    private Group smartcardGroup;
    private Group hostnameVerificationGroup;
    private Button trustBrowseButton;
    private Button keyBrowseButton;
    private Combo protocolCombo;
    private boolean canValidate = false;
    private Label keylabel2;
    private Label keylabel3;
    private Label keylabel4;
    private Text driverPathText;
    private Text driverPINText;
    private Button smartcardBrowseButton;
    private Button usePKCS11Button;
    private Button useWindowsButton;
    private Button disableHostnameVerificationCheckBox;

    public CertificatesPreference() {
    }

    public CertificatesPreference(String title) {
        super(title);
    }

    public CertificatesPreference(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        debug.enter("init");
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName()));
        debug.exit("init");
    }

    protected Control createContents(Composite parent) {
        debug.enter("createContents");
        this.canValidate = false;
        Composite major = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        major.setLayout((Layout)layout);
        major.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(major, 0);
        layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Text t3l1 = new Text(composite, 16392);
        t3l1.setText(Messages.CertificatesPreference_description);
        this.createTruststoreSection(composite);
        this.createKeystoreSection(composite);
        this.createSmartcardSection(composite);
        this.createHostnameVerificationSection(composite);
        this.useSameForBoth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.keyFileText.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keyFileText.setText(CertificatesPreference.this.trustFileText.getText());
                CertificatesPreference.this.keyBrowseButton.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keyPhraseText.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keyPhraseText.setText(CertificatesPreference.this.trustPhraseText.getText());
                CertificatesPreference.this.keycombo.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keycombo.setText(CertificatesPreference.this.trustcombo.getText());
                CertificatesPreference.this.validate();
            }
        });
        Group protocolGroup = new Group(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        protocolGroup.setLayout((Layout)layout);
        protocolGroup.setLayoutData((Object)new GridData(1808));
        protocolGroup.setText(Messages.CertificatesPreference_advanced);
        Text pgroupdescription = new Text((Composite)protocolGroup, 16394);
        pgroupdescription.setText(Messages.CertificatesPreference_advanced_message);
        GridData pgdLayoutdata = new GridData();
        pgdLayoutdata.horizontalSpan = 2;
        pgroupdescription.setLayoutData((Object)pgdLayoutdata);
        Label pgroupLabel = new Label((Composite)protocolGroup, 16384);
        pgroupLabel.setText(Messages.CertificatesPreference_protocol);
        this.protocolCombo = new Combo((Composite)protocolGroup, 2048);
        this.protocolCombo.setText(Messages.CertificatesPreference_default);
        this.protocolCombo.setItems(PROTOCOLS);
        this.protocolCombo.setToolTipText(Messages.CertificatesPreference_protocol_tooltip);
        IPreferenceStore store = this.getPreferenceStore();
        this.trustFileText.setText(store.getString("javax.net.ssl.trustStore"));
        this.trustPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getTrustStorePassphrase());
        this.trustcombo.setText(store.getString("com.ibm.cics.core.comm.truststore.dbType"));
        this.keyFileText.setText(store.getString("javax.net.ssl.keyStore"));
        this.keyPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getKeyStorePassphrase());
        this.keycombo.setText(store.getString("com.ibm.cics.core.comm.keystore.dbType"));
        this.useSameForBoth.setSelection(store.getBoolean("com.ibm.cics.core.comm.truststore.same"));
        this.disableCheckBox.setSelection(store.getBoolean("com.ibm.cics.core.comm.truststore.ignore"));
        this.driverPathText.setText(store.getString("com.ibm.cics.core.comm.smartcardDriverPath"));
        this.driverPINText.setText(ExplorerSecurityHelper.getSmartcardPin());
        boolean usePKCS11 = store.getBoolean("com.ibm.cics.core.comm.usePKCS11Driver");
        this.usePKCS11Button.setSelection(usePKCS11);
        this.useWindowsButton.setSelection(!usePKCS11);
        this.updatePKCS11Enablement(usePKCS11);
        String protoc = store.getString("com.ibm.cics.core.comm.security.protocol");
        if (protoc.equals("")) {
            protoc = Messages.CertificatesPreference_default;
        }
        this.protocolCombo.setText(protoc);
        this.enablementChecks(!this.disableCheckBox.getSelection());
        this.validationEnabled();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextID());
        debug.exit("createContents");
        return composite;
    }

    private void createTruststoreSection(Composite parent) {
        this.trustGroup = new Group(parent, 0);
        this.trustGroup.setText(Messages.CertificatesPreference_trust_store_detail);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.trustGroup.setLayout((Layout)layout);
        this.trustGroup.setLayoutData((Object)new GridData(768));
        this.disableCheckBox = new Button((Composite)this.trustGroup, 32);
        this.disableCheckBox.setText(Messages.CertificatesPreference_disable);
        this.disableCheckBox.setToolTipText(Messages.CertificatesPreference_disable_tooltip);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.disableCheckBox.setLayoutData((Object)gridData);
        this.disableCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.enablementChecks(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.validate();
            }
        });
        Text tl1 = new Text((Composite)this.trustGroup, 16392);
        tl1.setText(Messages.CertificatesPreference_trust_store_contains);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        tl1.setLayoutData((Object)data);
        Label l = new Label((Composite)this.trustGroup, 16384);
        l.setText(Messages.CertificatesPreference_File_name);
        this.trustFileText = new Text((Composite)this.trustGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.trustFileText, (Label)l);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.trustFileText.setLayoutData((Object)data);
        this.trustFileText.setToolTipText(Messages.CertificatesPreference_trust_store_contains);
        this.trustFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CertificatesPreference.this.useSameForBoth.getSelection()) {
                    CertificatesPreference.this.keyFileText.setText(CertificatesPreference.this.trustFileText.getText());
                }
                CertificatesPreference.this.validate();
            }
        });
        this.trustBrowseButton = this.createBrowseButton((Composite)this.trustGroup);
        this.trustBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.browse(Messages.CertificatesPreference_trust_file, CertificatesPreference.this.trustFileText);
            }
        });
        this.trustBrowseButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CertificatesPreference.this.browse(Messages.CertificatesPreference_trust_file, CertificatesPreference.this.trustFileText);
            }
        });
        l = new Label((Composite)this.trustGroup, 16384);
        l.setText(Messages.CertificatesPreference_passphrase);
        this.trustPhraseText = new Text((Composite)this.trustGroup, 0x400800);
        TextInput.setAccessibleLabel((Text)this.trustFileText, (Label)l);
        data = new GridData(768);
        this.trustPhraseText.setLayoutData((Object)data);
        this.trustPhraseText.setToolTipText(Messages.CertificatesPreference_passphrase);
        this.trustPhraseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CertificatesPreference.this.useSameForBoth.getSelection()) {
                    CertificatesPreference.this.keyPhraseText.setText(CertificatesPreference.this.trustPhraseText.getText());
                }
                CertificatesPreference.this.validate();
            }
        });
        new Label((Composite)this.trustGroup, 16384).setText(Messages.CertificatesPreference_dbtype);
        this.trustcombo = new Combo((Composite)this.trustGroup, 4);
        this.trustcombo.setItems(DBTYPES);
        this.trustcombo.setText(DBTYPE_DEFAULT);
        this.trustcombo.setToolTipText(Messages.CertificatesPreference_dbtype_tooltip);
        this.trustcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CertificatesPreference.this.useSameForBoth.getSelection()) {
                    CertificatesPreference.this.keycombo.setText(CertificatesPreference.this.trustcombo.getText());
                }
                CertificatesPreference.this.validate();
            }
        });
    }

    private void createKeystoreSection(Composite parent) {
        this.keyGroup = new Group(parent, 0);
        this.keyGroup.setText(Messages.CertificatesPreference_key_store_detail);
        GridData data = new GridData(4);
        this.keyGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.keyGroup.setLayout((Layout)layout);
        this.keyGroup.setLayoutData((Object)new GridData(768));
        data = new GridData();
        Text kl1 = new Text((Composite)this.keyGroup, 16392);
        kl1.setText(Messages.CertificatesPreference_key_store_contains);
        data.horizontalSpan = 4;
        kl1.setLayoutData((Object)data);
        this.useSameForBoth = new Button((Composite)this.keyGroup, 32);
        this.useSameForBoth.setText(Messages.CertificatesPreference_use_same);
        this.useSameForBoth.setToolTipText(Messages.CertificatesPreference_use_same_tooltip);
        data = new GridData();
        data.horizontalSpan = 4;
        this.useSameForBoth.setLayoutData((Object)data);
        data = new GridData();
        this.keylabel2 = new Label((Composite)this.keyGroup, 16384);
        this.keylabel2.setText(Messages.CertificatesPreference_File_name);
        this.keyFileText = new Text((Composite)this.keyGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.keyFileText, (Label)this.keylabel2);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.keyFileText.setLayoutData((Object)data);
        this.keyFileText.setToolTipText(Messages.CertificatesPreference_key_store_contains);
        this.keyFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CertificatesPreference.this.validate();
            }
        });
        this.keyBrowseButton = this.createBrowseButton((Composite)this.keyGroup);
        this.keyBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.browse(Messages.CertificatesPreference_key_file, CertificatesPreference.this.keyFileText);
            }
        });
        this.keyBrowseButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CertificatesPreference.this.browse(Messages.CertificatesPreference_key_file, CertificatesPreference.this.keyFileText);
            }
        });
        this.keylabel3 = new Label((Composite)this.keyGroup, 16384);
        this.keylabel3.setText(Messages.CertificatesPreference_passphrase);
        this.keyPhraseText = new Text((Composite)this.keyGroup, 0x400800);
        TextInput.setAccessibleLabel((Text)this.keyPhraseText, (Label)this.keylabel3);
        data = new GridData(768);
        this.keyPhraseText.setLayoutData((Object)data);
        this.keyPhraseText.setToolTipText(Messages.CertificatesPreference_passphrase);
        this.keyPhraseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CertificatesPreference.this.validate();
            }
        });
        this.keylabel4 = new Label((Composite)this.keyGroup, 16384);
        this.keylabel4.setText(Messages.CertificatesPreference_dbtype);
        this.keycombo = new Combo((Composite)this.keyGroup, 4);
        this.keycombo.setItems(DBTYPES);
        this.keycombo.setText(DBTYPE_DEFAULT);
        this.keycombo.setToolTipText(Messages.CertificatesPreference_dbtype_tooltip);
        this.keycombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.validate();
            }
        });
    }

    private void createSmartcardSection(Composite parent) {
        this.smartcardGroup = new Group(parent, 0);
        this.smartcardGroup.setText(Messages.CertificatesPreference_smartCardDetails);
        this.smartcardGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.smartcardGroup.setLayout((Layout)layout);
        this.smartcardGroup.setLayoutData((Object)new GridData(768));
        GridData data = new GridData();
        data.widthHint = 1000;
        Text s = new Text((Composite)this.smartcardGroup, 16456);
        s.setText(Messages.CertificatesPreference_smartcardDriverDescription);
        data.horizontalSpan = 4;
        s.setLayoutData((Object)data);
        this.useWindowsButton = new Button((Composite)this.smartcardGroup, 16);
        this.useWindowsButton.setText(Messages.CertificatesPreference_useWindowsCryptographyServices);
        data = new GridData(4, 0x1000000, true, false);
        this.useWindowsButton.setLayoutData((Object)data);
        data.horizontalSpan = 4;
        this.usePKCS11Button = new Button((Composite)this.smartcardGroup, 16);
        this.usePKCS11Button.setText(Messages.CertificatesPreference_usePKCS11Driver);
        this.usePKCS11Button.setLayoutData((Object)data);
        data.horizontalSpan = 4;
        data.verticalIndent = 5;
        data = new GridData(1);
        data.horizontalIndent = 20;
        Label l = new Label((Composite)this.smartcardGroup, 16384);
        l.setText(Messages.CertificatesPreference_driverPath);
        l.setLayoutData((Object)data);
        this.driverPathText = new Text((Composite)this.smartcardGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.driverPathText, (Label)l);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.driverPathText.setLayoutData((Object)data);
        this.driverPathText.setToolTipText(Messages.CertificatesPreference_driverPath);
        this.driverPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CertificatesPreference.this.usePKCS11Button.getSelection()) {
                    CertificatesPreference.this.validate();
                    ExplorerKeyStoreManager.removeAllSmartcardProviders();
                }
            }
        });
        this.smartcardBrowseButton = this.createBrowseButton((Composite)this.smartcardGroup);
        this.smartcardBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.browse(Messages.CertificatesPreference_driverPath, CertificatesPreference.this.driverPathText);
            }
        });
        this.smartcardBrowseButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CertificatesPreference.this.browse(Messages.CertificatesPreference_driverPath, CertificatesPreference.this.driverPathText);
            }
        });
        data = new GridData(1);
        data.horizontalIndent = 20;
        l = new Label((Composite)this.smartcardGroup, 16384);
        l.setText(Messages.CertificatesPreference_driverPIN);
        l.setLayoutData((Object)data);
        this.driverPINText = new Text((Composite)this.smartcardGroup, 0x400800);
        TextInput.setAccessibleLabel((Text)this.driverPathText, (Label)l);
        data = new GridData(1);
        data.horizontalSpan = 1;
        data.widthHint = 40;
        this.driverPINText.setLayoutData((Object)data);
        this.driverPINText.setToolTipText(Messages.CertificatesPreference_driverPIN);
        this.driverPINText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExplorerKeyStoreManager.removeAllSmartcardProviders();
            }
        });
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean usePKCS11 = CertificatesPreference.this.usePKCS11Button.getSelection();
                CertificatesPreference.this.updatePKCS11Enablement(usePKCS11);
                CertificatesPreference.this.validate();
                ExplorerKeyStoreManager.removeAllSmartcardProviders();
            }
        };
        this.useWindowsButton.addSelectionListener((SelectionListener)radioListener);
        this.usePKCS11Button.addSelectionListener((SelectionListener)radioListener);
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("win")) {
            this.useWindowsButton.setEnabled(false);
            this.usePKCS11Button.setSelection(true);
            this.getPreferenceStore().setValue("com.ibm.cics.core.comm.usePKCS11Driver", true);
        }
    }

    private void createHostnameVerificationSection(Composite parent) {
        this.hostnameVerificationGroup = new Group(parent, 0);
        this.hostnameVerificationGroup.setText(Messages.CertificatesPreference_sslHostnameVerification);
        this.hostnameVerificationGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.hostnameVerificationGroup.setLayout((Layout)layout);
        this.hostnameVerificationGroup.setLayoutData((Object)new GridData(768));
        Text s = new Text((Composite)this.hostnameVerificationGroup, 16456);
        s.setText(Messages.CertificatesPreference_hostnameOverrideDescription);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        s.setLayoutData((Object)data);
        this.disableHostnameVerificationCheckBox = new Button((Composite)this.hostnameVerificationGroup, 32);
        this.disableHostnameVerificationCheckBox.setText(Messages.CertificatesPreference_disableHostnameVerification);
        this.disableHostnameVerificationCheckBox.setToolTipText(Messages.CertificatesPreference_disableHostnameVerification);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.disableHostnameVerificationCheckBox.setLayoutData((Object)gridData);
        boolean allowOverride = Boolean.valueOf(System.getProperty(ExplorerHostnameVerifier.ALLOW_OVERRIDE_HOSTNAME_VERIFICATION, "true"));
        boolean forceOverride = Boolean.valueOf(System.getProperty(ExplorerHostnameVerifier.FORCE_OVERRIDE_HOSTNAME_VERIFICATION, "false"));
        this.disableHostnameVerificationCheckBox.setEnabled(allowOverride && !forceOverride);
        Boolean isOverriden = this.getPreferenceStore().getBoolean("com.ibm.cics.core.comm.overrideHostnameVerification");
        this.disableHostnameVerificationCheckBox.setSelection(isOverriden != false || forceOverride);
    }

    private Button createBrowseButton(Composite parent) {
        Button browseButton = new Button(parent, 0);
        browseButton.setText(Messages.CertificatesPreference_browse);
        browseButton.setToolTipText(Messages.CertificatesPreference_browse_tooltip);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        browseButton.setLayoutData((Object)data);
        return browseButton;
    }

    private String getHelpContextID() {
        return "com.ibm.cics.explorer.connection_certificate_management_preferences";
    }

    private void validationEnabled() {
        this.canValidate = true;
        this.validate();
    }

    private boolean validate() {
        debug.enter("validate");
        String message = "";
        if (this.canValidate) {
            message = !this.disableCheckBox.getSelection() ? ExplorerSecurityHelper.validateStoreDetail((String)this.trustFileText.getText(), (String)this.trustPhraseText.getText(), (String)this.trustcombo.getText(), (String)this.keyFileText.getText(), (String)this.keyPhraseText.getText(), (String)this.keycombo.getText()) : ExplorerKeyStoreManager.validateKeyStore((String)this.keyFileText.getText(), (String)this.keyPhraseText.getText(), (String)this.keycombo.getText());
            if (message.isEmpty() && this.usePKCS11Button.getSelection()) {
                message = this.validateDriverPath();
            }
            if ("Invalid_store_format_message".equals(message)) {
                this.setValid(false);
                this.setErrorMessage(Messages.Invalid_store_format_message);
            } else if (StringUtil.hasContent((String)message)) {
                if (!StringUtil.hasContent((String)message) || message.startsWith("DerInputStream") || message.startsWith("java.io.EOFException")) {
                    message = Messages.Invalid_keystore_format;
                }
                this.setValid(false);
                this.setErrorMessage(message);
            } else {
                this.setValid(true);
                this.setErrorMessage(null);
                this.setMessage(Messages.CertificatesPreference_message);
            }
        }
        debug.exit("validate", (Object)message);
        return !StringUtil.hasContent((String)message);
    }

    public boolean performOk() {
        debug.enter("performOk");
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("javax.net.ssl.trustStore", this.trustFileText.getText());
        store.setValue("com.ibm.cics.core.comm.truststore.dbType", this.trustcombo.getText());
        store.setValue("javax.net.ssl.keyStore", this.keyFileText.getText());
        store.setValue("com.ibm.cics.core.comm.keystore.dbType", this.keycombo.getText());
        store.setValue("com.ibm.cics.core.comm.truststore.same", this.useSameForBoth.getSelection());
        store.setValue("com.ibm.cics.core.comm.truststore.ignore", this.disableCheckBox.getSelection());
        store.setValue("com.ibm.cics.core.comm.usePKCS11Driver", this.usePKCS11Button.getSelection());
        store.setValue("com.ibm.cics.core.comm.smartcardDriverPath", this.driverPathText.getText());
        store.setValue("com.ibm.cics.core.comm.overrideHostnameVerification", this.disableHostnameVerificationCheckBox.getSelection());
        String protoc = this.protocolCombo.getText().trim();
        if (protoc.equals(Messages.CertificatesPreference_default)) {
            protoc = "";
        }
        store.setValue("com.ibm.cics.core.comm.security.protocol", protoc);
        InternalConnectionsPlugin.getDefault().getPassphraseManager().setTrustStorePassphrase(this.trustPhraseText.getText());
        InternalConnectionsPlugin.getDefault().getPassphraseManager().setKeyStorePassphrase(this.keyPhraseText.getText());
        ExplorerSecurityHelper.setSmartcardPin((String)this.driverPINText.getText());
        debug.exit("performOk", (Object)true);
        return true;
    }

    public void performDefaults() {
        debug.enter("performDefaults");
        this.canValidate = false;
        IPreferenceStore store = this.getPreferenceStore();
        this.trustFileText.setText(store.getDefaultString("javax.net.ssl.trustStore"));
        this.trustPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getTrustStorePassphrase());
        this.trustcombo.setText(store.getDefaultString("com.ibm.cics.core.comm.truststore.dbType"));
        this.useSameForBoth.setSelection(store.getDefaultBoolean("com.ibm.cics.core.comm.truststore.same"));
        this.keyFileText.setText(store.getDefaultString("javax.net.ssl.keyStore"));
        this.keyPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getKeyStorePassphrase());
        this.keycombo.setText(store.getDefaultString("com.ibm.cics.core.comm.keystore.dbType"));
        this.driverPathText.setText(store.getDefaultString("com.ibm.cics.core.comm.smartcardDriverPath"));
        this.driverPINText.setText(ExplorerSecurityHelper.getSmartcardPin());
        this.disableCheckBox.setSelection(store.getDefaultBoolean("com.ibm.cics.core.comm.truststore.ignore"));
        boolean usePKCS11 = store.getBoolean("com.ibm.cics.core.comm.usePKCS11Driver");
        this.usePKCS11Button.setSelection(usePKCS11);
        this.useWindowsButton.setSelection(!usePKCS11);
        this.updatePKCS11Enablement(usePKCS11);
        boolean allowOverride = Boolean.valueOf(System.getProperty(ExplorerHostnameVerifier.ALLOW_OVERRIDE_HOSTNAME_VERIFICATION, "true"));
        this.disableHostnameVerificationCheckBox.setEnabled(allowOverride);
        this.disableHostnameVerificationCheckBox.setSelection(false);
        String protoc = store.getDefaultString("com.ibm.cics.core.comm.security.protocol");
        if (protoc.equals("")) {
            protoc = Messages.CertificatesPreference_default;
        }
        this.protocolCombo.setText(protoc);
        this.enablementChecks(!this.disableCheckBox.getSelection());
        this.validationEnabled();
        debug.exit("performDefaults");
    }

    private void enablementChecks(boolean childselection) {
        debug.enter("enablementChecks", (Object)childselection);
        this.trustFileText.setEnabled(childselection);
        this.trustPhraseText.setEnabled(childselection);
        this.trustBrowseButton.setEnabled(childselection);
        this.trustcombo.setEnabled(childselection);
        debug.exit("enablementChecks");
    }

    private void updatePKCS11Enablement(boolean enabled) {
        this.driverPathText.setEnabled(enabled);
        this.driverPINText.setEnabled(enabled);
        this.smartcardBrowseButton.setEnabled(enabled);
    }

    private void browse(String dialogText, Text fileText) {
        FileDialog d = new FileDialog(this.getShell());
        d.setText(dialogText);
        String p = "";
        if (new File(fileText.getText()).getParentFile() != null) {
            p = new File(fileText.getText()).getParentFile().toString();
        }
        d.setFilterPath(p);
        String file = d.open();
        if (file != null) {
            fileText.setText(file);
            this.validate();
        }
    }

    private String validateDriverPath() {
        boolean isValid = true;
        String driverPath = this.driverPathText.getText();
        if (!driverPath.isEmpty()) {
            File file = new File(driverPath);
            if (!file.exists()) {
                isValid = false;
            } else if (file.isDirectory()) {
                isValid = false;
            }
        }
        return isValid ? "" : Messages.CertificatesPreference_invalidDriverPath;
    }

    public void dispose() {
        super.dispose();
    }
}

