/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CertificateDetails;

public class CredentialsConfiguration {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2010, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String id;
    private String name;
    private String userid;
    private String password;
    private boolean savePassword;
    private CertificateDetails certificate;
    private final Type type;
    private boolean oneTimePassword = false;

    public static CredentialsConfiguration createCredentialsConfigurationWithNewId(String name, String userID, String password, boolean savePwd) {
        return new CredentialsConfiguration(IDFactory.createNewId(), name, userID, password, savePwd);
    }

    public static CredentialsConfiguration createCredentialsConfigurationWithNewId(String name, String userID, CertificateDetails certificate) {
        return new CredentialsConfiguration(IDFactory.createNewId(), name, userID, certificate);
    }

    public CredentialsConfiguration(String id, String name, String userid, String password, boolean savePasswd) {
        this.id = id;
        this.name = name;
        this.userid = userid;
        this.password = password;
        this.savePassword = savePasswd;
        this.oneTimePassword = false;
        this.type = Type.PASSWORD;
    }

    private CredentialsConfiguration(String id, String name, String userid, String password, boolean savePassword, boolean oneTimePassword, Type type) {
        this.id = id;
        this.name = name;
        this.userid = userid;
        this.password = password;
        this.savePassword = savePassword;
        this.oneTimePassword = oneTimePassword;
        this.type = type;
    }

    public static CredentialsConfiguration createOneTimePasswordCredential(String id, String name, String userid) {
        return new CredentialsConfiguration(id, name, userid, null, false, true, Type.PASSWORD);
    }

    public static CredentialsConfiguration createOneTimePasswordCredential(String name, String userid) {
        return new CredentialsConfiguration(IDFactory.createNewId(), name, userid, null, false, true, Type.PASSWORD);
    }

    public CredentialsConfiguration(String id, String name, String userid, CertificateDetails certificate) {
        this.id = id;
        this.name = name;
        this.userid = userid;
        this.certificate = certificate;
        this.type = Type.CERTIFICATE;
    }

    public CredentialsConfiguration(CredentialsConfiguration other) {
        this.type = other.type;
        this.id = other.id;
        this.name = other.name;
        this.userid = other.userid;
        this.password = other.password;
        this.savePassword = other.savePassword;
        this.oneTimePassword = other.oneTimePassword;
        this.certificate = other.certificate;
    }

    public String getName() {
        return this.name;
    }

    public String getUserID() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getID() {
        return this.id;
    }

    public CertificateDetails getCertificate() {
        return this.certificate;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public void setUserID(String newUserID) {
        this.userid = newUserID;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean isOneTimePassword() {
        return this.oneTimePassword;
    }

    public void setOneTimePassword(boolean oneTimePassword) {
        this.oneTimePassword = oneTimePassword;
    }

    public boolean isCertificateCredential() {
        return this.type == Type.CERTIFICATE;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.savePassword ? 1231 : 1237);
        result = 31 * result + (this.oneTimePassword ? 1249 : 1259);
        result = 31 * result + (this.userid == null ? 0 : this.userid.hashCode());
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CredentialsConfiguration other = (CredentialsConfiguration)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.savePassword != other.savePassword) {
            return false;
        }
        if (this.oneTimePassword != other.oneTimePassword) {
            return false;
        }
        if (this.userid == null ? other.userid != null : !this.userid.equals(other.userid)) {
            return false;
        }
        if (this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        return String.valueOf(super.toString()) + (this.type == Type.PASSWORD ? "[id=" + this.id + ", name=" + this.name + ", userid=" + this.userid + ", password-is-empty=" + StringUtil.isEmpty((String)this.password) + ", savePassword=" + this.savePassword + ", oneTimePassword=" + this.oneTimePassword + "]" : "[id=" + this.id + ", name=" + this.name + ", userid=" + this.userid + ", certificateAlias=" + this.certificate + "]");
    }

    public void setID(String anID) {
        this.id = anID;
    }

    public void setName(String credentialsName) {
        this.name = credentialsName;
    }

    private static enum Type {
        PASSWORD,
        CERTIFICATE;

    }
}

