/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExplorerTrustStore {
    private static final Debug debug = new Debug(ExplorerTrustStore.class);
    private X509TrustManager trustManager;

    public ExplorerTrustStore(KeyStore ks) throws GeneralSecurityException {
        this.trustManager = this.initialiseTrustStore(ks);
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    private X509TrustManager initialiseTrustStore(KeyStore ts) throws GeneralSecurityException {
        X509TrustManager defaultTrustManager = null;
        TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        defaultTrustManagerFactory.init(ts);
        TrustManager[] trustManagerArray = defaultTrustManagerFactory.getTrustManagers();
        int n = trustManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager trustmanager = trustManagerArray[n2];
            if (trustmanager instanceof X509TrustManager && defaultTrustManager == null) {
                defaultTrustManager = (X509TrustManager)trustmanager;
            }
            ++n2;
        }
        debug.exit("initialiseTrustStore", defaultTrustManager);
        return defaultTrustManager;
    }
}

