/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IComplexFilteredContext;
import com.ibm.cics.sm.comm.ICompoundFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IOrderedContext;
import com.ibm.cics.sm.comm.IOverrideWarningCountContext;
import com.ibm.cics.sm.comm.IParameterisedContext;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.SortOrder;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.cics.sm.comm.context.IGroupContext;
import com.ibm.cics.sm.comm.context.ISystemParameterContext;
import com.ibm.cics.sm.comm.context.IWorkloadContext;
import com.ibm.cics.sm.comm.sm.IModelNames;
import com.ibm.cics.sm.comm.sm.internal.SMCPSMConnection;
import com.ibm.cics.sm.comm.sm.internal.WorkingCriteria;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestBuilder {
    private static final Debug debug = new Debug(RequestBuilder.class);
    private static final String URLENCODING_CHARSET = "ISO8859_1";
    private static final String PARAM_ORDERBY = "ORDERBY";
    private static final String CPSM_PARAMETER = "PARAMETER";
    private static final String CRITERIA = "CRITERIA";
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String csdGroupFromFilters;
    private String resourceType;
    private StringBuilder request = new StringBuilder();

    private RequestBuilder(String resourceType) {
        this.resourceType = resourceType;
    }

    private void addParameter(String name, String value) {
        if (this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("Illegal repeated parameter: " + name + "[" + value + "] had already been set previously set to [" + this.parameters.get(name) + "]");
        }
        this.parameters.put(name, value);
    }

    private void appendCPSMParameter(String name, String value) {
        String existingParameters = this.parameters.get(CPSM_PARAMETER);
        existingParameters = String.valueOf(existingParameters != null ? String.valueOf(existingParameters) + " " : "") + name + "(" + value + ")";
        this.parameters.put(CPSM_PARAMETER, existingParameters);
    }

    private String getQuery() {
        int separator = 63;
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            this.request.append((char)separator);
            separator = 38;
            this.request.append(param.getKey());
            String value = param.getValue();
            if (value == null) continue;
            this.request.append('=');
            this.request.append(RequestBuilder.urlEncode(value));
        }
        return this.request.toString();
    }

    private IContext handleFilteredContext(IContext context) {
        WorkingCriteria criteria = WorkingCriteria.nullCriteria();
        while (context instanceof IFilteredContext || context instanceof ICompoundFilteredContext || context instanceof IComplexFilteredContext) {
            if (context instanceof IFilteredContext) {
                criteria = criteria.and(WorkingCriteria.getWorkingCriteriaFromFilteredContext((IFilteredContext)context));
            } else if (context instanceof IComplexFilteredContext) {
                criteria = criteria.and(WorkingCriteria.getWorkingCriteriaFromComplexFilteredContext((IComplexFilteredContext)context));
            } else if (context instanceof ICompoundFilteredContext) {
                criteria = criteria.and(WorkingCriteria.getWorkingCriteriaFromCompoundFilteredContext((ICompoundFilteredContext)context));
            }
            context = ContextHelper.getParentContext((IContext)context);
        }
        if (!"".equals(criteria.getCriteria())) {
            this.addParameter(CRITERIA, criteria.getCriteria());
            this.csdGroupFromFilters = criteria.getCsdGroup();
        }
        return context;
    }

    private IContext handleGroupContext(IContext context) {
        IScopedContext scopedContext;
        if (context instanceof IDefinitionContext) {
            IDefinitionContext groupContext = (IDefinitionContext)context;
            context = groupContext instanceof IGroupContext ? ((IGroupContext)groupContext).getParentContext() : context;
            String groupName = groupContext.getResourceGroup();
            if (groupName != null) {
                this.appendCPSMParameter(context instanceof IScopedContext ? "CSDGROUP" : "RESGROUP", groupName);
                return context;
            }
        }
        if (context instanceof IScopedContext && IResourceTables.Helper.isCICSDefinition((String)this.resourceType) && (scopedContext = (IScopedContext)context).getScope() != null) {
            this.appendCPSMParameter("CSDGROUP", this.csdGroupFromFilters != null ? this.csdGroupFromFilters : "*");
        }
        return context;
    }

    private IContext handleOrderedContext(IContext context) {
        if (context instanceof IOrderedContext) {
            IOrderedContext oContext = (IOrderedContext)context;
            ArrayList sOrders = new ArrayList(oContext.getSortOrders());
            if (sOrders.size() > 0) {
                int count = 0;
                StringBuffer paramVal = new StringBuffer();
                Collections.reverse(sOrders);
                for (SortOrder sortOrder : sOrders) {
                    paramVal.append(String.valueOf(sortOrder.getAttribute()) + (sortOrder.getDirection() ? "" : "/D"));
                    if (++count >= sOrders.size()) continue;
                    paramVal.append(",");
                }
                this.addParameter(PARAM_ORDERBY, paramVal.toString());
            }
            context = oContext.getParentContext();
        }
        return context;
    }

    private IContext handleParameterizedContext(IContext context) {
        if (context instanceof IParameterisedContext) {
            IParameterisedContext parameterisedContext = (IParameterisedContext)context;
            for (String name : parameterisedContext.getParameterNames()) {
                this.appendCPSMParameter(name, parameterisedContext.getParameterValue(name));
            }
            context = parameterisedContext.getParentContext();
        }
        return context;
    }

    private IContext handleSystemParameterContext(IContext context) {
        if (context instanceof ISystemParameterContext) {
            ISystemParameterContext systemParameterContext = (ISystemParameterContext)context;
            this.appendCPSMParameter("PARMTYPE", systemParameterContext.getType());
            this.appendCPSMParameter("PARMSRCE", systemParameterContext.getSource());
            context = systemParameterContext.getParentContext();
        }
        return context;
    }

    private IContext handleOverrideWarningCountContext(IContext context) {
        if (context instanceof IOverrideWarningCountContext) {
            this.addParameter("OVERRIDEWARNINGCOUNT", null);
            return ((IOverrideWarningCountContext)context).getParentContext();
        }
        return context;
    }

    private void handleAssociationContext(IContext context) throws TypeNotFoundException {
        if (ContextHelper.getContextFrom((IContext)context, IAssociationContext.class) != null) {
            if (IResourceTables.Helper.isCSDDefinition((String)this.resourceType)) {
                return;
            }
            IAssociationContext associationContext = (IAssociationContext)ContextHelper.getContextFrom((IContext)context, IAssociationContext.class);
            String type = IModelNames.ModelNamesHelper.getModelName(associationContext.getResourceType());
            String name = associationContext.getResourceName();
            debug.event("handleAssociationContext", (Object)associationContext, (Object)type, (Object)name);
            this.addParameter("ASSOCIATION", String.valueOf(type) + "=" + name);
        }
    }

    private void handleWorkloadContext(IContext context, IContext parentContext) {
        if (RequestBuilder.requiresWorkloadParameter(this.resourceType)) {
            String workloadName = "*";
            Object workloadContext = null;
            if (parentContext instanceof IWorkloadContext) {
                workloadName = ((IWorkloadContext)parentContext).getWorkloadName();
            } else if (context instanceof IWorkloadContext) {
                workloadName = ((IWorkloadContext)context).getWorkloadName();
            }
            debug.event("appendWorkloadContext", workloadContext, (Object)workloadName);
            this.appendCPSMParameter("WORKLOAD", workloadName);
        }
    }

    private void handleContextAndScope(IContext context) {
        this.request.append('/');
        if (context.getContext() != null) {
            String scope;
            this.request.append(RequestBuilder.urlEncode(context.getContext()));
            if (context instanceof IScopedContext && (scope = ((IScopedContext)context).getScope()) != null && !"".equals(scope)) {
                this.request.append('/');
                this.request.append(RequestBuilder.urlEncode(scope));
            }
        }
    }

    public static String buildCREATERequest(IContext context) throws UnsupportedEncodingException {
        IContext parentContext;
        String request = "/" + RequestBuilder.urlEncode(context.getContext());
        if (context instanceof IGroupContext && (parentContext = ((IGroupContext)context).getParentContext()) instanceof IScopedContext) {
            request = String.valueOf(request) + "/" + RequestBuilder.urlEncode(((IScopedContext)parentContext).getScope());
        }
        return request;
    }

    public static String buildRequest(String resourceType, IContext context, boolean ordered, SMCPSMConnection.GetIntention getIntention, boolean parameterized, boolean systemParameter, boolean association) throws TypeNotFoundException {
        RequestBuilder requestBuilder = new RequestBuilder(resourceType);
        if (getIntention.equals((Object)SMCPSMConnection.GetIntention.CACHED_GET)) {
            requestBuilder.addParameter("NODISCARD", "NODISCARD");
        }
        if (getIntention.equals((Object)SMCPSMConnection.GetIntention.CACHED_GET) || getIntention.equals((Object)SMCPSMConnection.GetIntention.COUNT)) {
            requestBuilder.addParameter("SUMMONLY", null);
        }
        IContext parentContext = context;
        parentContext = requestBuilder.handleOverrideWarningCountContext(parentContext);
        if (ordered) {
            parentContext = requestBuilder.handleOrderedContext(parentContext);
        }
        parentContext = requestBuilder.handleFilteredContext(parentContext);
        if (parameterized) {
            parentContext = requestBuilder.handleParameterizedContext(parentContext);
        }
        if (systemParameter) {
            parentContext = requestBuilder.handleSystemParameterContext(parentContext);
        }
        parentContext = requestBuilder.handleGroupContext(parentContext);
        if (association) {
            requestBuilder.handleAssociationContext(parentContext);
        }
        requestBuilder.handleWorkloadContext(context, parentContext);
        requestBuilder.handleContextAndScope(parentContext);
        return requestBuilder.getQuery();
    }

    private static String urlEncode(String toEncode) {
        try {
            String encoded = URLEncoder.encode(toEncode, URLENCODING_CHARSET);
            encoded = encoded.replace("%27", "'");
            encoded = encoded.replace("%28", "(");
            encoded = encoded.replace("%29", ")");
            encoded = encoded.replace("+", "%20");
            encoded = encoded.replace("%22", "\"");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean requiresWorkloadParameter(String resourceType) {
        return resourceType.equals("WLMAROUT") || resourceType.equals("WLMATAFF") || resourceType.equals("WLMATGRP") || resourceType.equals("WLMATRAN") || resourceType.equals("WLMAWAOR") || resourceType.equals("WLMAWDEF") || resourceType.equals("WLMAWTOR");
    }
}

