/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.CICSNumericAttributeAggregation;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSLongAttributeHint;
import com.ibm.cics.model.query.LongAggregationQuery;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class LongAggregationQueryImpl
extends Node<CICSNumericAttributeAggregation>
implements LongAggregationQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TYPE_NAME = "LongAggregationType";
    private static final String FIELD_UNSPECIFIED = "unspecified";
    private static final String FIELD_UNSUPPORTED = "unsupported";
    private static final String FIELD_AVERAGE = "average";
    private static final String FIELD_MIN = "min";
    private static final String FIELD_MAX = "max";
    private static final String FIELD_SUM = "sum";
    private static final String FIELD_DIFFERENCE = "difference";
    private static final String FIELD_DISTINCT_VALUES = "distinctValues";
    private final ICICSAttribute<Long> attribute;
    private NodeParser<JsonObject, Optional<Double>> averageParser;
    private NodeParser<JsonObject, Optional<Long>> minParser;
    private NodeParser<JsonObject, Optional<Long>> sumParser;
    private NodeParser<JsonObject, Optional<Long>> maxParser;
    private NodeParser<JsonObject, Optional<String>> differenceParser;
    private NodeParser<JsonObject, Long> distinctValuesParser;
    private NodeParser<JsonObject, Long> unsupportedParser;
    private NodeParser<JsonObject, Long> unspecifiedParser;
    private Optional<Map.Entry<Long, NodeParser<JsonObject, Long>>> metaValueCountParser = Optional.empty();
    private boolean schemaSupportsMetaValues;

    public LongAggregationQueryImpl(ICICSAttribute<Long> attribute, boolean schemaSupportsMetaValues) {
        super(TYPE_NAME);
        this.attribute = attribute;
        this.schemaSupportsMetaValues = schemaSupportsMetaValues;
    }

    @Override
    public CICSNumericAttributeAggregation parseObject(JsonObject o) throws NodeParseException {
        Optional<Object> metaValue;
        if (this.metaValueCountParser.isPresent()) {
            Map.Entry<Long, NodeParser<JsonObject, Long>> entry = this.metaValueCountParser.get();
            metaValue = Optional.of(new AbstractMap.SimpleEntry<Long, Integer>(entry.getKey(), entry.getValue().parse(o).intValue()));
        } else {
            metaValue = Optional.empty();
        }
        return new CICSNumericAttributeAggregation(this.minParser.parse(o), this.maxParser.parse(o), this.averageParser.parse(o), this.sumParser.parse(o), this.differenceParser.parse(o), this.distinctValuesParser.parse(o).intValue(), this.unsupportedParser.parse(o).intValue(), this.unspecifiedParser.parse(o).intValue(), metaValue);
    }

    public LongAggregationQuery average() {
        this.averageParser = this.doubleField(FIELD_AVERAGE);
        return this;
    }

    public LongAggregationQuery min() {
        this.minParser = this.longField(FIELD_MIN);
        return this;
    }

    public LongAggregationQuery max() {
        this.maxParser = this.longField(FIELD_MAX);
        return this;
    }

    public LongAggregationQuery sum() {
        this.sumParser = this.longField(FIELD_SUM);
        return this;
    }

    public LongAggregationQuery difference() {
        this.differenceParser = this.stringField(FIELD_DIFFERENCE);
        return this;
    }

    public LongAggregationQuery distinctValues() {
        this.distinctValuesParser = this.longField(FIELD_DISTINCT_VALUES).nonNull();
        return this;
    }

    public LongAggregationQuery metaValueCounts() {
        if (this.schemaSupportsMetaValues) {
            this.metaValueCountParser = LongAggregationQueryImpl.getMetaValue(this.attribute).map(entry -> {
                String fieldName = (entry.getValue() == ICICSAttributeConstants.NA_CODE ? "na" : (String)entry.getKey()).toLowerCase(Locale.ROOT);
                return new AbstractMap.SimpleEntry<Long, NodeParser<JsonObject, Long>>((Long)entry.getValue(), this.longField(fieldName).nonNull());
            });
        }
        return this;
    }

    public LongAggregationQuery unsupported() {
        this.unsupportedParser = this.longField(FIELD_UNSUPPORTED).nonNull();
        return this;
    }

    public LongAggregationQuery unspecified() {
        this.unspecifiedParser = this.longField(FIELD_UNSPECIFIED).nonNull();
        return this;
    }

    public static Optional<Map.Entry<String, Long>> getMetaValue(ICICSAttribute<Long> attribute) {
        Map<String, Long> specialValues;
        ICICSLongAttributeHint hint = (ICICSLongAttributeHint)attribute.getHint(ICICSLongAttributeHint.class);
        if (hint != null && hint.hasSpecialValues() && (specialValues = hint.getSpecialValuesWithoutExtraValues()).size() > 0) {
            if ((specialValues = specialValues.entrySet().stream().filter(e -> e.getValue() != ICICSAttributeConstants.UNSPECIFIED_LONG).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() == 0) {
                return Optional.empty();
            }
            if (specialValues.size() == 1) {
                return Optional.of(specialValues.entrySet().iterator().next()).map(e -> new AbstractMap.SimpleImmutableEntry<String, Long>(((String)e.getKey()).toLowerCase(Locale.ROOT), (Long)e.getValue()));
            }
            throw new RuntimeException("Attribute with multiple special values found: " + attribute.getCicsName());
        }
        return Optional.empty();
    }
}

