/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IChild;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.IParent;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.ResourcesModel;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.context.ICMASContext;

public class ModelUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ModelUtilities.class);

    public static IRegion findRegion(ICICSplex cicsPlex, String regionName) {
        ICICSObject[] regions;
        IRegion regionToReturn = null;
        ICICSObject[] iCICSObjectArray = regions = ((IParent)cicsPlex).getChildrenAsArray(RegionType.getInstance());
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSObject icicsObject = iCICSObjectArray[n2];
            IRegion region = (IRegion)icicsObject;
            if (region.getName().equals(regionName)) {
                regionToReturn = region;
                break;
            }
            ++n2;
        }
        return regionToReturn;
    }

    public static ResourcesModel getRegions(IParent plex) {
        ResourcesModel regions = plex.getChildrenAsModel(RegionType.getInstance());
        return regions;
    }

    public static String findApplID(final IManagedRegion managedRegion) {
        ICoreObject coreObject = (ICoreObject)managedRegion;
        IPrimaryKey key = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
        ICPSM cpsm = coreObject.getCPSM();
        ICMASContext context = new ICMASContext(){

            public String getContext() {
                return managedRegion.getCMASName();
            }
        };
        String applId = null;
        if (managedRegion.getState() == IManagedRegion.StateValue.ACTIVE) {
            try {
                IRegion region;
                ICICSplex cicsPlex = null;
                cicsPlex = managedRegion instanceof IChild ? (ICICSplex)((IChild)managedRegion).getParent() : (ICICSplex)cpsm.get(CICSplexType.getInstance(), CICSplexType.getPrimaryKey((IContext)context, key.getContext(), managedRegion.getCMASName()));
                applId = managedRegion.getApplid();
                if ((applId == ICICSAttributeConstants.UNSUPPORTED_STRING || applId == null || applId.isEmpty()) && (region = ModelUtilities.findRegion(cicsPlex, managedRegion.getName())) != null) {
                    applId = region.getApplID();
                }
            }
            catch (CICSSystemManagerException e) {
                debug.event("findApplID", (Object)e);
            }
        }
        return applId;
    }
}

