/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CICSDefinitionReference;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.BASRepositoryImpl;
import com.ibm.cics.core.model.internal.CICSObject;
import com.ibm.cics.core.model.internal.CSDRepositoryImpl;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public abstract class CICSDefinition
extends CICSObject
implements ICICSDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NAME = "NAME";
    private static final String VERSION = "DEFVER";
    private static final String CHANGE_TIME = "CHANGETIME";
    private static final String CREATE_TIME = "CREATETIME";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CHANGEUSRID = "CHANGEUSRID";
    private static final String CHANGEAGREL = "CHANGEAGREL";
    private static final String CSDGROUP = "CSDGROUP";
    private final String name;
    private final Long version;
    private final Date createTime;
    private final Date changeTime;
    private final String description;
    private final String _changeusrid;
    private final String _changeagrel;
    private final String _csdgroup;
    private final ICICSDefinitionContainer container;

    protected CICSDefinition(ICICSDefinitionContainer container, AttributeValueMap avm) {
        super((ICICSObjectContainer<?>)container);
        this.container = container;
        this.name = (String)avm.getAttributeValue(AbstractCICSDefinitionType.NAME);
        this.version = (Long)avm.getAttributeValue(AbstractCICSDefinitionType.VERSION);
        this._csdgroup = (String)avm.getAttributeValue(AbstractCICSDefinitionType.CSDGROUP);
        this.changeTime = (Date)avm.getAttributeValue(AbstractCICSDefinitionType.CHANGE_TIME, true);
        this.createTime = (Date)avm.getAttributeValue(AbstractCICSDefinitionType.CREATE_TIME, true);
        this.description = (String)avm.getAttributeValue(AbstractCICSDefinitionType.DESCRIPTION, true);
        this._changeusrid = (String)avm.getAttributeValue(AbstractCICSDefinitionType.CHANGE_USER_ID, true);
        this._changeagrel = (String)avm.getAttributeValue(AbstractCICSDefinitionType.CHANGE_AGENT_RELEASE, true);
    }

    public CICSDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get(NAME);
        this.name = (String)((CICSAttribute)AbstractCICSDefinitionType.NAME).get(stringValue, normalizers);
        stringValue = record.get(VERSION);
        this.version = (Long)((CICSAttribute)AbstractCICSDefinitionType.VERSION).get(stringValue, normalizers);
        stringValue = record.get(CHANGE_TIME);
        this.changeTime = (Date)((CICSAttribute)AbstractCICSDefinitionType.CHANGE_TIME).get(stringValue, normalizers);
        stringValue = record.get(CREATE_TIME);
        this.createTime = (Date)((CICSAttribute)AbstractCICSDefinitionType.CREATE_TIME).get(stringValue, normalizers);
        stringValue = record.get(DESCRIPTION);
        this.description = (String)((CICSAttribute)AbstractCICSDefinitionType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get(CHANGEUSRID);
        this._changeusrid = (String)((CICSAttribute)AbstractCICSDefinitionType.CHANGE_USER_ID).get(stringValue, normalizers);
        stringValue = record.get(CHANGEAGREL);
        this._changeagrel = (String)((CICSAttribute)AbstractCICSDefinitionType.CHANGE_AGENT_RELEASE).get(stringValue, normalizers);
        stringValue = record.get(CSDGROUP);
        this._csdgroup = (String)((CICSAttribute)AbstractCICSDefinitionType.CSDGROUP).get(stringValue, normalizers);
        this.container = this.version == 0L ? new CSDRepositoryImpl(cpsm, context) : new BASRepositoryImpl(cpsm, context);
    }

    @Override
    public abstract CICSDefinitionReference<? extends ICICSDefinition> getCICSObjectReference();

    public ICICSDefinitionContainer getCICSContainer() {
        return this.container;
    }

    public IContext getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Long getVersion() {
        return this.version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getChangeUserID() {
        return this._changeusrid;
    }

    public String getChangeAgentRelease() {
        return this._changeagrel;
    }

    public String getCSDGroup() {
        return this._csdgroup;
    }

    @Override
    public <T> T getAttributeValue(IAttribute<T> attribute) {
        if (AbstractCICSDefinitionType.CHANGE_AGENT_RELEASE == attribute) {
            return (T)this.getChangeAgentRelease();
        }
        if (AbstractCICSDefinitionType.CHANGE_TIME == attribute) {
            return (T)this.getChangeTime();
        }
        if (AbstractCICSDefinitionType.CHANGE_USER_ID == attribute) {
            return (T)this.getChangeUserID();
        }
        if (AbstractCICSDefinitionType.CREATE_TIME == attribute) {
            return (T)this.getCreateTime();
        }
        if (AbstractCICSDefinitionType.CSDGROUP == attribute) {
            return (T)this.getCSDGroup();
        }
        if (AbstractCICSDefinitionType.DESCRIPTION == attribute) {
            return (T)this.getDescription();
        }
        if (AbstractCICSDefinitionType.NAME == attribute) {
            return (T)this.getName();
        }
        if (AbstractCICSDefinitionType.VERSION == attribute) {
            return (T)this.getVersion();
        }
        return super.getAttributeValue(attribute);
    }
}

