/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPINodeReference;
import com.ibm.cics.core.model.FEPINodeType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IFEPINode;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class FEPINode
extends CICSResource
implements IFEPINode {
    private String _nodename;
    private Long _acqnum;
    private IFEPINode.AcqstatusValue _acqstatus;
    private IFEPINode.InstlstatusValue _instlstatus;
    private Long _lastacqcode;
    private IFEPINode.ServstatusValue _servstatus;
    private String _userdata;

    public FEPINode(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._nodename = (String)avm.getAttributeValue(FEPINodeType.NODENAME);
        this._acqnum = (Long)avm.getAttributeValue(FEPINodeType.ACQNUM, true);
        this._acqstatus = (IFEPINode.AcqstatusValue)avm.getAttributeValue(FEPINodeType.ACQSTATUS, true);
        this._instlstatus = (IFEPINode.InstlstatusValue)avm.getAttributeValue(FEPINodeType.INSTLSTATUS, true);
        this._lastacqcode = (Long)avm.getAttributeValue(FEPINodeType.LASTACQCODE, true);
        this._servstatus = (IFEPINode.ServstatusValue)avm.getAttributeValue(FEPINodeType.SERVSTATUS, true);
        this._userdata = (String)avm.getAttributeValue(FEPINodeType.USERDATA, true);
    }

    public FEPINode(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NODENAME");
        this._nodename = (String)((CICSAttribute)FEPINodeType.NODENAME).get(stringValue, normalizers);
        stringValue = record.get("ACQNUM");
        this._acqnum = (Long)((CICSAttribute)FEPINodeType.ACQNUM).get(stringValue, normalizers);
        stringValue = record.get("ACQSTATUS");
        this._acqstatus = (IFEPINode.AcqstatusValue)((CICSAttribute)FEPINodeType.ACQSTATUS).get(stringValue, normalizers);
        stringValue = record.get("INSTLSTATUS");
        this._instlstatus = (IFEPINode.InstlstatusValue)((CICSAttribute)FEPINodeType.INSTLSTATUS).get(stringValue, normalizers);
        stringValue = record.get("LASTACQCODE");
        this._lastacqcode = (Long)((CICSAttribute)FEPINodeType.LASTACQCODE).get(stringValue, normalizers);
        stringValue = record.get("SERVSTATUS");
        this._servstatus = (IFEPINode.ServstatusValue)((CICSAttribute)FEPINodeType.SERVSTATUS).get(stringValue, normalizers);
        stringValue = record.get("USERDATA");
        this._userdata = (String)((CICSAttribute)FEPINodeType.USERDATA).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return FEPINodeType.NODENAME.internalToExternal((Object)this.getNodename());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getNodename() {
        return this._nodename;
    }

    public Long getAcqnum() {
        return this._acqnum;
    }

    public IFEPINode.AcqstatusValue getAcqstatus() {
        return this._acqstatus;
    }

    public IFEPINode.InstlstatusValue getInstlstatus() {
        return this._instlstatus;
    }

    public Long getLastacqcode() {
        return this._lastacqcode;
    }

    public IFEPINode.ServstatusValue getServstatus() {
        return this._servstatus;
    }

    public String getUserdata() {
        return this._userdata;
    }

    public FEPINodeType getObjectType() {
        return FEPINodeType.getInstance();
    }

    @Override
    public FEPINodeReference getCICSObjectReference() {
        return new FEPINodeReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPINodeType.NODENAME) {
            return (V)this.getNodename();
        }
        if (attribute == FEPINodeType.ACQNUM) {
            return (V)this.getAcqnum();
        }
        if (attribute == FEPINodeType.ACQSTATUS) {
            return (V)this.getAcqstatus();
        }
        if (attribute == FEPINodeType.INSTLSTATUS) {
            return (V)this.getInstlstatus();
        }
        if (attribute == FEPINodeType.LASTACQCODE) {
            return (V)this.getLastacqcode();
        }
        if (attribute == FEPINodeType.SERVSTATUS) {
            return (V)this.getServstatus();
        }
        if (attribute == FEPINodeType.USERDATA) {
            return (V)this.getUserdata();
        }
        return super.getAttributeValue(attribute);
    }
}

