/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPITargetReference;
import com.ibm.cics.core.model.FEPITargetType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IFEPITarget;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class FEPITarget
extends CICSResource
implements IFEPITarget {
    private String _targetname;
    private String _poolname;
    private String _applid;
    private Long _nodes;
    private Long _allocates;
    private Long _totallocwait;
    private Long _curallcwait;
    private Long _peakallcwait;
    private Long _totalloctout;
    private IFEPITarget.InstlstatusValue _instlstatus;
    private IFEPITarget.ServstatusValue _servstatus;
    private String _userdata;

    public FEPITarget(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._targetname = (String)avm.getAttributeValue(FEPITargetType.TARGETNAME);
        this._poolname = (String)avm.getAttributeValue(FEPITargetType.POOLNAME);
        this._applid = (String)avm.getAttributeValue(FEPITargetType.APPLID, true);
        this._nodes = (Long)avm.getAttributeValue(FEPITargetType.NODES, true);
        this._allocates = (Long)avm.getAttributeValue(FEPITargetType.ALLOCATES, true);
        this._totallocwait = (Long)avm.getAttributeValue(FEPITargetType.TOTALLOCWAIT, true);
        this._curallcwait = (Long)avm.getAttributeValue(FEPITargetType.CURALLCWAIT, true);
        this._peakallcwait = (Long)avm.getAttributeValue(FEPITargetType.PEAKALLCWAIT, true);
        this._totalloctout = (Long)avm.getAttributeValue(FEPITargetType.TOTALLOCTOUT, true);
        this._instlstatus = (IFEPITarget.InstlstatusValue)avm.getAttributeValue(FEPITargetType.INSTLSTATUS, true);
        this._servstatus = (IFEPITarget.ServstatusValue)avm.getAttributeValue(FEPITargetType.SERVSTATUS, true);
        this._userdata = (String)avm.getAttributeValue(FEPITargetType.USERDATA, true);
    }

    public FEPITarget(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("TARGETNAME");
        this._targetname = (String)((CICSAttribute)FEPITargetType.TARGETNAME).get(stringValue, normalizers);
        stringValue = record.get("POOLNAME");
        this._poolname = (String)((CICSAttribute)FEPITargetType.POOLNAME).get(stringValue, normalizers);
        stringValue = record.get("APPLID");
        this._applid = (String)((CICSAttribute)FEPITargetType.APPLID).get(stringValue, normalizers);
        stringValue = record.get("NODES");
        this._nodes = (Long)((CICSAttribute)FEPITargetType.NODES).get(stringValue, normalizers);
        stringValue = record.get("ALLOCATES");
        this._allocates = (Long)((CICSAttribute)FEPITargetType.ALLOCATES).get(stringValue, normalizers);
        stringValue = record.get("TOTALLOCWAIT");
        this._totallocwait = (Long)((CICSAttribute)FEPITargetType.TOTALLOCWAIT).get(stringValue, normalizers);
        stringValue = record.get("CURALLCWAIT");
        this._curallcwait = (Long)((CICSAttribute)FEPITargetType.CURALLCWAIT).get(stringValue, normalizers);
        stringValue = record.get("PEAKALLCWAIT");
        this._peakallcwait = (Long)((CICSAttribute)FEPITargetType.PEAKALLCWAIT).get(stringValue, normalizers);
        stringValue = record.get("TOTALLOCTOUT");
        this._totalloctout = (Long)((CICSAttribute)FEPITargetType.TOTALLOCTOUT).get(stringValue, normalizers);
        stringValue = record.get("INSTLSTATUS");
        this._instlstatus = (IFEPITarget.InstlstatusValue)((CICSAttribute)FEPITargetType.INSTLSTATUS).get(stringValue, normalizers);
        stringValue = record.get("SERVSTATUS");
        this._servstatus = (IFEPITarget.ServstatusValue)((CICSAttribute)FEPITargetType.SERVSTATUS).get(stringValue, normalizers);
        stringValue = record.get("USERDATA");
        this._userdata = (String)((CICSAttribute)FEPITargetType.USERDATA).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return FEPITargetType.TARGETNAME.internalToExternal((Object)this.getTargetname());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getTargetname() {
        return this._targetname;
    }

    public String getPoolname() {
        return this._poolname;
    }

    public String getApplid() {
        return this._applid;
    }

    public Long getNodes() {
        return this._nodes;
    }

    public Long getAllocates() {
        return this._allocates;
    }

    public Long getTotallocwait() {
        return this._totallocwait;
    }

    public Long getCurallcwait() {
        return this._curallcwait;
    }

    public Long getPeakallcwait() {
        return this._peakallcwait;
    }

    public Long getTotalloctout() {
        return this._totalloctout;
    }

    public IFEPITarget.InstlstatusValue getInstlstatus() {
        return this._instlstatus;
    }

    public IFEPITarget.ServstatusValue getServstatus() {
        return this._servstatus;
    }

    public String getUserdata() {
        return this._userdata;
    }

    public FEPITargetType getObjectType() {
        return FEPITargetType.getInstance();
    }

    @Override
    public FEPITargetReference getCICSObjectReference() {
        return new FEPITargetReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPITargetType.TARGETNAME) {
            return (V)this.getTargetname();
        }
        if (attribute == FEPITargetType.POOLNAME) {
            return (V)this.getPoolname();
        }
        if (attribute == FEPITargetType.APPLID) {
            return (V)this.getApplid();
        }
        if (attribute == FEPITargetType.NODES) {
            return (V)this.getNodes();
        }
        if (attribute == FEPITargetType.ALLOCATES) {
            return (V)this.getAllocates();
        }
        if (attribute == FEPITargetType.TOTALLOCWAIT) {
            return (V)this.getTotallocwait();
        }
        if (attribute == FEPITargetType.CURALLCWAIT) {
            return (V)this.getCurallcwait();
        }
        if (attribute == FEPITargetType.PEAKALLCWAIT) {
            return (V)this.getPeakallcwait();
        }
        if (attribute == FEPITargetType.TOTALLOCTOUT) {
            return (V)this.getTotalloctout();
        }
        if (attribute == FEPITargetType.INSTLSTATUS) {
            return (V)this.getInstlstatus();
        }
        if (attribute == FEPITargetType.SERVSTATUS) {
            return (V)this.getServstatus();
        }
        if (attribute == FEPITargetType.USERDATA) {
            return (V)this.getUserdata();
        }
        return super.getAttributeValue(attribute);
    }
}

