/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMStatusReference;
import com.ibm.cics.core.model.JVMStatusType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IJVMStatus;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class JVMStatus
extends CICSResource
implements IJVMStatus {
    private String _name;
    private String _profile;
    private Long _age;
    private IJVMStatus.ExeckeyValue _execkey;
    private String _task;
    private Long _allocage;
    private IJVMStatus.ClasscachestValue _classcachest;
    private IJVMStatus.PhasingOutStatusValue _phasingoutst;
    private IJVMStatus.ReusestValue _reusest;

    public JVMStatus(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(JVMStatusType.NAME);
        this._profile = (String)avm.getAttributeValue(JVMStatusType.PROFILE, true);
        this._age = (Long)avm.getAttributeValue(JVMStatusType.AGE, true);
        this._execkey = (IJVMStatus.ExeckeyValue)avm.getAttributeValue(JVMStatusType.EXECKEY, true);
        this._task = (String)avm.getAttributeValue(JVMStatusType.TASK, true);
        this._allocage = (Long)avm.getAttributeValue(JVMStatusType.ALLOCAGE, true);
        this._classcachest = (IJVMStatus.ClasscachestValue)avm.getAttributeValue(JVMStatusType.CLASSCACHEST, true);
        this._phasingoutst = (IJVMStatus.PhasingOutStatusValue)avm.getAttributeValue(JVMStatusType.PHASING_OUT_STATUS, true);
        this._reusest = (IJVMStatus.ReusestValue)avm.getAttributeValue(JVMStatusType.REUSEST, true);
    }

    public JVMStatus(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)JVMStatusType.NAME).get(stringValue, normalizers);
        stringValue = record.get("PROFILE");
        this._profile = (String)((CICSAttribute)JVMStatusType.PROFILE).get(stringValue, normalizers);
        stringValue = record.get("AGE");
        this._age = (Long)((CICSAttribute)JVMStatusType.AGE).get(stringValue, normalizers);
        stringValue = record.get("EXECKEY");
        this._execkey = (IJVMStatus.ExeckeyValue)((CICSAttribute)JVMStatusType.EXECKEY).get(stringValue, normalizers);
        stringValue = record.get("TASK");
        this._task = (String)((CICSAttribute)JVMStatusType.TASK).get(stringValue, normalizers);
        stringValue = record.get("ALLOCAGE");
        this._allocage = (Long)((CICSAttribute)JVMStatusType.ALLOCAGE).get(stringValue, normalizers);
        stringValue = record.get("CLASSCACHEST");
        this._classcachest = (IJVMStatus.ClasscachestValue)((CICSAttribute)JVMStatusType.CLASSCACHEST).get(stringValue, normalizers);
        stringValue = record.get("PHASINGOUTST");
        this._phasingoutst = (IJVMStatus.PhasingOutStatusValue)((CICSAttribute)JVMStatusType.PHASING_OUT_STATUS).get(stringValue, normalizers);
        stringValue = record.get("REUSEST");
        this._reusest = (IJVMStatus.ReusestValue)((CICSAttribute)JVMStatusType.REUSEST).get(stringValue, normalizers);
    }

    public String getName() {
        return this._name;
    }

    public String getProfile() {
        return this._profile;
    }

    public Long getAge() {
        return this._age;
    }

    public IJVMStatus.ExeckeyValue getExeckey() {
        return this._execkey;
    }

    public String getTask() {
        return this._task;
    }

    public Long getAllocage() {
        return this._allocage;
    }

    public IJVMStatus.ClasscachestValue getClasscachest() {
        return this._classcachest;
    }

    public IJVMStatus.PhasingOutStatusValue getPhasingOutStatus() {
        return this._phasingoutst;
    }

    public IJVMStatus.ReusestValue getReusest() {
        return this._reusest;
    }

    public JVMStatusType getObjectType() {
        return JVMStatusType.getInstance();
    }

    @Override
    public JVMStatusReference getCICSObjectReference() {
        return new JVMStatusReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMStatusType.NAME) {
            return (V)this.getName();
        }
        if (attribute == JVMStatusType.PROFILE) {
            return (V)this.getProfile();
        }
        if (attribute == JVMStatusType.AGE) {
            return (V)this.getAge();
        }
        if (attribute == JVMStatusType.EXECKEY) {
            return (V)this.getExeckey();
        }
        if (attribute == JVMStatusType.TASK) {
            return (V)this.getTask();
        }
        if (attribute == JVMStatusType.ALLOCAGE) {
            return (V)this.getAllocage();
        }
        if (attribute == JVMStatusType.CLASSCACHEST) {
            return (V)this.getClasscachest();
        }
        if (attribute == JVMStatusType.PHASING_OUT_STATUS) {
            return (V)this.getPhasingOutStatus();
        }
        if (attribute == JVMStatusType.REUSEST) {
            return (V)this.getReusest();
        }
        return super.getAttributeValue(attribute);
    }
}

