/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ModeNameReference;
import com.ibm.cics.core.model.ModeNameType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IModeName;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class ModeName
extends CICSResource
implements IModeName {
    private String _name;
    private String _connection;
    private IModeName.AutoconnValue _autoconn;
    private IModeName.ConnstatusValue _connstatus;
    private Long _sessactv;
    private Long _sessavail;
    private Long _sessmax;
    private Long _sessmaxwin;

    public ModeName(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(ModeNameType.NAME);
        this._connection = (String)avm.getAttributeValue(ModeNameType.CONNECTION);
        this._autoconn = (IModeName.AutoconnValue)avm.getAttributeValue(ModeNameType.AUTOCONN, true);
        this._connstatus = (IModeName.ConnstatusValue)avm.getAttributeValue(ModeNameType.CONNSTATUS, true);
        this._sessactv = (Long)avm.getAttributeValue(ModeNameType.SESSACTV, true);
        this._sessavail = (Long)avm.getAttributeValue(ModeNameType.SESSAVAIL, true);
        this._sessmax = (Long)avm.getAttributeValue(ModeNameType.SESSMAX, true);
        this._sessmaxwin = (Long)avm.getAttributeValue(ModeNameType.SESSMAXWIN, true);
    }

    public ModeName(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)ModeNameType.NAME).get(stringValue, normalizers);
        stringValue = record.get("CONNECTION");
        this._connection = (String)((CICSAttribute)ModeNameType.CONNECTION).get(stringValue, normalizers);
        stringValue = record.get("AUTOCONN");
        this._autoconn = (IModeName.AutoconnValue)((CICSAttribute)ModeNameType.AUTOCONN).get(stringValue, normalizers);
        stringValue = record.get("CONNSTATUS");
        this._connstatus = (IModeName.ConnstatusValue)((CICSAttribute)ModeNameType.CONNSTATUS).get(stringValue, normalizers);
        stringValue = record.get("SESSACTV");
        this._sessactv = (Long)((CICSAttribute)ModeNameType.SESSACTV).get(stringValue, normalizers);
        stringValue = record.get("SESSAVAIL");
        this._sessavail = (Long)((CICSAttribute)ModeNameType.SESSAVAIL).get(stringValue, normalizers);
        stringValue = record.get("SESSMAX");
        this._sessmax = (Long)((CICSAttribute)ModeNameType.SESSMAX).get(stringValue, normalizers);
        stringValue = record.get("SESSMAXWIN");
        this._sessmaxwin = (Long)((CICSAttribute)ModeNameType.SESSMAXWIN).get(stringValue, normalizers);
    }

    public String getName() {
        return this._name;
    }

    public String getConnection() {
        return this._connection;
    }

    public IModeName.AutoconnValue getAutoconn() {
        return this._autoconn;
    }

    public IModeName.ConnstatusValue getConnstatus() {
        return this._connstatus;
    }

    public Long getSessactv() {
        return this._sessactv;
    }

    public Long getSessavail() {
        return this._sessavail;
    }

    public Long getSessmax() {
        return this._sessmax;
    }

    public Long getSessmaxwin() {
        return this._sessmaxwin;
    }

    public ModeNameType getObjectType() {
        return ModeNameType.getInstance();
    }

    @Override
    public ModeNameReference getCICSObjectReference() {
        return new ModeNameReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ModeNameType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ModeNameType.CONNECTION) {
            return (V)this.getConnection();
        }
        if (attribute == ModeNameType.AUTOCONN) {
            return (V)this.getAutoconn();
        }
        if (attribute == ModeNameType.CONNSTATUS) {
            return (V)this.getConnstatus();
        }
        if (attribute == ModeNameType.SESSACTV) {
            return (V)this.getSessactv();
        }
        if (attribute == ModeNameType.SESSAVAIL) {
            return (V)this.getSessavail();
        }
        if (attribute == ModeNameType.SESSMAX) {
            return (V)this.getSessmax();
        }
        if (attribute == ModeNameType.SESSMAXWIN) {
            return (V)this.getSessmaxwin();
        }
        return super.getAttributeValue(attribute);
    }
}

