/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.BridgeFacilityReference;
import com.ibm.cics.core.model.BridgeFacilityType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.IBridgeFacility;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableBridgeFacility;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableBridgeFacility
extends MutableCICSResource
implements IMutableBridgeFacility {
    private IBridgeFacility delegate;
    private MutableSMRecord record;

    public MutableBridgeFacility(ICPSM cpsm, IContext context, IBridgeFacility cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("BRFACIL");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getNetname() {
        return this.delegate.getNetname();
    }

    public String getTermid() {
        return this.delegate.getTermid();
    }

    public String getTransid() {
        return this.delegate.getTransid();
    }

    public Long getTaskid() {
        return this.delegate.getTaskid();
    }

    public String getUserid() {
        return this.delegate.getUserid();
    }

    public String getLinksystem() {
        return this.delegate.getLinksystem();
    }

    public String getLinksysnet() {
        return this.delegate.getLinksysnet();
    }

    public String getRemotesystem() {
        return this.delegate.getRemotesystem();
    }

    public String getRemotesysnet() {
        return this.delegate.getRemotesysnet();
    }

    public IBridgeFacility.NamespaceValue getNamespace() {
        return this.delegate.getNamespace();
    }

    public String getKeeptime() {
        return this.delegate.getKeeptime();
    }

    public IBridgeFacility.TermstatusValue getTermstatus() {
        String result = this.record.get("TERMSTATUS");
        if (result == null) {
            return this.delegate.getTermstatus();
        }
        return (IBridgeFacility.TermstatusValue)((CICSAttribute)BridgeFacilityType.TERMSTATUS).get(result, this.record.getNormalizers());
    }

    public void setTermstatus(IBridgeFacility.TermstatusValue _termstatus) {
        if (_termstatus.equals((Object)this.delegate.getTermstatus())) {
            this.record.set("TERMSTATUS", null);
        } else {
            BridgeFacilityType.TERMSTATUS.validate((Object)_termstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)BridgeFacilityType.TERMSTATUS).set(_termstatus, this.record.getNormalizers());
            this.record.set("TERMSTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == BridgeFacilityType.NAME) {
            return (V)this.getName();
        }
        if (attribute == BridgeFacilityType.NETNAME) {
            return (V)this.getNetname();
        }
        if (attribute == BridgeFacilityType.TERMID) {
            return (V)this.getTermid();
        }
        if (attribute == BridgeFacilityType.TRANSID) {
            return (V)this.getTransid();
        }
        if (attribute == BridgeFacilityType.TASKID) {
            return (V)this.getTaskid();
        }
        if (attribute == BridgeFacilityType.USERID) {
            return (V)this.getUserid();
        }
        if (attribute == BridgeFacilityType.LINKSYSTEM) {
            return (V)this.getLinksystem();
        }
        if (attribute == BridgeFacilityType.LINKSYSNET) {
            return (V)this.getLinksysnet();
        }
        if (attribute == BridgeFacilityType.REMOTESYSTEM) {
            return (V)this.getRemotesystem();
        }
        if (attribute == BridgeFacilityType.REMOTESYSNET) {
            return (V)this.getRemotesysnet();
        }
        if (attribute == BridgeFacilityType.NAMESPACE) {
            return (V)this.getNamespace();
        }
        if (attribute == BridgeFacilityType.KEEPTIME) {
            return (V)this.getKeeptime();
        }
        if (attribute == BridgeFacilityType.TERMSTATUS) {
            return (V)this.getTermstatus();
        }
        return super.getAttributeValue(attribute);
    }

    public BridgeFacilityType getObjectType() {
        return BridgeFacilityType.getInstance();
    }

    @Override
    public BridgeFacilityReference getCICSObjectReference() {
        return new BridgeFacilityReference(this.getCICSContainer(), this.getName());
    }
}

