/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPINodeReference;
import com.ibm.cics.core.model.FEPINodeType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IFEPINode;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableFEPINode;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableFEPINode
extends MutableCICSResource
implements IMutableFEPINode {
    private IFEPINode delegate;
    private MutableSMRecord record;

    public MutableFEPINode(ICPSM cpsm, IContext context, IFEPINode cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("FEPINODE");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getNodename() {
        return this.delegate.getNodename();
    }

    public Long getAcqnum() {
        return this.delegate.getAcqnum();
    }

    public IFEPINode.AcqstatusValue getAcqstatus() {
        String result = this.record.get("ACQSTATUS");
        if (result == null) {
            return this.delegate.getAcqstatus();
        }
        return (IFEPINode.AcqstatusValue)((CICSAttribute)FEPINodeType.ACQSTATUS).get(result, this.record.getNormalizers());
    }

    public IFEPINode.InstlstatusValue getInstlstatus() {
        return this.delegate.getInstlstatus();
    }

    public Long getLastacqcode() {
        return this.delegate.getLastacqcode();
    }

    public IFEPINode.ServstatusValue getServstatus() {
        String result = this.record.get("SERVSTATUS");
        if (result == null) {
            return this.delegate.getServstatus();
        }
        return (IFEPINode.ServstatusValue)((CICSAttribute)FEPINodeType.SERVSTATUS).get(result, this.record.getNormalizers());
    }

    public String getUserdata() {
        String result = this.record.get("USERDATA");
        if (result == null) {
            return this.delegate.getUserdata();
        }
        return (String)((CICSAttribute)FEPINodeType.USERDATA).get(result, this.record.getNormalizers());
    }

    public void setAcqstatus(IFEPINode.AcqstatusValue _acqstatus) {
        if (_acqstatus.equals((Object)this.delegate.getAcqstatus())) {
            this.record.set("ACQSTATUS", null);
        } else {
            FEPINodeType.ACQSTATUS.validate((Object)_acqstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPINodeType.ACQSTATUS).set(_acqstatus, this.record.getNormalizers());
            this.record.set("ACQSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setServstatus(IFEPINode.ServstatusValue _servstatus) {
        if (_servstatus.equals((Object)this.delegate.getServstatus())) {
            this.record.set("SERVSTATUS", null);
        } else {
            FEPINodeType.SERVSTATUS.validate((Object)_servstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPINodeType.SERVSTATUS).set(_servstatus, this.record.getNormalizers());
            this.record.set("SERVSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setUserdata(String _userdata) {
        if (_userdata.equals(this.delegate.getUserdata())) {
            this.record.set("USERDATA", null);
        } else {
            FEPINodeType.USERDATA.validate((Object)_userdata);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPINodeType.USERDATA).set(_userdata, this.record.getNormalizers());
            this.record.set("USERDATA", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPINodeType.NODENAME) {
            return (V)this.getNodename();
        }
        if (attribute == FEPINodeType.ACQNUM) {
            return (V)this.getAcqnum();
        }
        if (attribute == FEPINodeType.ACQSTATUS) {
            return (V)this.getAcqstatus();
        }
        if (attribute == FEPINodeType.INSTLSTATUS) {
            return (V)this.getInstlstatus();
        }
        if (attribute == FEPINodeType.LASTACQCODE) {
            return (V)this.getLastacqcode();
        }
        if (attribute == FEPINodeType.SERVSTATUS) {
            return (V)this.getServstatus();
        }
        if (attribute == FEPINodeType.USERDATA) {
            return (V)this.getUserdata();
        }
        return super.getAttributeValue(attribute);
    }

    public FEPINodeType getObjectType() {
        return FEPINodeType.getInstance();
    }

    @Override
    public FEPINodeReference getCICSObjectReference() {
        return new FEPINodeReference(this.getCICSContainer(), this.getNodename());
    }
}

