/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPITargetReference;
import com.ibm.cics.core.model.FEPITargetType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IFEPITarget;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableFEPITarget;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableFEPITarget
extends MutableCICSResource
implements IMutableFEPITarget {
    private IFEPITarget delegate;
    private MutableSMRecord record;

    public MutableFEPITarget(ICPSM cpsm, IContext context, IFEPITarget cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("FEPITRGT");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getTargetname() {
        return this.delegate.getTargetname();
    }

    public String getPoolname() {
        return this.delegate.getPoolname();
    }

    public String getApplid() {
        return this.delegate.getApplid();
    }

    public Long getNodes() {
        return this.delegate.getNodes();
    }

    public Long getAllocates() {
        return this.delegate.getAllocates();
    }

    public Long getTotallocwait() {
        return this.delegate.getTotallocwait();
    }

    public Long getCurallcwait() {
        return this.delegate.getCurallcwait();
    }

    public Long getPeakallcwait() {
        return this.delegate.getPeakallcwait();
    }

    public Long getTotalloctout() {
        return this.delegate.getTotalloctout();
    }

    public IFEPITarget.InstlstatusValue getInstlstatus() {
        return this.delegate.getInstlstatus();
    }

    public IFEPITarget.ServstatusValue getServstatus() {
        String result = this.record.get("SERVSTATUS");
        if (result == null) {
            return this.delegate.getServstatus();
        }
        return (IFEPITarget.ServstatusValue)((CICSAttribute)FEPITargetType.SERVSTATUS).get(result, this.record.getNormalizers());
    }

    public String getUserdata() {
        String result = this.record.get("USERDATA");
        if (result == null) {
            return this.delegate.getUserdata();
        }
        return (String)((CICSAttribute)FEPITargetType.USERDATA).get(result, this.record.getNormalizers());
    }

    public void setServstatus(IFEPITarget.ServstatusValue _servstatus) {
        if (_servstatus.equals((Object)this.delegate.getServstatus())) {
            this.record.set("SERVSTATUS", null);
        } else {
            FEPITargetType.SERVSTATUS.validate((Object)_servstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPITargetType.SERVSTATUS).set(_servstatus, this.record.getNormalizers());
            this.record.set("SERVSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setUserdata(String _userdata) {
        if (_userdata.equals(this.delegate.getUserdata())) {
            this.record.set("USERDATA", null);
        } else {
            FEPITargetType.USERDATA.validate((Object)_userdata);
            String connectionSpecificExternalValue = ((CICSAttribute)FEPITargetType.USERDATA).set(_userdata, this.record.getNormalizers());
            this.record.set("USERDATA", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPITargetType.TARGETNAME) {
            return (V)this.getTargetname();
        }
        if (attribute == FEPITargetType.POOLNAME) {
            return (V)this.getPoolname();
        }
        if (attribute == FEPITargetType.APPLID) {
            return (V)this.getApplid();
        }
        if (attribute == FEPITargetType.NODES) {
            return (V)this.getNodes();
        }
        if (attribute == FEPITargetType.ALLOCATES) {
            return (V)this.getAllocates();
        }
        if (attribute == FEPITargetType.TOTALLOCWAIT) {
            return (V)this.getTotallocwait();
        }
        if (attribute == FEPITargetType.CURALLCWAIT) {
            return (V)this.getCurallcwait();
        }
        if (attribute == FEPITargetType.PEAKALLCWAIT) {
            return (V)this.getPeakallcwait();
        }
        if (attribute == FEPITargetType.TOTALLOCTOUT) {
            return (V)this.getTotalloctout();
        }
        if (attribute == FEPITargetType.INSTLSTATUS) {
            return (V)this.getInstlstatus();
        }
        if (attribute == FEPITargetType.SERVSTATUS) {
            return (V)this.getServstatus();
        }
        if (attribute == FEPITargetType.USERDATA) {
            return (V)this.getUserdata();
        }
        return super.getAttributeValue(attribute);
    }

    public FEPITargetType getObjectType() {
        return FEPITargetType.getInstance();
    }

    @Override
    public FEPITargetReference getCICSObjectReference() {
        return new FEPITargetReference(this.getCICSContainer(), this.getTargetname(), this.getPoolname());
    }
}

