/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMEndpointReference;
import com.ibm.cics.core.model.JVMEndpointType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IJVMEndpoint;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableJVMEndpoint;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableJVMEndpoint
extends MutableCICSResource
implements IMutableJVMEndpoint {
    private IJVMEndpoint delegate;
    private MutableSMRecord record;

    public MutableJVMEndpoint(ICPSM cpsm, IContext context, IJVMEndpoint cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("ENDPOINT");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getJvmEndpoint() {
        return this.delegate.getJvmEndpoint();
    }

    public IJVMEndpoint.EnableStatusValue getEnableStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getEnableStatus();
        }
        return (IJVMEndpoint.EnableStatusValue)((CICSAttribute)JVMEndpointType.ENABLE_STATUS).get(result, this.record.getNormalizers());
    }

    public String getJvmServer() {
        return this.delegate.getJvmServer();
    }

    public String getType() {
        return this.delegate.getType();
    }

    public Long getPort() {
        return this.delegate.getPort();
    }

    public Long getSecurePort() {
        return this.delegate.getSecurePort();
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public void setEnableStatus(IJVMEndpoint.EnableStatusValue _enableStatus) {
        if (_enableStatus.equals((Object)this.delegate.getEnableStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            JVMEndpointType.ENABLE_STATUS.validate((Object)_enableStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMEndpointType.ENABLE_STATUS).set(_enableStatus, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMEndpointType.JVM_ENDPOINT) {
            return (V)this.getJvmEndpoint();
        }
        if (attribute == JVMEndpointType.ENABLE_STATUS) {
            return (V)this.getEnableStatus();
        }
        if (attribute == JVMEndpointType.JVM_SERVER) {
            return (V)this.getJvmServer();
        }
        if (attribute == JVMEndpointType.TYPE) {
            return (V)this.getType();
        }
        if (attribute == JVMEndpointType.PORT) {
            return (V)this.getPort();
        }
        if (attribute == JVMEndpointType.SECURE_PORT) {
            return (V)this.getSecurePort();
        }
        if (attribute == JVMEndpointType.HOST) {
            return (V)this.getHost();
        }
        return super.getAttributeValue(attribute);
    }

    public JVMEndpointType getObjectType() {
        return JVMEndpointType.getInstance();
    }

    @Override
    public JVMEndpointReference getCICSObjectReference() {
        return new JVMEndpointReference(this.getCICSContainer(), this.getJvmEndpoint(), this.getJvmServer());
    }
}

