/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ManagedRegionReference;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.internal.MutableCPSMManager;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMManager;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableManagedRegion;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableManagedRegion
extends MutableCPSMManager
implements IMutableManagedRegion {
    private IManagedRegion delegate;
    private MutableSMRecord record;

    public MutableManagedRegion(ICPSM cpsm, IContext context, IManagedRegion cicsObject) {
        super(cpsm, context, (ICPSMManager)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("MAS");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getCMASName() {
        return this.delegate.getCMASName();
    }

    public IManagedRegion.TypeValue getType() {
        return this.delegate.getType();
    }

    public IManagedRegion.StateValue getState() {
        return this.delegate.getState();
    }

    public IManagedRegion.MonitoringStatusValue getMonitoringStatus() {
        String result = this.record.get("MONSTATUS");
        if (result == null) {
            return this.delegate.getMonitoringStatus();
        }
        return (IManagedRegion.MonitoringStatusValue)((CICSAttribute)ManagedRegionType.MONITORING_STATUS).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.RTAStatusValue getRTAStatus() {
        String result = this.record.get("RTASTATUS");
        if (result == null) {
            return this.delegate.getRTAStatus();
        }
        return (IManagedRegion.RTAStatusValue)((CICSAttribute)ManagedRegionType.RTA_STATUS).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.WLMStatusValue getWLMStatus() {
        String result = this.record.get("WLMSTATUS");
        if (result == null) {
            return this.delegate.getWLMStatus();
        }
        return (IManagedRegion.WLMStatusValue)((CICSAttribute)ManagedRegionType.WLM_STATUS).get(result, this.record.getNormalizers());
    }

    public Long getRetention() {
        String result = this.record.get("RETENTION");
        if (result == null) {
            return this.delegate.getRetention();
        }
        return (Long)((CICSAttribute)ManagedRegionType.RETENTION).get(result, this.record.getNormalizers());
    }

    public Long getSampleInterval() {
        String result = this.record.get("CICSSAMP");
        if (result == null) {
            return this.delegate.getSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getGlobalSampleInterval() {
        String result = this.record.get("GLBLSAMP");
        if (result == null) {
            return this.delegate.getGlobalSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.GLOBAL_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getDB2SampleInterval() {
        String result = this.record.get("DBXSAMP");
        if (result == null) {
            return this.delegate.getDB2SampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.DB2_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getConnectionSampleInterval() {
        String result = this.record.get("CONNSAMP");
        if (result == null) {
            return this.delegate.getConnectionSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.CONNECTION_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getFileSampleInterval() {
        String result = this.record.get("FILESAMP");
        if (result == null) {
            return this.delegate.getFileSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.FILE_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getJournalSampleInterval() {
        String result = this.record.get("JRNLSAMP");
        if (result == null) {
            return this.delegate.getJournalSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.JOURNAL_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getProgramSampleInterval() {
        String result = this.record.get("PROGSAMP");
        if (result == null) {
            return this.delegate.getProgramSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.PROGRAM_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getTerminalSampleInterval() {
        String result = this.record.get("TERMSAMP");
        if (result == null) {
            return this.delegate.getTerminalSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.TERMINAL_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getTDQSampleInterval() {
        String result = this.record.get("TDQSAMP");
        if (result == null) {
            return this.delegate.getTDQSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.TDQ_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getTransactionSampleInterval() {
        String result = this.record.get("TRANSAMP");
        if (result == null) {
            return this.delegate.getTransactionSampleInterval();
        }
        return (Long)((CICSAttribute)ManagedRegionType.TRANSACTION_SAMPLE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public String getKernelTrace() {
        String result = this.record.get("KNLTRACE");
        if (result == null) {
            return this.delegate.getKernelTrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.KERNEL_TRACE).get(result, this.record.getNormalizers());
    }

    public String getTratrace() {
        String result = this.record.get("TRATRACE");
        if (result == null) {
            return this.delegate.getTratrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.TRATRACE).get(result, this.record.getNormalizers());
    }

    public String getMessageTrace() {
        String result = this.record.get("MSGTRACE");
        if (result == null) {
            return this.delegate.getMessageTrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.MESSAGE_TRACE).get(result, this.record.getNormalizers());
    }

    public String getServicesTrace() {
        String result = this.record.get("SRVTRACE");
        if (result == null) {
            return this.delegate.getServicesTrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.SERVICES_TRACE).get(result, this.record.getNormalizers());
    }

    public String getChetrace() {
        String result = this.record.get("CHETRACE");
        if (result == null) {
            return this.delegate.getChetrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.CHETRACE).get(result, this.record.getNormalizers());
    }

    public String getQuetrace() {
        String result = this.record.get("QUETRACE");
        if (result == null) {
            return this.delegate.getQuetrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.QUETRACE).get(result, this.record.getNormalizers());
    }

    public String getComtrace() {
        String result = this.record.get("COMTRACE");
        if (result == null) {
            return this.delegate.getComtrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.COMTRACE).get(result, this.record.getNormalizers());
    }

    public String getMASTrace() {
        String result = this.record.get("MASTRACE");
        if (result == null) {
            return this.delegate.getMASTrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.MAS_TRACE).get(result, this.record.getNormalizers());
    }

    public String getWLMTrace() {
        String result = this.record.get("WLMTRACE");
        if (result == null) {
            return this.delegate.getWLMTrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.WLM_TRACE).get(result, this.record.getNormalizers());
    }

    public String getToptrace() {
        String result = this.record.get("TOPTRACE");
        if (result == null) {
            return this.delegate.getToptrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.TOPTRACE).get(result, this.record.getNormalizers());
    }

    public String getRtatrace() {
        String result = this.record.get("RTATRACE");
        if (result == null) {
            return this.delegate.getRtatrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.RTATRACE).get(result, this.record.getNormalizers());
    }

    public String getDattrace() {
        String result = this.record.get("DATTRACE");
        if (result == null) {
            return this.delegate.getDattrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.DATTRACE).get(result, this.record.getNormalizers());
    }

    public String getBastrace() {
        String result = this.record.get("BASTRACE");
        if (result == null) {
            return this.delegate.getBastrace();
        }
        return (String)((CICSAttribute)ManagedRegionType.BASTRACE).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.SeccmdchkValue getSeccmdchk() {
        String result = this.record.get("SECCMDCHK");
        if (result == null) {
            return this.delegate.getSeccmdchk();
        }
        return (IManagedRegion.SeccmdchkValue)((CICSAttribute)ManagedRegionType.SECCMDCHK).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.SecreschkValue getSecreschk() {
        String result = this.record.get("SECRESCHK");
        if (result == null) {
            return this.delegate.getSecreschk();
        }
        return (IManagedRegion.SecreschkValue)((CICSAttribute)ManagedRegionType.SECRESCHK).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.SecbypassValue getSecbypass() {
        String result = this.record.get("SECBYPASS");
        if (result == null) {
            return this.delegate.getSecbypass();
        }
        return (IManagedRegion.SecbypassValue)((CICSAttribute)ManagedRegionType.SECBYPASS).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.SamsevValue getSamsev() {
        String result = this.record.get("SAMSEV");
        if (result == null) {
            return this.delegate.getSamsev();
        }
        return (IManagedRegion.SamsevValue)((CICSAttribute)ManagedRegionType.SAMSEV).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.SossevValue getSossev() {
        String result = this.record.get("SOSSEV");
        if (result == null) {
            return this.delegate.getSossev();
        }
        return (IManagedRegion.SossevValue)((CICSAttribute)ManagedRegionType.SOSSEV).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.SdmsevValue getSdmsev() {
        String result = this.record.get("SDMSEV");
        if (result == null) {
            return this.delegate.getSdmsev();
        }
        return (IManagedRegion.SdmsevValue)((CICSAttribute)ManagedRegionType.SDMSEV).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.TdmsevValue getTdmsev() {
        String result = this.record.get("TDMSEV");
        if (result == null) {
            return this.delegate.getTdmsev();
        }
        return (IManagedRegion.TdmsevValue)((CICSAttribute)ManagedRegionType.TDMSEV).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.MxtsevValue getMxtsev() {
        String result = this.record.get("MXTSEV");
        if (result == null) {
            return this.delegate.getMxtsev();
        }
        return (IManagedRegion.MxtsevValue)((CICSAttribute)ManagedRegionType.MXTSEV).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.StlsevValue getStlsev() {
        String result = this.record.get("STLSEV");
        if (result == null) {
            return this.delegate.getStlsev();
        }
        return (IManagedRegion.StlsevValue)((CICSAttribute)ManagedRegionType.STLSEV).get(result, this.record.getNormalizers());
    }

    public String getSamaction() {
        String result = this.record.get("SAMACTION");
        if (result == null) {
            return this.delegate.getSamaction();
        }
        return (String)((CICSAttribute)ManagedRegionType.SAMACTION).get(result, this.record.getNormalizers());
    }

    public String getSosaction() {
        String result = this.record.get("SOSACTION");
        if (result == null) {
            return this.delegate.getSosaction();
        }
        return (String)((CICSAttribute)ManagedRegionType.SOSACTION).get(result, this.record.getNormalizers());
    }

    public String getSdmaction() {
        String result = this.record.get("SDMACTION");
        if (result == null) {
            return this.delegate.getSdmaction();
        }
        return (String)((CICSAttribute)ManagedRegionType.SDMACTION).get(result, this.record.getNormalizers());
    }

    public String getTdmaction() {
        String result = this.record.get("TDMACTION");
        if (result == null) {
            return this.delegate.getTdmaction();
        }
        return (String)((CICSAttribute)ManagedRegionType.TDMACTION).get(result, this.record.getNormalizers());
    }

    public String getMxtaction() {
        String result = this.record.get("MXTACTION");
        if (result == null) {
            return this.delegate.getMxtaction();
        }
        return (String)((CICSAttribute)ManagedRegionType.MXTACTION).get(result, this.record.getNormalizers());
    }

    public String getStlaction() {
        String result = this.record.get("STLACTION");
        if (result == null) {
            return this.delegate.getStlaction();
        }
        return (String)((CICSAttribute)ManagedRegionType.STLACTION).get(result, this.record.getNormalizers());
    }

    public String getPrimaryCMAS() {
        String result = this.record.get("PRICMAS");
        if (result == null) {
            return this.delegate.getPrimaryCMAS();
        }
        return (String)((CICSAttribute)ManagedRegionType.PRIMARY_CMAS).get(result, this.record.getNormalizers());
    }

    public String getActvtime() {
        String result = this.record.get("ACTVTIME");
        if (result == null) {
            return this.delegate.getActvtime();
        }
        return (String)((CICSAttribute)ManagedRegionType.ACTVTIME).get(result, this.record.getNormalizers());
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public Long getTimeZoneOffset() {
        String result = this.record.get("TMEZONEO");
        if (result == null) {
            return this.delegate.getTimeZoneOffset();
        }
        return (Long)((CICSAttribute)ManagedRegionType.TIME_ZONE_OFFSET).get(result, this.record.getNormalizers());
    }

    public String getTimeZone() {
        String result = this.record.get("TMEZONE");
        if (result == null) {
            return this.delegate.getTimeZone();
        }
        return (String)((CICSAttribute)ManagedRegionType.TIME_ZONE).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.DaylightSavingValue getDaylightSaving() {
        String result = this.record.get("DAYLGHTSV");
        if (result == null) {
            return this.delegate.getDaylightSaving();
        }
        return (IManagedRegion.DaylightSavingValue)((CICSAttribute)ManagedRegionType.DAYLIGHT_SAVING).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.AutoinstValue getAutoinst() {
        String result = this.record.get("AUTOINST");
        if (result == null) {
            return this.delegate.getAutoinst();
        }
        return (IManagedRegion.AutoinstValue)((CICSAttribute)ManagedRegionType.AUTOINST).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.AinsfailValue getAinsfail() {
        String result = this.record.get("AINSFAIL");
        if (result == null) {
            return this.delegate.getAinsfail();
        }
        return (IManagedRegion.AinsfailValue)((CICSAttribute)ManagedRegionType.AINSFAIL).get(result, this.record.getNormalizers());
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public String getNetworkid() {
        return this.delegate.getNetworkid();
    }

    public Long getPort() {
        return this.delegate.getPort();
    }

    public Long getReadrs() {
        String result = this.record.get("READRS");
        if (result == null) {
            return this.delegate.getReadrs();
        }
        return (Long)((CICSAttribute)ManagedRegionType.READRS).get(result, this.record.getNormalizers());
    }

    public Long getUpdaters() {
        String result = this.record.get("UPDATERS");
        if (result == null) {
            return this.delegate.getUpdaters();
        }
        return (Long)((CICSAttribute)ManagedRegionType.UPDATERS).get(result, this.record.getNormalizers());
    }

    public Long getToprsupd() {
        String result = this.record.get("TOPRSUPD");
        if (result == null) {
            return this.delegate.getToprsupd();
        }
        return (Long)((CICSAttribute)ManagedRegionType.TOPRSUPD).get(result, this.record.getNormalizers());
    }

    public Long getBotrsupd() {
        String result = this.record.get("BOTRSUPD");
        if (result == null) {
            return this.delegate.getBotrsupd();
        }
        return (Long)((CICSAttribute)ManagedRegionType.BOTRSUPD).get(result, this.record.getNormalizers());
    }

    public Long getWlmthrsh() {
        String result = this.record.get("WLMTHRSH");
        if (result == null) {
            return this.delegate.getWlmthrsh();
        }
        return (Long)((CICSAttribute)ManagedRegionType.WLMTHRSH).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.WlmqmodeValue getWlmqmode() {
        String result = this.record.get("WLMQMODE");
        if (result == null) {
            return this.delegate.getWlmqmode();
        }
        return (IManagedRegion.WlmqmodeValue)((CICSAttribute)ManagedRegionType.WLMQMODE).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.WlmoptenValue getWlmopten() {
        String result = this.record.get("WLMOPTEN");
        if (result == null) {
            return this.delegate.getWlmopten();
        }
        return (IManagedRegion.WlmoptenValue)((CICSAttribute)ManagedRegionType.WLMOPTEN).get(result, this.record.getNormalizers());
    }

    public IManagedRegion.NrmsevValue getNrmsev() {
        String result = this.record.get("NRMSEV");
        if (result == null) {
            return this.delegate.getNrmsev();
        }
        return (IManagedRegion.NrmsevValue)((CICSAttribute)ManagedRegionType.NRMSEV).get(result, this.record.getNormalizers());
    }

    public String getNrmaction() {
        String result = this.record.get("NRMACTION");
        if (result == null) {
            return this.delegate.getNrmaction();
        }
        return (String)((CICSAttribute)ManagedRegionType.NRMACTION).get(result, this.record.getNormalizers());
    }

    public String getCpsmver() {
        return this.delegate.getCpsmver();
    }

    public String getApplid() {
        return this.delegate.getApplid();
    }

    public void setMonitoringStatus(IManagedRegion.MonitoringStatusValue _monitoringStatus) {
        if (_monitoringStatus.equals((Object)this.delegate.getMonitoringStatus())) {
            this.record.set("MONSTATUS", null);
        } else {
            ManagedRegionType.MONITORING_STATUS.validate((Object)_monitoringStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.MONITORING_STATUS).set(_monitoringStatus, this.record.getNormalizers());
            this.record.set("MONSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setRTAStatus(IManagedRegion.RTAStatusValue _RTAStatus) {
        if (_RTAStatus.equals((Object)this.delegate.getRTAStatus())) {
            this.record.set("RTASTATUS", null);
        } else {
            ManagedRegionType.RTA_STATUS.validate((Object)_RTAStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.RTA_STATUS).set(_RTAStatus, this.record.getNormalizers());
            this.record.set("RTASTATUS", connectionSpecificExternalValue);
        }
    }

    public void setWLMStatus(IManagedRegion.WLMStatusValue _WLMStatus) {
        if (_WLMStatus.equals((Object)this.delegate.getWLMStatus())) {
            this.record.set("WLMSTATUS", null);
        } else {
            ManagedRegionType.WLM_STATUS.validate((Object)_WLMStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.WLM_STATUS).set(_WLMStatus, this.record.getNormalizers());
            this.record.set("WLMSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setRetention(Long _retention) {
        if (_retention.equals(this.delegate.getRetention())) {
            this.record.set("RETENTION", null);
        } else {
            ManagedRegionType.RETENTION.validate((Object)_retention);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.RETENTION).set(_retention, this.record.getNormalizers());
            this.record.set("RETENTION", connectionSpecificExternalValue);
        }
    }

    public void setSampleInterval(Long _sampleInterval) {
        if (_sampleInterval.equals(this.delegate.getSampleInterval())) {
            this.record.set("CICSSAMP", null);
        } else {
            ManagedRegionType.SAMPLE_INTERVAL.validate((Object)_sampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SAMPLE_INTERVAL).set(_sampleInterval, this.record.getNormalizers());
            this.record.set("CICSSAMP", connectionSpecificExternalValue);
        }
    }

    public void setGlobalSampleInterval(Long _globalSampleInterval) {
        if (_globalSampleInterval.equals(this.delegate.getGlobalSampleInterval())) {
            this.record.set("GLBLSAMP", null);
        } else {
            ManagedRegionType.GLOBAL_SAMPLE_INTERVAL.validate((Object)_globalSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.GLOBAL_SAMPLE_INTERVAL).set(_globalSampleInterval, this.record.getNormalizers());
            this.record.set("GLBLSAMP", connectionSpecificExternalValue);
        }
    }

    public void setDB2SampleInterval(Long _DB2SampleInterval) {
        if (_DB2SampleInterval.equals(this.delegate.getDB2SampleInterval())) {
            this.record.set("DBXSAMP", null);
        } else {
            ManagedRegionType.DB2_SAMPLE_INTERVAL.validate((Object)_DB2SampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.DB2_SAMPLE_INTERVAL).set(_DB2SampleInterval, this.record.getNormalizers());
            this.record.set("DBXSAMP", connectionSpecificExternalValue);
        }
    }

    public void setConnectionSampleInterval(Long _connectionSampleInterval) {
        if (_connectionSampleInterval.equals(this.delegate.getConnectionSampleInterval())) {
            this.record.set("CONNSAMP", null);
        } else {
            ManagedRegionType.CONNECTION_SAMPLE_INTERVAL.validate((Object)_connectionSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.CONNECTION_SAMPLE_INTERVAL).set(_connectionSampleInterval, this.record.getNormalizers());
            this.record.set("CONNSAMP", connectionSpecificExternalValue);
        }
    }

    public void setFileSampleInterval(Long _fileSampleInterval) {
        if (_fileSampleInterval.equals(this.delegate.getFileSampleInterval())) {
            this.record.set("FILESAMP", null);
        } else {
            ManagedRegionType.FILE_SAMPLE_INTERVAL.validate((Object)_fileSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.FILE_SAMPLE_INTERVAL).set(_fileSampleInterval, this.record.getNormalizers());
            this.record.set("FILESAMP", connectionSpecificExternalValue);
        }
    }

    public void setJournalSampleInterval(Long _journalSampleInterval) {
        if (_journalSampleInterval.equals(this.delegate.getJournalSampleInterval())) {
            this.record.set("JRNLSAMP", null);
        } else {
            ManagedRegionType.JOURNAL_SAMPLE_INTERVAL.validate((Object)_journalSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.JOURNAL_SAMPLE_INTERVAL).set(_journalSampleInterval, this.record.getNormalizers());
            this.record.set("JRNLSAMP", connectionSpecificExternalValue);
        }
    }

    public void setProgramSampleInterval(Long _programSampleInterval) {
        if (_programSampleInterval.equals(this.delegate.getProgramSampleInterval())) {
            this.record.set("PROGSAMP", null);
        } else {
            ManagedRegionType.PROGRAM_SAMPLE_INTERVAL.validate((Object)_programSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.PROGRAM_SAMPLE_INTERVAL).set(_programSampleInterval, this.record.getNormalizers());
            this.record.set("PROGSAMP", connectionSpecificExternalValue);
        }
    }

    public void setTerminalSampleInterval(Long _terminalSampleInterval) {
        if (_terminalSampleInterval.equals(this.delegate.getTerminalSampleInterval())) {
            this.record.set("TERMSAMP", null);
        } else {
            ManagedRegionType.TERMINAL_SAMPLE_INTERVAL.validate((Object)_terminalSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TERMINAL_SAMPLE_INTERVAL).set(_terminalSampleInterval, this.record.getNormalizers());
            this.record.set("TERMSAMP", connectionSpecificExternalValue);
        }
    }

    public void setTDQSampleInterval(Long _TDQSampleInterval) {
        if (_TDQSampleInterval.equals(this.delegate.getTDQSampleInterval())) {
            this.record.set("TDQSAMP", null);
        } else {
            ManagedRegionType.TDQ_SAMPLE_INTERVAL.validate((Object)_TDQSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TDQ_SAMPLE_INTERVAL).set(_TDQSampleInterval, this.record.getNormalizers());
            this.record.set("TDQSAMP", connectionSpecificExternalValue);
        }
    }

    public void setTransactionSampleInterval(Long _transactionSampleInterval) {
        if (_transactionSampleInterval.equals(this.delegate.getTransactionSampleInterval())) {
            this.record.set("TRANSAMP", null);
        } else {
            ManagedRegionType.TRANSACTION_SAMPLE_INTERVAL.validate((Object)_transactionSampleInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TRANSACTION_SAMPLE_INTERVAL).set(_transactionSampleInterval, this.record.getNormalizers());
            this.record.set("TRANSAMP", connectionSpecificExternalValue);
        }
    }

    public void setKernelTrace(String _kernelTrace) {
        if (_kernelTrace.equals(this.delegate.getKernelTrace())) {
            this.record.set("KNLTRACE", null);
        } else {
            ManagedRegionType.KERNEL_TRACE.validate((Object)_kernelTrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.KERNEL_TRACE).set(_kernelTrace, this.record.getNormalizers());
            this.record.set("KNLTRACE", connectionSpecificExternalValue);
        }
    }

    public void setTratrace(String _tratrace) {
        if (_tratrace.equals(this.delegate.getTratrace())) {
            this.record.set("TRATRACE", null);
        } else {
            ManagedRegionType.TRATRACE.validate((Object)_tratrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TRATRACE).set(_tratrace, this.record.getNormalizers());
            this.record.set("TRATRACE", connectionSpecificExternalValue);
        }
    }

    public void setMessageTrace(String _messageTrace) {
        if (_messageTrace.equals(this.delegate.getMessageTrace())) {
            this.record.set("MSGTRACE", null);
        } else {
            ManagedRegionType.MESSAGE_TRACE.validate((Object)_messageTrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.MESSAGE_TRACE).set(_messageTrace, this.record.getNormalizers());
            this.record.set("MSGTRACE", connectionSpecificExternalValue);
        }
    }

    public void setServicesTrace(String _servicesTrace) {
        if (_servicesTrace.equals(this.delegate.getServicesTrace())) {
            this.record.set("SRVTRACE", null);
        } else {
            ManagedRegionType.SERVICES_TRACE.validate((Object)_servicesTrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SERVICES_TRACE).set(_servicesTrace, this.record.getNormalizers());
            this.record.set("SRVTRACE", connectionSpecificExternalValue);
        }
    }

    public void setChetrace(String _chetrace) {
        if (_chetrace.equals(this.delegate.getChetrace())) {
            this.record.set("CHETRACE", null);
        } else {
            ManagedRegionType.CHETRACE.validate((Object)_chetrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.CHETRACE).set(_chetrace, this.record.getNormalizers());
            this.record.set("CHETRACE", connectionSpecificExternalValue);
        }
    }

    public void setQuetrace(String _quetrace) {
        if (_quetrace.equals(this.delegate.getQuetrace())) {
            this.record.set("QUETRACE", null);
        } else {
            ManagedRegionType.QUETRACE.validate((Object)_quetrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.QUETRACE).set(_quetrace, this.record.getNormalizers());
            this.record.set("QUETRACE", connectionSpecificExternalValue);
        }
    }

    public void setComtrace(String _comtrace) {
        if (_comtrace.equals(this.delegate.getComtrace())) {
            this.record.set("COMTRACE", null);
        } else {
            ManagedRegionType.COMTRACE.validate((Object)_comtrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.COMTRACE).set(_comtrace, this.record.getNormalizers());
            this.record.set("COMTRACE", connectionSpecificExternalValue);
        }
    }

    public void setMASTrace(String _MASTrace) {
        if (_MASTrace.equals(this.delegate.getMASTrace())) {
            this.record.set("MASTRACE", null);
        } else {
            ManagedRegionType.MAS_TRACE.validate((Object)_MASTrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.MAS_TRACE).set(_MASTrace, this.record.getNormalizers());
            this.record.set("MASTRACE", connectionSpecificExternalValue);
        }
    }

    public void setWLMTrace(String _WLMTrace) {
        if (_WLMTrace.equals(this.delegate.getWLMTrace())) {
            this.record.set("WLMTRACE", null);
        } else {
            ManagedRegionType.WLM_TRACE.validate((Object)_WLMTrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.WLM_TRACE).set(_WLMTrace, this.record.getNormalizers());
            this.record.set("WLMTRACE", connectionSpecificExternalValue);
        }
    }

    public void setToptrace(String _toptrace) {
        if (_toptrace.equals(this.delegate.getToptrace())) {
            this.record.set("TOPTRACE", null);
        } else {
            ManagedRegionType.TOPTRACE.validate((Object)_toptrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TOPTRACE).set(_toptrace, this.record.getNormalizers());
            this.record.set("TOPTRACE", connectionSpecificExternalValue);
        }
    }

    public void setRtatrace(String _rtatrace) {
        if (_rtatrace.equals(this.delegate.getRtatrace())) {
            this.record.set("RTATRACE", null);
        } else {
            ManagedRegionType.RTATRACE.validate((Object)_rtatrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.RTATRACE).set(_rtatrace, this.record.getNormalizers());
            this.record.set("RTATRACE", connectionSpecificExternalValue);
        }
    }

    public void setDattrace(String _dattrace) {
        if (_dattrace.equals(this.delegate.getDattrace())) {
            this.record.set("DATTRACE", null);
        } else {
            ManagedRegionType.DATTRACE.validate((Object)_dattrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.DATTRACE).set(_dattrace, this.record.getNormalizers());
            this.record.set("DATTRACE", connectionSpecificExternalValue);
        }
    }

    public void setBastrace(String _bastrace) {
        if (_bastrace.equals(this.delegate.getBastrace())) {
            this.record.set("BASTRACE", null);
        } else {
            ManagedRegionType.BASTRACE.validate((Object)_bastrace);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.BASTRACE).set(_bastrace, this.record.getNormalizers());
            this.record.set("BASTRACE", connectionSpecificExternalValue);
        }
    }

    public void setSeccmdchk(IManagedRegion.SeccmdchkValue _seccmdchk) {
        if (_seccmdchk.equals((Object)this.delegate.getSeccmdchk())) {
            this.record.set("SECCMDCHK", null);
        } else {
            ManagedRegionType.SECCMDCHK.validate((Object)_seccmdchk);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SECCMDCHK).set(_seccmdchk, this.record.getNormalizers());
            this.record.set("SECCMDCHK", connectionSpecificExternalValue);
        }
    }

    public void setSecreschk(IManagedRegion.SecreschkValue _secreschk) {
        if (_secreschk.equals((Object)this.delegate.getSecreschk())) {
            this.record.set("SECRESCHK", null);
        } else {
            ManagedRegionType.SECRESCHK.validate((Object)_secreschk);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SECRESCHK).set(_secreschk, this.record.getNormalizers());
            this.record.set("SECRESCHK", connectionSpecificExternalValue);
        }
    }

    public void setSecbypass(IManagedRegion.SecbypassValue _secbypass) {
        if (_secbypass.equals((Object)this.delegate.getSecbypass())) {
            this.record.set("SECBYPASS", null);
        } else {
            ManagedRegionType.SECBYPASS.validate((Object)_secbypass);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SECBYPASS).set(_secbypass, this.record.getNormalizers());
            this.record.set("SECBYPASS", connectionSpecificExternalValue);
        }
    }

    public void setSamsev(IManagedRegion.SamsevValue _samsev) {
        if (_samsev.equals((Object)this.delegate.getSamsev())) {
            this.record.set("SAMSEV", null);
        } else {
            ManagedRegionType.SAMSEV.validate((Object)_samsev);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SAMSEV).set(_samsev, this.record.getNormalizers());
            this.record.set("SAMSEV", connectionSpecificExternalValue);
        }
    }

    public void setSossev(IManagedRegion.SossevValue _sossev) {
        if (_sossev.equals((Object)this.delegate.getSossev())) {
            this.record.set("SOSSEV", null);
        } else {
            ManagedRegionType.SOSSEV.validate((Object)_sossev);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SOSSEV).set(_sossev, this.record.getNormalizers());
            this.record.set("SOSSEV", connectionSpecificExternalValue);
        }
    }

    public void setSdmsev(IManagedRegion.SdmsevValue _sdmsev) {
        if (_sdmsev.equals((Object)this.delegate.getSdmsev())) {
            this.record.set("SDMSEV", null);
        } else {
            ManagedRegionType.SDMSEV.validate((Object)_sdmsev);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SDMSEV).set(_sdmsev, this.record.getNormalizers());
            this.record.set("SDMSEV", connectionSpecificExternalValue);
        }
    }

    public void setTdmsev(IManagedRegion.TdmsevValue _tdmsev) {
        if (_tdmsev.equals((Object)this.delegate.getTdmsev())) {
            this.record.set("TDMSEV", null);
        } else {
            ManagedRegionType.TDMSEV.validate((Object)_tdmsev);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TDMSEV).set(_tdmsev, this.record.getNormalizers());
            this.record.set("TDMSEV", connectionSpecificExternalValue);
        }
    }

    public void setMxtsev(IManagedRegion.MxtsevValue _mxtsev) {
        if (_mxtsev.equals((Object)this.delegate.getMxtsev())) {
            this.record.set("MXTSEV", null);
        } else {
            ManagedRegionType.MXTSEV.validate((Object)_mxtsev);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.MXTSEV).set(_mxtsev, this.record.getNormalizers());
            this.record.set("MXTSEV", connectionSpecificExternalValue);
        }
    }

    public void setStlsev(IManagedRegion.StlsevValue _stlsev) {
        if (_stlsev.equals((Object)this.delegate.getStlsev())) {
            this.record.set("STLSEV", null);
        } else {
            ManagedRegionType.STLSEV.validate((Object)_stlsev);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.STLSEV).set(_stlsev, this.record.getNormalizers());
            this.record.set("STLSEV", connectionSpecificExternalValue);
        }
    }

    public void setSamaction(String _samaction) {
        if (_samaction.equals(this.delegate.getSamaction())) {
            this.record.set("SAMACTION", null);
        } else {
            ManagedRegionType.SAMACTION.validate((Object)_samaction);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SAMACTION).set(_samaction, this.record.getNormalizers());
            this.record.set("SAMACTION", connectionSpecificExternalValue);
        }
    }

    public void setSosaction(String _sosaction) {
        if (_sosaction.equals(this.delegate.getSosaction())) {
            this.record.set("SOSACTION", null);
        } else {
            ManagedRegionType.SOSACTION.validate((Object)_sosaction);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SOSACTION).set(_sosaction, this.record.getNormalizers());
            this.record.set("SOSACTION", connectionSpecificExternalValue);
        }
    }

    public void setSdmaction(String _sdmaction) {
        if (_sdmaction.equals(this.delegate.getSdmaction())) {
            this.record.set("SDMACTION", null);
        } else {
            ManagedRegionType.SDMACTION.validate((Object)_sdmaction);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.SDMACTION).set(_sdmaction, this.record.getNormalizers());
            this.record.set("SDMACTION", connectionSpecificExternalValue);
        }
    }

    public void setTdmaction(String _tdmaction) {
        if (_tdmaction.equals(this.delegate.getTdmaction())) {
            this.record.set("TDMACTION", null);
        } else {
            ManagedRegionType.TDMACTION.validate((Object)_tdmaction);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TDMACTION).set(_tdmaction, this.record.getNormalizers());
            this.record.set("TDMACTION", connectionSpecificExternalValue);
        }
    }

    public void setMxtaction(String _mxtaction) {
        if (_mxtaction.equals(this.delegate.getMxtaction())) {
            this.record.set("MXTACTION", null);
        } else {
            ManagedRegionType.MXTACTION.validate((Object)_mxtaction);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.MXTACTION).set(_mxtaction, this.record.getNormalizers());
            this.record.set("MXTACTION", connectionSpecificExternalValue);
        }
    }

    public void setStlaction(String _stlaction) {
        if (_stlaction.equals(this.delegate.getStlaction())) {
            this.record.set("STLACTION", null);
        } else {
            ManagedRegionType.STLACTION.validate((Object)_stlaction);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.STLACTION).set(_stlaction, this.record.getNormalizers());
            this.record.set("STLACTION", connectionSpecificExternalValue);
        }
    }

    public void setPrimaryCMAS(String _primaryCMAS) {
        if (_primaryCMAS.equals(this.delegate.getPrimaryCMAS())) {
            this.record.set("PRICMAS", null);
        } else {
            ManagedRegionType.PRIMARY_CMAS.validate((Object)_primaryCMAS);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.PRIMARY_CMAS).set(_primaryCMAS, this.record.getNormalizers());
            this.record.set("PRICMAS", connectionSpecificExternalValue);
        }
    }

    public void setActvtime(String _actvtime) {
        if (_actvtime.equals(this.delegate.getActvtime())) {
            this.record.set("ACTVTIME", null);
        } else {
            ManagedRegionType.ACTVTIME.validate((Object)_actvtime);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.ACTVTIME).set(_actvtime, this.record.getNormalizers());
            this.record.set("ACTVTIME", connectionSpecificExternalValue);
        }
    }

    public void setTimeZoneOffset(Long _timeZoneOffset) {
        if (_timeZoneOffset.equals(this.delegate.getTimeZoneOffset())) {
            this.record.set("TMEZONEO", null);
        } else {
            ManagedRegionType.TIME_ZONE_OFFSET.validate((Object)_timeZoneOffset);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TIME_ZONE_OFFSET).set(_timeZoneOffset, this.record.getNormalizers());
            this.record.set("TMEZONEO", connectionSpecificExternalValue);
        }
    }

    public void setTimeZone(String _timeZone) {
        if (_timeZone.equals(this.delegate.getTimeZone())) {
            this.record.set("TMEZONE", null);
        } else {
            ManagedRegionType.TIME_ZONE.validate((Object)_timeZone);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TIME_ZONE).set(_timeZone, this.record.getNormalizers());
            this.record.set("TMEZONE", connectionSpecificExternalValue);
        }
    }

    public void setDaylightSaving(IManagedRegion.DaylightSavingValue _daylightSaving) {
        if (_daylightSaving.equals((Object)this.delegate.getDaylightSaving())) {
            this.record.set("DAYLGHTSV", null);
        } else {
            ManagedRegionType.DAYLIGHT_SAVING.validate((Object)_daylightSaving);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.DAYLIGHT_SAVING).set(_daylightSaving, this.record.getNormalizers());
            this.record.set("DAYLGHTSV", connectionSpecificExternalValue);
        }
    }

    public void setAutoinst(IManagedRegion.AutoinstValue _autoinst) {
        if (_autoinst.equals((Object)this.delegate.getAutoinst())) {
            this.record.set("AUTOINST", null);
        } else {
            ManagedRegionType.AUTOINST.validate((Object)_autoinst);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.AUTOINST).set(_autoinst, this.record.getNormalizers());
            this.record.set("AUTOINST", connectionSpecificExternalValue);
        }
    }

    public void setAinsfail(IManagedRegion.AinsfailValue _ainsfail) {
        if (_ainsfail.equals((Object)this.delegate.getAinsfail())) {
            this.record.set("AINSFAIL", null);
        } else {
            ManagedRegionType.AINSFAIL.validate((Object)_ainsfail);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.AINSFAIL).set(_ainsfail, this.record.getNormalizers());
            this.record.set("AINSFAIL", connectionSpecificExternalValue);
        }
    }

    public void setReadrs(Long _readrs) {
        if (_readrs.equals(this.delegate.getReadrs())) {
            this.record.set("READRS", null);
        } else {
            ManagedRegionType.READRS.validate((Object)_readrs);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.READRS).set(_readrs, this.record.getNormalizers());
            this.record.set("READRS", connectionSpecificExternalValue);
        }
    }

    public void setUpdaters(Long _updaters) {
        if (_updaters.equals(this.delegate.getUpdaters())) {
            this.record.set("UPDATERS", null);
        } else {
            ManagedRegionType.UPDATERS.validate((Object)_updaters);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.UPDATERS).set(_updaters, this.record.getNormalizers());
            this.record.set("UPDATERS", connectionSpecificExternalValue);
        }
    }

    public void setToprsupd(Long _toprsupd) {
        if (_toprsupd.equals(this.delegate.getToprsupd())) {
            this.record.set("TOPRSUPD", null);
        } else {
            ManagedRegionType.TOPRSUPD.validate((Object)_toprsupd);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.TOPRSUPD).set(_toprsupd, this.record.getNormalizers());
            this.record.set("TOPRSUPD", connectionSpecificExternalValue);
        }
    }

    public void setBotrsupd(Long _botrsupd) {
        if (_botrsupd.equals(this.delegate.getBotrsupd())) {
            this.record.set("BOTRSUPD", null);
        } else {
            ManagedRegionType.BOTRSUPD.validate((Object)_botrsupd);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.BOTRSUPD).set(_botrsupd, this.record.getNormalizers());
            this.record.set("BOTRSUPD", connectionSpecificExternalValue);
        }
    }

    public void setWlmthrsh(Long _wlmthrsh) {
        if (_wlmthrsh.equals(this.delegate.getWlmthrsh())) {
            this.record.set("WLMTHRSH", null);
        } else {
            ManagedRegionType.WLMTHRSH.validate((Object)_wlmthrsh);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.WLMTHRSH).set(_wlmthrsh, this.record.getNormalizers());
            this.record.set("WLMTHRSH", connectionSpecificExternalValue);
        }
    }

    public void setWlmqmode(IManagedRegion.WlmqmodeValue _wlmqmode) {
        if (_wlmqmode.equals((Object)this.delegate.getWlmqmode())) {
            this.record.set("WLMQMODE", null);
        } else {
            ManagedRegionType.WLMQMODE.validate((Object)_wlmqmode);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.WLMQMODE).set(_wlmqmode, this.record.getNormalizers());
            this.record.set("WLMQMODE", connectionSpecificExternalValue);
        }
    }

    public void setWlmopten(IManagedRegion.WlmoptenValue _wlmopten) {
        if (_wlmopten.equals((Object)this.delegate.getWlmopten())) {
            this.record.set("WLMOPTEN", null);
        } else {
            ManagedRegionType.WLMOPTEN.validate((Object)_wlmopten);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.WLMOPTEN).set(_wlmopten, this.record.getNormalizers());
            this.record.set("WLMOPTEN", connectionSpecificExternalValue);
        }
    }

    public void setNrmsev(IManagedRegion.NrmsevValue _nrmsev) {
        if (_nrmsev.equals((Object)this.delegate.getNrmsev())) {
            this.record.set("NRMSEV", null);
        } else {
            ManagedRegionType.NRMSEV.validate((Object)_nrmsev);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.NRMSEV).set(_nrmsev, this.record.getNormalizers());
            this.record.set("NRMSEV", connectionSpecificExternalValue);
        }
    }

    public void setNrmaction(String _nrmaction) {
        if (_nrmaction.equals(this.delegate.getNrmaction())) {
            this.record.set("NRMACTION", null);
        } else {
            ManagedRegionType.NRMACTION.validate((Object)_nrmaction);
            String connectionSpecificExternalValue = ((CICSAttribute)ManagedRegionType.NRMACTION).set(_nrmaction, this.record.getNormalizers());
            this.record.set("NRMACTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ManagedRegionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ManagedRegionType.CMAS_NAME) {
            return (V)this.getCMASName();
        }
        if (attribute == ManagedRegionType.TYPE) {
            return (V)this.getType();
        }
        if (attribute == ManagedRegionType.STATE) {
            return (V)this.getState();
        }
        if (attribute == ManagedRegionType.MONITORING_STATUS) {
            return (V)this.getMonitoringStatus();
        }
        if (attribute == ManagedRegionType.RTA_STATUS) {
            return (V)this.getRTAStatus();
        }
        if (attribute == ManagedRegionType.WLM_STATUS) {
            return (V)this.getWLMStatus();
        }
        if (attribute == ManagedRegionType.RETENTION) {
            return (V)this.getRetention();
        }
        if (attribute == ManagedRegionType.SAMPLE_INTERVAL) {
            return (V)this.getSampleInterval();
        }
        if (attribute == ManagedRegionType.GLOBAL_SAMPLE_INTERVAL) {
            return (V)this.getGlobalSampleInterval();
        }
        if (attribute == ManagedRegionType.DB2_SAMPLE_INTERVAL) {
            return (V)this.getDB2SampleInterval();
        }
        if (attribute == ManagedRegionType.CONNECTION_SAMPLE_INTERVAL) {
            return (V)this.getConnectionSampleInterval();
        }
        if (attribute == ManagedRegionType.FILE_SAMPLE_INTERVAL) {
            return (V)this.getFileSampleInterval();
        }
        if (attribute == ManagedRegionType.JOURNAL_SAMPLE_INTERVAL) {
            return (V)this.getJournalSampleInterval();
        }
        if (attribute == ManagedRegionType.PROGRAM_SAMPLE_INTERVAL) {
            return (V)this.getProgramSampleInterval();
        }
        if (attribute == ManagedRegionType.TERMINAL_SAMPLE_INTERVAL) {
            return (V)this.getTerminalSampleInterval();
        }
        if (attribute == ManagedRegionType.TDQ_SAMPLE_INTERVAL) {
            return (V)this.getTDQSampleInterval();
        }
        if (attribute == ManagedRegionType.TRANSACTION_SAMPLE_INTERVAL) {
            return (V)this.getTransactionSampleInterval();
        }
        if (attribute == ManagedRegionType.KERNEL_TRACE) {
            return (V)this.getKernelTrace();
        }
        if (attribute == ManagedRegionType.TRATRACE) {
            return (V)this.getTratrace();
        }
        if (attribute == ManagedRegionType.MESSAGE_TRACE) {
            return (V)this.getMessageTrace();
        }
        if (attribute == ManagedRegionType.SERVICES_TRACE) {
            return (V)this.getServicesTrace();
        }
        if (attribute == ManagedRegionType.CHETRACE) {
            return (V)this.getChetrace();
        }
        if (attribute == ManagedRegionType.QUETRACE) {
            return (V)this.getQuetrace();
        }
        if (attribute == ManagedRegionType.COMTRACE) {
            return (V)this.getComtrace();
        }
        if (attribute == ManagedRegionType.MAS_TRACE) {
            return (V)this.getMASTrace();
        }
        if (attribute == ManagedRegionType.WLM_TRACE) {
            return (V)this.getWLMTrace();
        }
        if (attribute == ManagedRegionType.TOPTRACE) {
            return (V)this.getToptrace();
        }
        if (attribute == ManagedRegionType.RTATRACE) {
            return (V)this.getRtatrace();
        }
        if (attribute == ManagedRegionType.DATTRACE) {
            return (V)this.getDattrace();
        }
        if (attribute == ManagedRegionType.BASTRACE) {
            return (V)this.getBastrace();
        }
        if (attribute == ManagedRegionType.SECCMDCHK) {
            return (V)this.getSeccmdchk();
        }
        if (attribute == ManagedRegionType.SECRESCHK) {
            return (V)this.getSecreschk();
        }
        if (attribute == ManagedRegionType.SECBYPASS) {
            return (V)this.getSecbypass();
        }
        if (attribute == ManagedRegionType.SAMSEV) {
            return (V)this.getSamsev();
        }
        if (attribute == ManagedRegionType.SOSSEV) {
            return (V)this.getSossev();
        }
        if (attribute == ManagedRegionType.SDMSEV) {
            return (V)this.getSdmsev();
        }
        if (attribute == ManagedRegionType.TDMSEV) {
            return (V)this.getTdmsev();
        }
        if (attribute == ManagedRegionType.MXTSEV) {
            return (V)this.getMxtsev();
        }
        if (attribute == ManagedRegionType.STLSEV) {
            return (V)this.getStlsev();
        }
        if (attribute == ManagedRegionType.SAMACTION) {
            return (V)this.getSamaction();
        }
        if (attribute == ManagedRegionType.SOSACTION) {
            return (V)this.getSosaction();
        }
        if (attribute == ManagedRegionType.SDMACTION) {
            return (V)this.getSdmaction();
        }
        if (attribute == ManagedRegionType.TDMACTION) {
            return (V)this.getTdmaction();
        }
        if (attribute == ManagedRegionType.MXTACTION) {
            return (V)this.getMxtaction();
        }
        if (attribute == ManagedRegionType.STLACTION) {
            return (V)this.getStlaction();
        }
        if (attribute == ManagedRegionType.PRIMARY_CMAS) {
            return (V)this.getPrimaryCMAS();
        }
        if (attribute == ManagedRegionType.ACTVTIME) {
            return (V)this.getActvtime();
        }
        if (attribute == ManagedRegionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == ManagedRegionType.TIME_ZONE_OFFSET) {
            return (V)this.getTimeZoneOffset();
        }
        if (attribute == ManagedRegionType.TIME_ZONE) {
            return (V)this.getTimeZone();
        }
        if (attribute == ManagedRegionType.DAYLIGHT_SAVING) {
            return (V)this.getDaylightSaving();
        }
        if (attribute == ManagedRegionType.AUTOINST) {
            return (V)this.getAutoinst();
        }
        if (attribute == ManagedRegionType.AINSFAIL) {
            return (V)this.getAinsfail();
        }
        if (attribute == ManagedRegionType.HOST) {
            return (V)this.getHost();
        }
        if (attribute == ManagedRegionType.NETWORKID) {
            return (V)this.getNetworkid();
        }
        if (attribute == ManagedRegionType.PORT) {
            return (V)this.getPort();
        }
        if (attribute == ManagedRegionType.READRS) {
            return (V)this.getReadrs();
        }
        if (attribute == ManagedRegionType.UPDATERS) {
            return (V)this.getUpdaters();
        }
        if (attribute == ManagedRegionType.TOPRSUPD) {
            return (V)this.getToprsupd();
        }
        if (attribute == ManagedRegionType.BOTRSUPD) {
            return (V)this.getBotrsupd();
        }
        if (attribute == ManagedRegionType.WLMTHRSH) {
            return (V)this.getWlmthrsh();
        }
        if (attribute == ManagedRegionType.WLMQMODE) {
            return (V)this.getWlmqmode();
        }
        if (attribute == ManagedRegionType.WLMOPTEN) {
            return (V)this.getWlmopten();
        }
        if (attribute == ManagedRegionType.NRMSEV) {
            return (V)this.getNrmsev();
        }
        if (attribute == ManagedRegionType.NRMACTION) {
            return (V)this.getNrmaction();
        }
        if (attribute == ManagedRegionType.CPSMVER) {
            return (V)this.getCpsmver();
        }
        if (attribute == ManagedRegionType.APPLID) {
            return (V)this.getApplid();
        }
        return super.getAttributeValue(attribute);
    }

    public ManagedRegionType getObjectType() {
        return ManagedRegionType.getInstance();
    }

    @Override
    public ManagedRegionReference getCICSObjectReference() {
        return new ManagedRegionReference(this.getCICSContainer(), this.getName());
    }
}

