/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TCPIPServiceReference;
import com.ibm.cics.core.model.TCPIPServiceType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ITCPIPService;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableTCPIPService;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableTCPIPService
extends MutableCICSResource
implements IMutableTCPIPService {
    private ITCPIPService delegate;
    private MutableSMRecord record;

    public MutableTCPIPService(ICPSM cpsm, IContext context, ITCPIPService cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("TCPIPS");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public Long getPort() {
        return this.delegate.getPort();
    }

    public Long getBacklog() {
        String result = this.record.get("BACKLOG");
        if (result == null) {
            return this.delegate.getBacklog();
        }
        return (Long)((CICSAttribute)TCPIPServiceType.BACKLOG).get(result, this.record.getNormalizers());
    }

    public ITCPIPService.ServiceStatusValue getServiceStatus() {
        String result = this.record.get("OPENSTATUS");
        if (result == null) {
            return this.delegate.getServiceStatus();
        }
        return (ITCPIPService.ServiceStatusValue)((CICSAttribute)TCPIPServiceType.SERVICE_STATUS).get(result, this.record.getNormalizers());
    }

    public String getTransid() {
        return this.delegate.getTransid();
    }

    public String getUrm() {
        String result = this.record.get("URM");
        if (result == null) {
            return this.delegate.getUrm();
        }
        return (String)((CICSAttribute)TCPIPServiceType.URM).get(result, this.record.getNormalizers());
    }

    public ITCPIPService.SsltypeValue getSsltype() {
        return this.delegate.getSsltype();
    }

    public Long getNumOfConnections() {
        return this.delegate.getNumOfConnections();
    }

    public String getTSQueuePrefix() {
        return this.delegate.getTSQueuePrefix();
    }

    public String getIPAddress() {
        return this.delegate.getIPAddress();
    }

    public Long getTranattach() {
        return this.delegate.getTranattach();
    }

    public Long getPeakconns() {
        return this.delegate.getPeakconns();
    }

    public Date getGmtservopn() {
        return this.delegate.getGmtservopn();
    }

    public Date getTimeopen() {
        return this.delegate.getTimeopen();
    }

    public Long getSends() {
        return this.delegate.getSends();
    }

    public Long getBytesent() {
        return this.delegate.getBytesent();
    }

    public Long getReceives() {
        return this.delegate.getReceives();
    }

    public Long getBytercvd() {
        return this.delegate.getBytercvd();
    }

    public ITCPIPService.SocketCloseActionValue getSocketCloseAction() {
        return this.delegate.getSocketCloseAction();
    }

    public Long getClosetimeout() {
        return this.delegate.getClosetimeout();
    }

    public ITCPIPService.AuthenticateValue getAuthenticate() {
        return this.delegate.getAuthenticate();
    }

    public String getCertificate() {
        return this.delegate.getCertificate();
    }

    public ITCPIPService.ProtocolValue getProtocol() {
        return this.delegate.getProtocol();
    }

    public String getDnsgroup() {
        return this.delegate.getDnsgroup();
    }

    public ITCPIPService.DnsstatusValue getDnsstatus() {
        String result = this.record.get("DNSSTATUS");
        if (result == null) {
            return this.delegate.getDnsstatus();
        }
        return (ITCPIPService.DnsstatusValue)((CICSAttribute)TCPIPServiceType.DNSSTATUS).get(result, this.record.getNormalizers());
    }

    public ITCPIPService.GrpcriticalValue getGrpcritical() {
        return this.delegate.getGrpcritical();
    }

    public ITCPIPService.AttachsecValue getAttachsec() {
        return this.delegate.getAttachsec();
    }

    public ITCPIPService.PrivacyValue getPrivacy() {
        return this.delegate.getPrivacy();
    }

    public String getCiphers() {
        return this.delegate.getCiphers();
    }

    public Long getNumciphers() {
        return this.delegate.getNumciphers();
    }

    public Long getMaxdatalen() {
        String result = this.record.get("MAXDATALEN");
        if (result == null) {
            return this.delegate.getMaxdatalen();
        }
        return (Long)((CICSAttribute)TCPIPServiceType.MAXDATALEN).get(result, this.record.getNormalizers());
    }

    public String getRealm() {
        return this.delegate.getRealm();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public ITCPIPService.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public ITCPIPService.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getIpresolved() {
        return this.delegate.getIpresolved();
    }

    public ITCPIPService.HosttypeValue getHosttype() {
        return this.delegate.getHosttype();
    }

    public ITCPIPService.IpfamilyValue getIpfamily() {
        return this.delegate.getIpfamily();
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public Long getMaxpersist() {
        return this.delegate.getMaxpersist();
    }

    public Long getNonpersist() {
        return this.delegate.getNonpersist();
    }

    public String getSpecificTCPIPService() {
        return this.delegate.getSpecificTCPIPService();
    }

    public String getGenericTCPIPService() {
        return this.delegate.getGenericTCPIPService();
    }

    public Long getTotalConnections() {
        return this.delegate.getTotalConnections();
    }

    public Long getTimesConnectionMadeNonPersistentAtMaxPersist() {
        return this.delegate.getTimesConnectionMadeNonPersistentAtMaxPersist();
    }

    public Long getTimesConnectionMadeNonPersistentAtTaskLimit() {
        return this.delegate.getTimesConnectionMadeNonPersistentAtTaskLimit();
    }

    public Long getTimesDisconnectedAtTaskLimit() {
        return this.delegate.getTimesDisconnectedAtTaskLimit();
    }

    public Long getTimesDisconnectedAtMaxUses() {
        return this.delegate.getTimesDisconnectedAtMaxUses();
    }

    public Long getCurrentBacklog() {
        return this.delegate.getCurrentBacklog();
    }

    public Long getConnectionsDropped() {
        return this.delegate.getConnectionsDropped();
    }

    public Date getTimeConnectionLastDropped() {
        return this.delegate.getTimeConnectionLastDropped();
    }

    public Long getCurrentMaximumBacklog() {
        return this.delegate.getCurrentMaximumBacklog();
    }

    public Long getRequests() {
        return this.delegate.getRequests();
    }

    public String getOptionsProgram() {
        return this.delegate.getOptionsProgram();
    }

    public ITCPIPService.AttlsValue getAttls() {
        return this.delegate.getAttls();
    }

    public void setBacklog(Long _Backlog) {
        if (_Backlog.equals(this.delegate.getBacklog())) {
            this.record.set("BACKLOG", null);
        } else {
            TCPIPServiceType.BACKLOG.validate((Object)_Backlog);
            String connectionSpecificExternalValue = ((CICSAttribute)TCPIPServiceType.BACKLOG).set(_Backlog, this.record.getNormalizers());
            this.record.set("BACKLOG", connectionSpecificExternalValue);
        }
    }

    public void setServiceStatus(ITCPIPService.ServiceStatusValue _serviceStatus) {
        if (_serviceStatus.equals((Object)this.delegate.getServiceStatus())) {
            this.record.set("OPENSTATUS", null);
        } else {
            TCPIPServiceType.SERVICE_STATUS.validate((Object)_serviceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)TCPIPServiceType.SERVICE_STATUS).set(_serviceStatus, this.record.getNormalizers());
            this.record.set("OPENSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setUrm(String _urm) {
        if (_urm.equals(this.delegate.getUrm())) {
            this.record.set("URM", null);
        } else {
            TCPIPServiceType.URM.validate((Object)_urm);
            String connectionSpecificExternalValue = ((CICSAttribute)TCPIPServiceType.URM).set(_urm, this.record.getNormalizers());
            this.record.set("URM", connectionSpecificExternalValue);
        }
    }

    public void setDnsstatus(ITCPIPService.DnsstatusValue _dnsstatus) {
        if (_dnsstatus.equals((Object)this.delegate.getDnsstatus())) {
            this.record.set("DNSSTATUS", null);
        } else {
            TCPIPServiceType.DNSSTATUS.validate((Object)_dnsstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)TCPIPServiceType.DNSSTATUS).set(_dnsstatus, this.record.getNormalizers());
            this.record.set("DNSSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setMaxdatalen(Long _maxdatalen) {
        if (_maxdatalen.equals(this.delegate.getMaxdatalen())) {
            this.record.set("MAXDATALEN", null);
        } else {
            TCPIPServiceType.MAXDATALEN.validate((Object)_maxdatalen);
            String connectionSpecificExternalValue = ((CICSAttribute)TCPIPServiceType.MAXDATALEN).set(_maxdatalen, this.record.getNormalizers());
            this.record.set("MAXDATALEN", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TCPIPServiceType.NAME) {
            return (V)this.getName();
        }
        if (attribute == TCPIPServiceType.PORT) {
            return (V)this.getPort();
        }
        if (attribute == TCPIPServiceType.BACKLOG) {
            return (V)this.getBacklog();
        }
        if (attribute == TCPIPServiceType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == TCPIPServiceType.TRANSID) {
            return (V)this.getTransid();
        }
        if (attribute == TCPIPServiceType.URM) {
            return (V)this.getUrm();
        }
        if (attribute == TCPIPServiceType.SSLTYPE) {
            return (V)this.getSsltype();
        }
        if (attribute == TCPIPServiceType.NUM_OF_CONNECTIONS) {
            return (V)this.getNumOfConnections();
        }
        if (attribute == TCPIPServiceType.TS_QUEUE_PREFIX) {
            return (V)this.getTSQueuePrefix();
        }
        if (attribute == TCPIPServiceType.IP_ADDRESS) {
            return (V)this.getIPAddress();
        }
        if (attribute == TCPIPServiceType.TRANATTACH) {
            return (V)this.getTranattach();
        }
        if (attribute == TCPIPServiceType.PEAKCONNS) {
            return (V)this.getPeakconns();
        }
        if (attribute == TCPIPServiceType.GMTSERVOPN) {
            return (V)this.getGmtservopn();
        }
        if (attribute == TCPIPServiceType.TIMEOPEN) {
            return (V)this.getTimeopen();
        }
        if (attribute == TCPIPServiceType.SENDS) {
            return (V)this.getSends();
        }
        if (attribute == TCPIPServiceType.BYTESENT) {
            return (V)this.getBytesent();
        }
        if (attribute == TCPIPServiceType.RECEIVES) {
            return (V)this.getReceives();
        }
        if (attribute == TCPIPServiceType.BYTERCVD) {
            return (V)this.getBytercvd();
        }
        if (attribute == TCPIPServiceType.SOCKET_CLOSE_ACTION) {
            return (V)this.getSocketCloseAction();
        }
        if (attribute == TCPIPServiceType.CLOSETIMEOUT) {
            return (V)this.getClosetimeout();
        }
        if (attribute == TCPIPServiceType.AUTHENTICATE) {
            return (V)this.getAuthenticate();
        }
        if (attribute == TCPIPServiceType.CERTIFICATE) {
            return (V)this.getCertificate();
        }
        if (attribute == TCPIPServiceType.PROTOCOL) {
            return (V)this.getProtocol();
        }
        if (attribute == TCPIPServiceType.DNSGROUP) {
            return (V)this.getDnsgroup();
        }
        if (attribute == TCPIPServiceType.DNSSTATUS) {
            return (V)this.getDnsstatus();
        }
        if (attribute == TCPIPServiceType.GRPCRITICAL) {
            return (V)this.getGrpcritical();
        }
        if (attribute == TCPIPServiceType.ATTACHSEC) {
            return (V)this.getAttachsec();
        }
        if (attribute == TCPIPServiceType.PRIVACY) {
            return (V)this.getPrivacy();
        }
        if (attribute == TCPIPServiceType.CIPHERS) {
            return (V)this.getCiphers();
        }
        if (attribute == TCPIPServiceType.NUMCIPHERS) {
            return (V)this.getNumciphers();
        }
        if (attribute == TCPIPServiceType.MAXDATALEN) {
            return (V)this.getMaxdatalen();
        }
        if (attribute == TCPIPServiceType.REALM) {
            return (V)this.getRealm();
        }
        if (attribute == TCPIPServiceType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == TCPIPServiceType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == TCPIPServiceType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == TCPIPServiceType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == TCPIPServiceType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == TCPIPServiceType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == TCPIPServiceType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == TCPIPServiceType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == TCPIPServiceType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == TCPIPServiceType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == TCPIPServiceType.IPRESOLVED) {
            return (V)this.getIpresolved();
        }
        if (attribute == TCPIPServiceType.HOSTTYPE) {
            return (V)this.getHosttype();
        }
        if (attribute == TCPIPServiceType.IPFAMILY) {
            return (V)this.getIpfamily();
        }
        if (attribute == TCPIPServiceType.HOST) {
            return (V)this.getHost();
        }
        if (attribute == TCPIPServiceType.MAXPERSIST) {
            return (V)this.getMaxpersist();
        }
        if (attribute == TCPIPServiceType.NONPERSIST) {
            return (V)this.getNonpersist();
        }
        if (attribute == TCPIPServiceType.SPECIFIC_TCPIP_SERVICE) {
            return (V)this.getSpecificTCPIPService();
        }
        if (attribute == TCPIPServiceType.GENERIC_TCPIP_SERVICE) {
            return (V)this.getGenericTCPIPService();
        }
        if (attribute == TCPIPServiceType.TOTAL_CONNECTIONS) {
            return (V)this.getTotalConnections();
        }
        if (attribute == TCPIPServiceType.TIMES_CONNECTION_MADE_NON_PERSISTENT_AT_MAX_PERSIST) {
            return (V)this.getTimesConnectionMadeNonPersistentAtMaxPersist();
        }
        if (attribute == TCPIPServiceType.TIMES_CONNECTION_MADE_NON_PERSISTENT_AT_TASK_LIMIT) {
            return (V)this.getTimesConnectionMadeNonPersistentAtTaskLimit();
        }
        if (attribute == TCPIPServiceType.TIMES_DISCONNECTED_AT_TASK_LIMIT) {
            return (V)this.getTimesDisconnectedAtTaskLimit();
        }
        if (attribute == TCPIPServiceType.TIMES_DISCONNECTED_AT_MAX_USES) {
            return (V)this.getTimesDisconnectedAtMaxUses();
        }
        if (attribute == TCPIPServiceType.CURRENT_BACKLOG) {
            return (V)this.getCurrentBacklog();
        }
        if (attribute == TCPIPServiceType.CONNECTIONS_DROPPED) {
            return (V)this.getConnectionsDropped();
        }
        if (attribute == TCPIPServiceType.TIME_CONNECTION_LAST_DROPPED) {
            return (V)this.getTimeConnectionLastDropped();
        }
        if (attribute == TCPIPServiceType.CURRENT_MAXIMUM_BACKLOG) {
            return (V)this.getCurrentMaximumBacklog();
        }
        if (attribute == TCPIPServiceType.REQUESTS) {
            return (V)this.getRequests();
        }
        if (attribute == TCPIPServiceType.OPTIONS_PROGRAM) {
            return (V)this.getOptionsProgram();
        }
        if (attribute == TCPIPServiceType.ATTLS) {
            return (V)this.getAttls();
        }
        return super.getAttributeValue(attribute);
    }

    public TCPIPServiceType getObjectType() {
        return TCPIPServiceType.getInstance();
    }

    @Override
    public TCPIPServiceReference getCICSObjectReference() {
        return new TCPIPServiceReference(this.getCICSContainer(), this.getName());
    }
}

