/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.sm.comm.AbstractCICSAction;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSActionNames;
import com.ibm.cics.sm.comm.ISystemManagerActionParameter;
import com.ibm.cics.sm.comm.actions.SimpleSystemManagerAction;

public class SystemManagerActions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final ICICSAction Acquire = new AbstractCICSAction("ACQUIRE"){};
    public static final ICICSAction Activate = new AbstractCICSAction("ACTIVATE"){};
    public static final ICICSAction AddToGroup = new AbstractCICSAction("ADDTOGRP"){};
    public static final ICICSAction Available = new SimpleSystemManagerAction("AVAILABLE"){};
    public static final ICICSAction Backout = new AbstractCICSAction("BACKOUT"){};
    public static final ICICSAction Cancel = new AbstractCICSAction("CANCEL"){};
    public static final ICICSAction Close = new AbstractCICSAction("CLOSE"){};
    public static final ICICSAction CloseWait = new SimpleSystemManagerAction("CLOSE", "BUSY", ICICSActionNames.Busy.WAIT);
    public static final ICICSAction CloseNoWait = new SimpleSystemManagerAction("CLOSE", "BUSY", ICICSActionNames.Busy.NOWAIT);
    public static final ICICSAction CloseForce = new SimpleSystemManagerAction("CLOSE", "BUSY", ICICSActionNames.Busy.FORCE);
    public static final ICICSAction CloseImmediate = new SimpleSystemManagerAction("IMMCLOSE");
    public static final ICICSAction Commit = new AbstractCICSAction("COMMIT"){};
    public static final ICICSAction Connect = new SimpleSystemManagerAction("CONNECT");
    public static final ICICSAction Delete = new AbstractCICSAction("DELETE"){};
    public static final ICICSAction Deregister = new AbstractCICSAction("DEREGISTER"){};
    public static final ICICSAction Disable = new SimpleSystemManagerAction("DISABLE");
    public static final ICICSAction DisableWait = new SimpleSystemManagerAction("DISABLE", "BUSY", ICICSActionNames.Busy.WAIT);
    public static final ICICSAction DisableNoWait = new SimpleSystemManagerAction("DISABLE", "BUSY", ICICSActionNames.Busy.NOWAIT);
    public static final ICICSAction DisableForce = new SimpleSystemManagerAction("DISABLE", "BUSY", ICICSActionNames.Busy.FORCE);
    public static final ICICSAction Discard = new SimpleSystemManagerAction("DISCARD");
    public static final ICICSAction DisconnectWait = new SimpleSystemManagerAction("DISCONNECT", "BUSY", ICICSActionNames.Busy.WAIT);
    public static final ICICSAction DisconnectNoWait = new SimpleSystemManagerAction("DISCONNECT", "BUSY", ICICSActionNames.Busy.NOWAIT);
    public static final ICICSAction DisconnectForce = new SimpleSystemManagerAction("DISCONNECT", "BUSY", ICICSActionNames.Busy.FORCE);
    public static final ICICSAction Enable = new SimpleSystemManagerAction("ENABLE");
    public static final ICICSAction EndAffinity = new AbstractCICSAction("ENDAFFINITY"){};
    public static final ICICSAction Flush = new AbstractCICSAction("FLUSH"){};
    public static final ICICSAction ForceCancel = new AbstractCICSAction("FORCECANCEL"){};
    public static final ICICSAction Force = new AbstractCICSAction("FORCE"){};
    public static final ICICSAction Install = new AbstractCICSAction("INSTALL"){};
    public static final ICICSAction Lock = new AbstractCICSAction("CSDLOCK"){};
    public static final ICICSAction NewCopy = new AbstractCICSAction("NEWCOPY"){};
    public static final ICICSAction NoRecoveryData = new AbstractCICSAction("NORECOVDATA"){};
    public static final ICICSAction NotPending = new AbstractCICSAction("NOTPENDING"){};
    public static final ICICSAction Open = new AbstractCICSAction("OPEN"){};
    public static final ICICSAction PhaseIn = new AbstractCICSAction("PHASEIN"){};
    public static final ICICSAction PhaseOut = new AbstractCICSAction("PHASEOUT"){};
    public static final ICICSAction Quiesce = new AbstractCICSAction("QUIESCE"){};
    public static final ICICSAction Rebuild = new AbstractCICSAction("REBUILD"){};
    public static final ICICSAction Release = new AbstractCICSAction("RELEASE"){};
    public static final ICICSAction Remove = new AbstractCICSAction("REMOVE"){};
    public static final ICICSAction Reset = new AbstractCICSAction("RESET"){};
    public static final ICICSAction Resynchronize = new AbstractCICSAction("RESYNC"){};
    public static final ICICSAction Scan = new AbstractCICSAction("SCAN"){};
    public static final ICICSAction ResetStatistics = new SimpleSystemManagerAction("STATISTICS", ICICSActionNames.Statistics.RESETNOW);
    public static final ICICSAction Inservice = new AbstractCICSAction("INSERVICE"){};
    public static final ICICSAction Outservice = new AbstractCICSAction("OUTSERVICE"){};
    public static final ICICSAction Purge = new AbstractCICSAction("PURGE"){};
    public static final ICICSAction ForcePurge = new AbstractCICSAction("FORCEPURGE"){};
    public static final ICICSAction Kill = new AbstractCICSAction("KILL"){};
    public static final ICICSAction ARMRestart = new AbstractCICSAction("ARMRESTART"){};
    public static final ICICSAction DeleteShipped = new AbstractCICSAction("DELETSHIPPED"){};
    public static final ICICSAction ResetTime = new AbstractCICSAction("RESETTIME"){};
    public static final ICICSAction SecurityRebuild = new AbstractCICSAction("SECREBUILD"){};
    public static final ICICSAction SSLRebuild = new AbstractCICSAction("SSLREBUILD", CICSRelease.e680, null){};
    public static final ICICSAction TagsRefresh = new AbstractCICSAction("TAGSREFR"){};
    public static final ICICSAction Write = new AbstractCICSAction("WRITE"){};
    public static final ICICSAction On = new AbstractCICSAction("ON"){};
    public static final ICICSAction Off = new AbstractCICSAction("OFF"){};
    public static final ICICSAction Switch = new AbstractCICSAction("SWITCH"){};
    public static final ICICSAction Unavailable = new AbstractCICSAction("UNAVAILABLE"){};
    public static final ICICSAction Unlock = new AbstractCICSAction("CSDUNLOCK"){};
    public static final ICICSAction EventProcessing = new AbstractCICSAction("EVENT_PROCESSING"){};
    public static final ICICSAction Start = new AbstractCICSAction("START"){};
    public static final ICICSAction Drain = new AbstractCICSAction("DRAIN"){};
    public static final ICICSAction Stop = new AbstractCICSAction("STOP"){};
    public static final ICICSAction PurgeTask = new SimpleSystemManagerAction("PURGE", "TYPE", ICICSActionNames.Purge.PURGE);
    public static final ICICSAction ForcePurgeTask = new AbstractCICSAction("FORCEPURGE"){};
    public static final ICICSAction KillTask = new AbstractCICSAction("KILL"){};
    public static final ICICSAction PurgeJVMClassCacheAutoStart = new SimpleSystemManagerAction("PURGE", "AUTOSTARTST", ICICSActionNames.Autostart.ENABLED);
    public static final ICICSAction PurgeJVMClassCacheNoAutoStart = new SimpleSystemManagerAction("PURGE", "AUTOSTARTST", ICICSActionNames.Autostart.DISABLED);
    public static final ICICSAction ForcePurgeJVMClassCacheAutoStart = new SimpleSystemManagerAction("FORCEPURGE", "AUTOSTARTST", ICICSActionNames.Autostart.ENABLED);
    public static final ICICSAction ForcePurgeJVMClassCacheNoAutoStart = new SimpleSystemManagerAction("FORCEPURGE", "AUTOSTARTST", ICICSActionNames.Autostart.DISABLED);
    public static final ICICSAction PhaseOutJVMClassCacheAutoStart = new SimpleSystemManagerAction("PHASEOUT", "AUTOSTARTST", ICICSActionNames.Autostart.ENABLED);
    public static final ICICSAction PhaseOutJVMClassCacheNoAutoStart = new SimpleSystemManagerAction("PHASEOUT", "AUTOSTARTST", ICICSActionNames.Autostart.DISABLED);
    public static final ICICSAction DisablePhaseOutJVMServer = new SimpleSystemManagerAction("DISABLE");
    public static final ICICSAction DisablePurgeJVMServer = new SimpleSystemManagerAction("DISABLE", "PURGETYPE", ICICSActionNames.JVMServerPurgeType.PURGE, CICSRelease.e660, null);
    public static final ICICSAction DisableForcePurgeJVMServer = new SimpleSystemManagerAction("DISABLE", "PURGETYPE", ICICSActionNames.JVMServerPurgeType.FORCEPURGE, CICSRelease.e660, null);
    public static final ICICSAction DisableKillJVMServer = new SimpleSystemManagerAction("DISABLE", "PURGETYPE", ICICSActionNames.JVMServerPurgeType.KILL, CICSRelease.e660, null);
    public static final ICICSAction PerformJVMDumpAll = new SimpleSystemManagerAction("JVMDUMP", "DUMPTYPE", ICICSActionNames.JVMDumpType.ALL, CICSRelease.e730, null);
    public static final ICICSAction PerformJVMDumpHeap = new SimpleSystemManagerAction("JVMDUMP", "DUMPTYPE", ICICSActionNames.JVMDumpType.HEAP, CICSRelease.e730, null);
    public static final ICICSAction PerformJVMDumpJavaCore = new SimpleSystemManagerAction("JVMDUMP", "DUMPTYPE", ICICSActionNames.JVMDumpType.JAVACORE, CICSRelease.e730, null);
    public static final ICICSAction PerformJVMDumpSnapTrace = new SimpleSystemManagerAction("JVMDUMP", "DUMPTYPE", ICICSActionNames.JVMDumpType.SNAPTRACE, CICSRelease.e730, null);
    public static final ICICSAction PerformJVMCollectDiagnostics = new SimpleSystemManagerAction("JVMDIAG", CICSRelease.e730, null);
    public static final ICICSAction PerformJVMStackTrace = new SimpleSystemManagerAction("JVMSTACKTRC", CICSRelease.e740, null);
    public static final ICICSAction LibertyRefreshApplication = new SimpleSystemManagerAction("LIBREFAPPL", CICSRelease.e730, null);
    public static final ICICSAction LibertyRefreshConfiguration = new SimpleSystemManagerAction("LIBREFCONFIG", CICSRelease.e730, null);
    public static final ICICSAction LibertyServerDump = new SimpleSystemManagerAction("LIBDUMP", CICSRelease.e730, null);
    public static final ICICSAction OSGiRefreshPackages = new SimpleSystemManagerAction("OSGIREFPKG", CICSRelease.e730, null);
    public static final ICICSAction Suspend = new SimpleSystemManagerAction("SUSPEND"){};
    public static final ICICSAction Resume = new SimpleSystemManagerAction("RESUME"){};
    public static final ICICSAction ShutdownNormal = new SimpleSystemManagerAction("SHUTDOWN");
    public static final ICICSAction ShutdownImmediate = new SimpleSystemManagerAction("SHUTDOWN", RegionShutdownType.IMMEDIATE);
    public static final ICICSAction ShutdownTakeover = new SimpleSystemManagerAction("SHUTDOWN", RegionShutdownType.TAKEOVER);
    public static final ICICSAction StopUncon = new AbstractCICSAction("STOPUNCON"){};
    public static final ICICSAction ForceDiscon = new AbstractCICSAction("FORCEDISCON"){};
    public static final ICICSAction Snap = new SimpleSystemManagerAction("SNAP"){};
    public static final ICICSAction CSDAppend = new CSDAppendAction();
    public static final ICICSAction CSDAdd = new CSDAddAction();
    public static final ICICSAction AddToResourceDescription = new AddToResourceDescriptionAction();
    public static final ICICSAction Active = new SimpleSystemManagerAction("ACTIVE");
    public static final ICICSAction Dormant = new SimpleSystemManagerAction("DORMANT");
    public static final ICICSAction CollectStatistics = new CollectRegionStatisticsAction();
    public static final ICICSAction InstallWorkloadManagementDefinition = new SimpleSystemManagerAction("INSTALL");
    public static final ICICSAction Publish = new AbstractCICSAction("PUBLISH"){};
    public static final ICICSAction Retract = new AbstractCICSAction("RETRACT"){};
    public static final ICICSAction JVMPoolPhaseOut = new JVMPoolPhaseOutAction();
    public static final ICICSAction ShutdownCMAS = new SimpleSystemManagerAction("SHUTDOWN");
    public static final ICICSAction PurgeIncoreESMSecurityProfiles = new SimpleSystemManagerAction("PURGE");
    public static final ICICSAction RebuildIncoreESMSecurityProfiles = new SimpleSystemManagerAction("SECREBUILD");
    public static final ICICSAction CPSMDump = new SimpleSystemManagerAction("CPSMDUMP");
    public static final ICICSAction ResetUserid = new SimpleSystemManagerAction("RESET");

    private SystemManagerActions() {
    }

    public static final class AddBundleAction
    extends AbstractCICSAction {
        public static final String BUNDLEID_PARAMETER = "BUNDLEID";
        public static final String BUNDMAJORVER_PARAMETER = "BUNDMAJORVER";
        public static final String BUNDMINORVER_PARAMETER = "BUNDMINORVER";
        public static final String BUNDMICROVER_PARAMETER = "BUNDMICROVER";
        public static final String REGIONTYPE_PARAMETER = "REGIONTYPE";

        public AddBundleAction(String bundleid, String bundlemajorver, String bundleminorver, String bundlemicrover, String regiontype) {
            super("ADDBUNDLE");
            this.parameters.put(BUNDLEID_PARAMETER, bundleid);
            this.parameters.put(BUNDMAJORVER_PARAMETER, bundlemajorver);
            this.parameters.put(BUNDMINORVER_PARAMETER, bundleminorver);
            this.parameters.put(BUNDMICROVER_PARAMETER, bundlemicrover);
            this.parameters.put(REGIONTYPE_PARAMETER, regiontype);
        }
    }

    public static final class AddExistingRegionToRegionTypeAction
    extends AbstractCICSAction {
        public static final String REGION_PARAMETER = "CSYSDEF_NAME";
        public static final String REGIONTYPE_PARAMETER = "REGIONTYPE";
        public static final String APPLID_PARAMETER = "APPLID";
        public static final String SYSID_PARAMETER = "SYSID";

        public AddExistingRegionToRegionTypeAction(String region, String regiontype) {
            super("ADDREGION");
            this.parameters.put(REGION_PARAMETER, region);
            this.parameters.put(REGIONTYPE_PARAMETER, regiontype);
        }
    }

    public static final class AddNewRegionToRegionTypeAction
    extends AbstractCICSAction {
        public static final String REGION_PARAMETER = "CSYSDEF_NAME";
        public static final String REGIONTYPE_PARAMETER = "REGIONTYPE";
        public static final String APPLID_PARAMETER = "APPLID";
        public static final String SYSID_PARAMETER = "SYSID";
        public static final String PRIMARY_CMAS_PARAMETER = "PRICMAS";
        public static final String DESCRIPTION_PARAMETER = "DESCRIPTION";

        public AddNewRegionToRegionTypeAction(String region, String regiontype, String applid, String sysid, String priCMAS, String description) {
            super("ADDREGION");
            this.parameters.put(REGION_PARAMETER, region);
            this.parameters.put(REGIONTYPE_PARAMETER, regiontype);
            this.parameters.put(APPLID_PARAMETER, applid);
            this.parameters.put(SYSID_PARAMETER, sysid);
            if (priCMAS.length() > 0) {
                this.parameters.put(PRIMARY_CMAS_PARAMETER, priCMAS);
            }
        }
    }

    public static final class AddToResourceDescriptionAction
    extends AbstractCICSAction {
        public static final String TARGET_RESOURCE_DESCRIPTION_PARAMETER = "RESDESC";

        public AddToResourceDescriptionAction() {
            super("ADDTODSC");
        }

        public void setTargetResourceDescription(String resourceDescriptionName) {
            this.parameters.put(TARGET_RESOURCE_DESCRIPTION_PARAMETER, resourceDescriptionName);
        }

        public String getTargetResourceDescription() {
            return (String)this.parameters.get(TARGET_RESOURCE_DESCRIPTION_PARAMETER);
        }
    }

    public static class AddWorkloadDefinitionToWorkloadGroupAction
    extends AbstractCICSAction
    implements ICICSAction {
        public static final String RESGROUP_PARAMETER = "RESGROUP";

        public AddWorkloadDefinitionToWorkloadGroupAction(String group) {
            super("ADDTOGRP");
            this.parameters.put(RESGROUP_PARAMETER, group);
        }
    }

    public static final class AddWorkloadGroupToWorkloadSpecificationAction
    extends AbstractCICSAction {
        public static final String SPEC_PARAMETER = "SPEC";

        public AddWorkloadGroupToWorkloadSpecificationAction(String spec) {
            super("ADDTOSPC");
            this.parameters.put(SPEC_PARAMETER, spec);
        }
    }

    public static final class AssignAction
    extends AbstractCICSAction {
        public static final String ASSIGN_CICSPLEX_PARAMETER = "CICSPLEX";
        public static final String ASSIGN_CMASNAME_PARAMETER = "CMAS";

        public AssignAction(String cicsplex, String cmasName) {
            super("ASSIGN");
            this.parameters.put(ASSIGN_CICSPLEX_PARAMETER, cicsplex);
            this.parameters.put(ASSIGN_CMASNAME_PARAMETER, cmasName);
        }
    }

    public static final class BatchedRepositoryUpdateAction
    extends AbstractCICSAction {
        public static final String BATCHED_INPUTDSN_PARAMETER = "INPUTDSN";
        public static final String BATCHED_INPUTMEMBER_PARAMETER = "INPUTMEMBER";
        public static final String BATCHED_PRINTCLASS_PARAMETER = "PRINTCLASS";
        public static final String BATCHED_PRINTNODE_PARAMETER = "PRINTNODE";
        public static final String BATCHED_OUTPUTUSER_PARAMETER = "OUTPUTUSER";

        public BatchedRepositoryUpdateAction(String action) {
            super(action);
        }

        public void setDataSetName(String dataSetName) {
            this.parameters.put(BATCHED_INPUTDSN_PARAMETER, dataSetName);
        }

        public void setMemberName(String memberName) {
            if (memberName != null && !memberName.isEmpty()) {
                this.parameters.put(BATCHED_INPUTMEMBER_PARAMETER, memberName);
            }
        }

        public void setPrintClass(String printClass) {
            if (printClass != null && !printClass.isEmpty()) {
                this.parameters.put(BATCHED_PRINTCLASS_PARAMETER, printClass);
            }
        }

        public void setPrintNode(String printNode) {
            this.parameters.put(BATCHED_PRINTNODE_PARAMETER, printNode);
        }

        public void setDestinationUserId(String destUserID) {
            this.parameters.put(BATCHED_OUTPUTUSER_PARAMETER, destUserID);
        }
    }

    public static final class CPSMDumpAction
    extends AbstractCICSAction {
        public static final String ASID_PARAMETER = "ASID(xxxx)";
        public static final String BUSINESS_APPLICATION_SERVICES_PARAMETER = "BAS";
        public static final String CACHE_MANAGER_PARAMETER = "CHE";
        public static final String COMMUNICATIONS_PARAMETER = "COM";
        public static final String DATA_REPOSITORY_PARAMETER = "DAT";
        public static final String MANAGED_APPLICATION_SYSTEM_PARAMETER = "MAS";
        public static final String MONITORING_PARAMETER = "MON";
        public static final String QUEUE_MANAGER_PARAMETER = "QUE";
        public static final String REAL_TIME_ANALYSIS_PARAMETER = "RTA";
        public static final String TOPOLOGY_PARAMETER = "TOP";
        public static final String WORKLOAD_MANAGER_PARAMETER = "WLM";

        public CPSMDumpAction(String asid, boolean bas, boolean che, boolean com, boolean dat, boolean mas, boolean mon, boolean que, boolean rta, boolean top, boolean wlm) {
            super("CPSMDUMP");
            if (StringUtil.hasContent((String)asid)) {
                String asidParm = ASID_PARAMETER.replace("xxxx", asid);
                this.parameters.put(asidParm, null);
            }
            if (bas) {
                this.parameters.put(BUSINESS_APPLICATION_SERVICES_PARAMETER, null);
            }
            if (che) {
                this.parameters.put(CACHE_MANAGER_PARAMETER, null);
            }
            if (com) {
                this.parameters.put(COMMUNICATIONS_PARAMETER, null);
            }
            if (dat) {
                this.parameters.put(DATA_REPOSITORY_PARAMETER, null);
            }
            if (mas) {
                this.parameters.put(MANAGED_APPLICATION_SYSTEM_PARAMETER, null);
            }
            if (mon) {
                this.parameters.put(MONITORING_PARAMETER, null);
            }
            if (que) {
                this.parameters.put(QUEUE_MANAGER_PARAMETER, null);
            }
            if (rta) {
                this.parameters.put(REAL_TIME_ANALYSIS_PARAMETER, null);
            }
            if (top) {
                this.parameters.put(TOPOLOGY_PARAMETER, null);
            }
            if (wlm) {
                this.parameters.put(WORKLOAD_MANAGER_PARAMETER, null);
            }
        }
    }

    public static final class CSDAddAction
    extends AbstractCICSAction {
        public static final String TO_CSDLIST = "TO_CSDLIST";
        public static final String ADD_CSDGROUP = "ADD_CSDGROUP";
        public static final String ADD_LOCATION = "ADD_LOCATION";

        public CSDAddAction() {
            super("CSDADD");
        }

        public void setTargetCSDList(String csdListName) {
            this.parameters.put(TO_CSDLIST, csdListName);
        }

        public void setAddCSDGroup(String csdGroupName) {
            this.parameters.put(ADD_CSDGROUP, csdGroupName);
        }

        public void setAddLocation(String addLocation) {
            this.parameters.put(ADD_LOCATION, addLocation);
        }

        public String getTargetCSDList() {
            return (String)this.parameters.get(TO_CSDLIST);
        }

        public String getAddCSDGroup() {
            return (String)this.parameters.get(ADD_CSDGROUP);
        }

        public String getAddLocation() {
            return (String)this.parameters.get(ADD_LOCATION);
        }
    }

    public static final class CSDAppendAction
    extends AbstractCICSAction {
        public static final String TARGET_CSDLIST_PARAMETER = "TO_CSDLIST";

        public CSDAppendAction() {
            super("CSDAPPEND");
        }

        public void setTargetCSDList(String destinationCSDList) {
            this.parameters.put(TARGET_CSDLIST_PARAMETER, destinationCSDList);
        }
    }

    public static final class CSDCopyAction
    extends AbstractCICSAction {
        public static final String TARGET_CSDGROUP_PARAMETER = "TO_CSDGROUP";
        public static final String TARGET_RESOURCE_NAME_PARAMETER = "AS_RESOURCE";

        public CSDCopyAction() {
            super("CSDCOPY");
        }

        public void setTargetResource(String destinationResourceName) {
            this.parameters.put(TARGET_RESOURCE_NAME_PARAMETER, destinationResourceName);
        }

        public void setTargetCSDGroup(String destinationCSDGroup) {
            this.parameters.put(TARGET_CSDGROUP_PARAMETER, destinationCSDGroup);
        }
    }

    public static final class ChangeWorkloadSpecificationGroupAssociationAction
    extends AbstractCICSAction {
        public static final String NEW_SPEC_PARAMETER = "NEW_SPECNAME";

        public ChangeWorkloadSpecificationGroupAssociationAction(String newSpec, String inherit) {
            super("CHGSPEC");
            this.parameters.put(NEW_SPEC_PARAMETER, newSpec);
            this.parameters.put(inherit, null);
        }
    }

    public static final class ChangeWorkloadSpecificationSystemAssociationAction
    extends AbstractCICSAction {
        public static final String NEW_SPEC_PARAMETER = "NEW_SPECNAME";

        public ChangeWorkloadSpecificationSystemAssociationAction(String newSpec) {
            super("CHGSPEC");
            this.parameters.put(NEW_SPEC_PARAMETER, newSpec);
        }
    }

    public static final class CollectRegionStatisticsAction
    extends AbstractCICSAction {
        public CollectRegionStatisticsAction() {
            super("STATISTICS");
        }
    }

    public static class InstallWorkloadManagementDefinition
    extends AbstractCICSAction {
        public static final String WORKLOAD_PARAMETER = "WORKLOAD";
        public static final String OWNER_PARAMETER = "OWNER";

        public InstallWorkloadManagementDefinition(String workload, String owner) {
            super("INSTALL");
            this.setWorkload(workload);
            this.setOwner(owner);
        }

        public void setWorkload(String workload) {
            this.parameters.put(WORKLOAD_PARAMETER, workload);
        }

        public void setOwner(String owner) {
            this.parameters.put(OWNER_PARAMETER, owner);
        }

        public String getWorkload() {
            return (String)this.parameters.get(WORKLOAD_PARAMETER);
        }

        public String getOwner() {
            return (String)this.parameters.get(OWNER_PARAMETER);
        }
    }

    public static final class JVMPoolPhaseOutAction
    extends AbstractCICSAction {
        public static final String JVM_PROFILE_PARAMETER = "JVMPROFILE";

        public JVMPoolPhaseOutAction() {
            super("PHASEOUT");
        }

        public void setJVMProfile(String jvmProfile) {
            this.parameters.put(JVM_PROFILE_PARAMETER, jvmProfile);
        }

        public void clearJVMProfile() {
            this.parameters.remove(JVM_PROFILE_PARAMETER);
        }
    }

    public static final class LibertyRefreshApplicationAction
    extends AbstractCICSAction {
        public static final String APPLICATION_ID_PARAMETER = "APPID";
        public static final String APPLICATION_ID_LEN_PARAMETER = "APPIDLEN";

        public LibertyRefreshApplicationAction() {
            super("LIBREFAPPL");
        }

        public void setApplicationId(String applicationId) {
            this.parameters.put(APPLICATION_ID_PARAMETER, applicationId);
            this.parameters.put(APPLICATION_ID_LEN_PARAMETER, Integer.toString(applicationId.length()));
        }
    }

    public static final class PerformJVMStackTraceAction
    extends AbstractCICSAction {
        public static final String TASK_ID_PARAMETER = "TASKID";

        public PerformJVMStackTraceAction() {
            super("JVMSTACKTRC");
        }

        public void setApplicationId(String applicationId) {
            this.parameters.put(TASK_ID_PARAMETER, applicationId);
        }
    }

    public static enum RegionShutdownType implements ISystemManagerActionParameter
    {
        NORMAL,
        IMMEDIATE,
        TAKEOVER;

    }

    public static final class RemoveBundleAction
    extends AbstractCICSAction {
        public static final String BUNDLEID_PARAMETER = "BUNDLEID";
        public static final String BUNDMAJORVER_PARAMETER = "BUNDMAJORVER";
        public static final String BUNDMINORVER_PARAMETER = "BUNDMINORVER";
        public static final String BUNDMICROVER_PARAMETER = "BUNDMICROVER";
        public static final String REGIONTYPE_PARAMETER = "REGIONTYPE";

        public RemoveBundleAction(String bundleid, String bundlemajorver, String bundleminorver, String bundlemicrover, String regiontype) {
            super("REMOVEBUNDLE");
            this.parameters.put(BUNDLEID_PARAMETER, bundleid);
            this.parameters.put(BUNDMAJORVER_PARAMETER, bundlemajorver);
            this.parameters.put(BUNDMINORVER_PARAMETER, bundleminorver);
            this.parameters.put(BUNDMICROVER_PARAMETER, bundlemicrover);
            this.parameters.put(REGIONTYPE_PARAMETER, regiontype);
        }
    }

    public static final class RemoveRegionFromRegionTypeAction
    extends AbstractCICSAction {
        public static final String REGION_PARAMETER = "CSYSDEF_NAME";
        public static final String REGIONTYPE_PARAMETER = "REGIONTYPE";
        public static final String APPLID_PARAMETER = "APPLID";
        public static final String SYSID_PARAMETER = "SYSID";

        public RemoveRegionFromRegionTypeAction(String region, String regiontype) {
            super("REMOVEREGION");
            this.parameters.put(REGION_PARAMETER, region);
            this.parameters.put(REGIONTYPE_PARAMETER, regiontype);
        }
    }

    public static final class ResetUseridAction
    extends AbstractCICSAction {
        public static final String USERID_PARAMETER = "USERID";

        public ResetUseridAction(String asid) {
            super("RESET");
            this.parameters.put(USERID_PARAMETER, asid);
        }
    }

    public static final class SecurityRequestRecordingAddAction
    extends AbstractCICSAction {
        public SecurityRequestRecordingAddAction(String srrName, String srrODADPTRID, String srrMaximum, String srrODADPTRDATA1, String srrODADPTRDATA2, String srrODADPTRDATA3, String srrODAPPLID, String srrODCLNTIPADDR, String srrODCLNTPORT, String srrODFACILNAME, String srrODFACILTYPE, String srrODIPFAMILY, String srrODLUNAME, String srrODNETID, String srrODNETWORKID, String srrODSERVERPORT, String srrODTCPIPS, String srrODTRANSID, String srrODUSERID) {
            super("SRRADD");
            this.parameters.put("SECRECID", srrName);
            if (srrMaximum.length() > 0) {
                this.parameters.put("MAXIMUM", srrMaximum);
            }
            if (srrODADPTRID.length() > 0) {
                this.parameters.put("ODADPTRID", srrODADPTRID);
            }
            if (srrODADPTRDATA1.length() > 0) {
                this.parameters.put("ODADPTRDATA1", srrODADPTRDATA1);
            }
            if (srrODADPTRDATA2.length() > 0) {
                this.parameters.put("ODADPTRDATA2", srrODADPTRDATA2);
            }
            if (srrODADPTRDATA3.length() > 0) {
                this.parameters.put("ODADPTRDATA3", srrODADPTRDATA3);
            }
            if (srrODAPPLID.length() > 0) {
                this.parameters.put("ODAPPLID", srrODAPPLID);
            }
            if (srrODCLNTIPADDR.length() > 0) {
                this.parameters.put("ODCLNTIPADDR", srrODCLNTIPADDR);
            }
            if (srrODCLNTPORT.length() > 0) {
                this.parameters.put("ODCLNTPORT", srrODCLNTPORT);
            }
            if (srrODFACILNAME.length() > 0) {
                this.parameters.put("ODFACILNAME", srrODFACILNAME);
            }
            if (srrODFACILTYPE.length() > 0) {
                this.parameters.put("ODFACILTYPE", srrODFACILTYPE);
            }
            if (srrODIPFAMILY.length() > 0) {
                this.parameters.put("ODIPFAMILY", srrODIPFAMILY);
            }
            if (srrODLUNAME.length() > 0) {
                this.parameters.put("ODLUNAME", srrODLUNAME);
            }
            if (srrODNETID.length() > 0) {
                this.parameters.put("ODNETID", srrODNETID);
            }
            if (srrODNETWORKID.length() > 0) {
                this.parameters.put("ODNETWORKID", srrODNETWORKID);
            }
            if (srrODSERVERPORT.length() > 0) {
                this.parameters.put("ODSERVERPORT", srrODSERVERPORT);
            }
            if (srrODTCPIPS.length() > 0) {
                this.parameters.put("ODTCPIPS", srrODTCPIPS);
            }
            if (srrODTRANSID.length() > 0) {
                this.parameters.put("ODTRANSID", srrODTRANSID);
            }
            if (srrODUSERID.length() > 0) {
                this.parameters.put("ODUSERID", srrODUSERID);
            }
        }
    }

    public static final class ShutdownAction
    extends AbstractCICSAction {
        private static final String SHUTDOWN_DUMP_PARAMETER = "DUMP";
        private static final String SHUTDOWN_IMMEDIATE_PARAMETER = "IMMEDIATE";
        private static final String SHUTDOWN_NORESTART_PARAMETER = "NORESTART";
        private static final String SHUTDOWN_NOSDTRAN_PARAMETER = "NOSDTRAN";
        private static final String SHUTDOWN_SDTRAN_PARAMETER = "SDTRAN";
        private static final String SHUTDOWN_RESTART_PARAMETER = "RESTART";
        private static final String SHUTDOWN_PLT_PARAMETER = "PLT";
        private static final String SHUTDOWN_XLT_PARAMETER = "XLT";

        public ShutdownAction() {
            super("SHUTDOWN");
        }

        public void setDUMP() {
            this.parameters.put(SHUTDOWN_DUMP_PARAMETER, null);
        }

        public void setImmediate() {
            this.parameters.put(SHUTDOWN_IMMEDIATE_PARAMETER, null);
        }

        public void setSdtran(String sdTranName) {
            this.parameters.put(SHUTDOWN_SDTRAN_PARAMETER, sdTranName);
        }

        public void setNorestart() {
            this.parameters.put(SHUTDOWN_NORESTART_PARAMETER, null);
        }

        public void setNosdtran() {
            this.parameters.put(SHUTDOWN_NOSDTRAN_PARAMETER, null);
        }

        public void setRestart() {
            this.parameters.put(SHUTDOWN_RESTART_PARAMETER, null);
        }

        public void setPlt(String pltSuffix) {
            this.parameters.put(SHUTDOWN_PLT_PARAMETER, pltSuffix);
        }

        public void setXlt(String xltSuffix) {
            this.parameters.put(SHUTDOWN_XLT_PARAMETER, xltSuffix);
        }
    }

    public static final class SnapDumpAction
    extends AbstractCICSAction {
        public static final String SNAP_DUMPCODE_PARAMETER = "DUMPCODE";
        public static final String SNAP_CALLER_PARAMETER = "CALLER";
        public static final String SNAP_TITLE_PARAMETER = "TITLE";

        public SnapDumpAction() {
            super("SNAP");
        }

        public void setDumpCode(String dumpCode) {
            this.parameters.put(SNAP_DUMPCODE_PARAMETER, dumpCode);
        }

        public void clearDumpCode() {
            this.parameters.remove(SNAP_DUMPCODE_PARAMETER);
        }

        public void setCaller(String caller) {
            this.parameters.put(SNAP_CALLER_PARAMETER, caller);
        }

        public void clearCaller() {
            this.parameters.remove(SNAP_CALLER_PARAMETER);
        }

        public void setTitle(String title) {
            this.parameters.put(SNAP_TITLE_PARAMETER, title);
        }

        public void clearsetTitle() {
            this.parameters.remove(SNAP_TITLE_PARAMETER);
        }
    }

    public static final class SystemDumpCodeAddAction
    extends AbstractCICSAction {
        public static final String CODE_PARAMETER = "CODE";
        public static final String MAXDUMP_PARAMETER = "MAX";
        public static final String SCOPE_PARAMETER = "SCOPE";
        public static final String SHUTDOWN_PARAMETER = "SHUT";
        public static final String SDUMP_PARAMETER = "SDUMP";
        public static final String DAE_PARAMETER = "DAE";

        public SystemDumpCodeAddAction(String dumpCode, String maxDumps, String dumpRequired, String shutdownValue, String dumpScope, String dae) {
            super("ADD");
            this.parameters.put(CODE_PARAMETER, dumpCode);
            if (maxDumps.length() > 0) {
                this.parameters.put(MAXDUMP_PARAMETER, maxDumps);
            }
            if (dumpRequired.length() > 0) {
                this.parameters.put(SDUMP_PARAMETER, dumpRequired);
            }
            if (shutdownValue.length() > 0) {
                this.parameters.put(SHUTDOWN_PARAMETER, shutdownValue);
            }
            if (dumpScope.length() > 0) {
                this.parameters.put(SCOPE_PARAMETER, dumpScope);
            }
            if (dae.length() > 0) {
                this.parameters.put(DAE_PARAMETER, dae);
            }
        }
    }

    public static final class TranDumpCodeAddAction
    extends AbstractCICSAction {
        public static final String CODE_PARAMETER = "CODE";
        public static final String MAX_PARAMETER = "MAX";
        public static final String SCOPE_PARAMETER = "SCOPE";
        public static final String SHUT_PARAMETER = "SHUT";
        public static final String SDUMP_PARAMETER = "SDUMP";
        public static final String TDUMP_PARAMETER = "TDUMP";

        public TranDumpCodeAddAction(String dumpCode, String maximum, String tranDumping, String sysDumping, String shutOption, String dumpScope) {
            super("ADD");
            this.parameters.put(CODE_PARAMETER, dumpCode);
            this.parameters.put(MAX_PARAMETER, maximum);
            if (tranDumping.trim().length() > 0) {
                this.parameters.put(TDUMP_PARAMETER, tranDumping);
            }
            if (sysDumping.trim().length() > 0) {
                this.parameters.put(SDUMP_PARAMETER, sysDumping);
            }
            if (shutOption.trim().length() > 0) {
                this.parameters.put(SHUT_PARAMETER, shutOption);
            }
            if (dumpScope.trim().length() > 0) {
                this.parameters.put(SCOPE_PARAMETER, dumpScope);
            }
        }
    }

    public static final class UnassignAction
    extends AbstractCICSAction {
        public static final String UNASSIGN_CICSPLEX_PARAMETER = "CICSPLEX";
        public static final String UNASSIGN_CMASNAME_PARAMETER = "CMAS";
        public static final String UNASSIGN_FORCE_PARAMETER = "FORCE";

        public UnassignAction(String cicsplex, String cmasName, boolean force) {
            super("UNASSIGN");
            this.parameters.put(UNASSIGN_CICSPLEX_PARAMETER, cicsplex);
            this.parameters.put(UNASSIGN_CMASNAME_PARAMETER, cmasName);
            if (force) {
                this.parameters.put(UNASSIGN_FORCE_PARAMETER, UNASSIGN_FORCE_PARAMETER);
            }
        }
    }
}

