/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.Activator;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ConnectionsPreferenceInitializer
extends AbstractPreferenceInitializer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionsPreferenceInitializer.class);

    public void initializeDefaultPreferences() {
        debug.enter("initializeDefaultPreferences");
        IEclipsePreferences preferences = Activator.getDefault().getPluginDefaultPreferences();
        preferences.putBoolean("com.ibm.cics.core.comm.restrictCertificateImport", false);
        preferences.putBoolean("com.ibm.cics.core.comm.security.initialised", false);
        preferences.put("com.ibm.cics.core.comm.truststore.dbType", "JKS");
        preferences.put("com.ibm.cics.core.comm.keystore.dbType", "JKS");
        preferences.putBoolean("com.ibm.cics.core.comm.truststore.ignore", false);
        preferences.putBoolean("com.ibm.cics.core.comm.truststore.same", true);
        preferences.put("com.ibm.cics.core.comm.security.protocol", "");
        IPath pluginStatePath = Activator.getDefault().getStateLocation();
        File pluginStateFile = pluginStatePath.toFile();
        File secureStorageFile = new File(pluginStateFile, "explorer_keystore.jks");
        preferences.put("javax.net.ssl.trustStore", secureStorageFile.getAbsolutePath());
        preferences.put("javax.net.ssl.keyStore", secureStorageFile.getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStore", secureStorageFile.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStore", secureStorageFile.getAbsolutePath());
        debug.exit("initializeDefaultPreferences");
    }
}

