/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.Messages;
import com.ibm.cics.core.model.TableDescriptions;
import com.ibm.cics.core.model.internal.CICSObjectListFactory;
import com.ibm.cics.core.model.internal.GenericContainer;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectListFactory;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSType;
import java.util.List;

public class CICSObjectSet<T extends ICICSObject>
implements ICICSObjectSet<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSType<T> type;
    private final GenericContainer<? super T> container;
    private FilterExpression filterExpression;

    public CICSObjectSet(ICICSType<T> type, GenericContainer<? super T> container) {
        this.type = type;
        this.container = container;
    }

    public ICICSObjectListFactory<T> asListFactory() {
        return new CICSObjectListFactory<T>(this.getDescription(), this.container.getGetter(this.type, this.filterExpression));
    }

    public List<T> get() throws CICSActionException {
        return this.asListFactory().getAll();
    }

    public void delete() throws CICSActionException {
        this.container.delete(this.type, this.filterExpression);
    }

    public String getDescription() {
        return Messages.bind((String)Messages.CICSObjectListFactory_description, (Object)TableDescriptions.getPluralTableDescription(this.type), (Object)this.container.getDescription());
    }

    public ICICSType<T> getCICSType() {
        return this.type;
    }

    public void setFilter(FilterExpression filterExpression) {
        this.filterExpression = filterExpression;
    }
}

