/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.model.AbstractResourcesModel;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CPSM;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.IModelListener;
import com.ibm.cics.core.model.ModelStatus;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import java.lang.reflect.Array;
import java.util.logging.Logger;

public class ResourcesModel
extends AbstractResourcesModel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICPSM cpsm;
    private IContext context;
    private final ICICSType<?> type;
    private ICICSObject[] resources;
    private SMConnectionResponse lastResponse;
    private ModelStatus status;
    private boolean needsReactivation;
    private static Logger logger = Logger.getLogger(ResourcesModel.class.getPackage().getName());

    protected ResourcesModel(ICPSM cpsm, IContext context, IModelListener listener, ICICSType<?> type) {
        Debug.enter((Logger)logger, (String)ResourcesModel.class.getName(), (String)"<init>", (Object[])new Object[]{cpsm, context, listener, type});
        this.type = type;
        this.cpsm = cpsm;
        this.context = context;
        this.status = ModelStatus.OK;
        if (listener != null) {
            this.addListener(listener);
        }
        Debug.exit((Logger)logger, (String)ResourcesModel.class.getName(), (String)"<init>", (Object)this);
    }

    protected ResourcesModel(ICPSM cpsm, String context, String scope, IModelListener listener, ICICSType<? extends ICICSObject> resourceType) {
        this(cpsm, (IContext)new ScopedContext(context, scope), listener, resourceType);
    }

    public ResourcesModel(ICPSM cpsm, ICICSType<? extends ICICSObject> type, IContext context) {
        this(cpsm, context, null, type);
    }

    public ResourcesModel(ResourcesModel resourcesModel, IContext context) {
        this(resourcesModel.cpsm, context, null, resourcesModel.type);
    }

    public ICPSM getCPSM() {
        return this.cpsm;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public ModelStatus getStatus() {
        return this.status;
    }

    @Override
    public synchronized void activate() {
        Debug.enter((Logger)logger, (String)ResourcesModel.class.getName(), (String)"activate", (Object)this, (Object)this.cpsm, (Object)this.lastResponse);
        if (this.cpsm != null) {
            try {
                this.lastResponse = this.cpsm.get(this.type.getResourceTableName(), this.context);
                Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"activate", (Object)this.lastResponse);
                if (this.lastResponse != null && this.resources == null) {
                    if (!this.lastResponse.getStatus().equals("OK")) {
                        this.status = ModelStatus.UNSUPPORTED;
                    } else if (this.lastResponse.getRecordTotal() > 0 && this.lastResponse.getResponse().equals("NODATA")) {
                        this.status = ModelStatus.LIMITED;
                    }
                    this.resources = this.createResources(this.lastResponse.getRecordTotal());
                    this.fireSizeChanged(this.resources.length, -1);
                }
            }
            catch (CICSSystemManagerException ex) {
                Debug.warning((Logger)logger, (String)ResourcesModel.class.getName(), (String)"activate", (Object)this, (Object)((Object)ex));
                this.fireExceptionOccured((Exception)((Object)ex));
            }
        }
        Debug.exit((Logger)logger, (String)ResourcesModel.class.getName(), (String)"activate", (Object)this.lastResponse);
    }

    @Override
    public boolean isActivated() {
        return this.lastResponse != null;
    }

    protected ICICSObject[] createResources(int length) {
        ICICSObject[] resources = (ICICSObject[])Array.newInstance(this.type.getImplementationType(), length);
        return resources;
    }

    @Override
    public synchronized void reactivate() {
        this.deactivate();
        this.resources = null;
        this.activate();
        this.needsReactivation = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void maybeFetch(int index, int count) {
        int start = -1;
        int finish = -1;
        if (this.needsReactivation) {
            this.reactivate();
        }
        if (this.isActivated()) {
            SMConnectionResponse sMConnectionResponse = this.lastResponse;
            synchronized (sMConnectionResponse) {
                if (!this.itemExists(index + count - 1)) {
                    int i = index;
                    while ((i < index + count || -1 != start && i < start + count) && i < this.resources.length) {
                        if (this.resources[i] == null) {
                            if (-1 == start) {
                                start = i;
                            }
                            finish = i;
                        }
                        ++i;
                    }
                } else {
                    int i = index + count - 1;
                    while ((i >= index || -1 != finish && i > finish - count) && i >= 0) {
                        if (this.resources[i] == null) {
                            if (-1 == finish) {
                                finish = i;
                            }
                            start = i;
                        }
                        --i;
                    }
                }
                if (-1 != start && finish >= start) {
                    this.getData(start, finish - start + 1);
                }
            }
        }
    }

    @Override
    public boolean itemExists(int index) {
        return this.resources != null && index >= 0 && index < this.resources.length && this.resources[index] != null;
    }

    private void getData(int start, int count) {
        Debug.enter((Logger)logger, (String)ResourcesModel.class.getName(), (String)"getData", (Object)this, (Object)start, (Object)count);
        try {
            this.lastResponse = this.cpsm.fetch(this.lastResponse, start + 1, count);
            Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"getData", (Object)this.lastResponse);
            int i = 0;
            while (i < this.lastResponse.getRecordCount()) {
                SMConnectionRecord record = this.lastResponse.getRecord(i);
                ICICSObject resource = this.createResource(record);
                if (i == 0) {
                    Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"getData", (Object)(start + i), (Object)record, (Object)resource);
                }
                this.resources[start + i] = resource;
                ++i;
            }
            this.fireContentsChanged(start, start + this.lastResponse.getRecordCount() - 1);
        }
        catch (ConnectionException ex) {
            Debug.warning((Logger)logger, (String)ResourcesModel.class.getName(), (String)"getData", (Object)this, (Object)((Object)ex));
            this.lastResponse = null;
            this.fireExceptionOccured((Exception)((Object)ex));
        }
        Debug.exit((Logger)logger, (String)ResourcesModel.class.getName(), (String)"getData", (Object)this.lastResponse);
    }

    protected ICICSObject createResource(SMConnectionRecord record) {
        return record == null ? null : (ICICSObject)CICSCore.create(this.cpsm, record, this.type);
    }

    @Override
    public int size() {
        if (this.resources == null) {
            return 0;
        }
        return this.resources.length;
    }

    @Override
    public ICICSObject get(int index) {
        if (this.resources == null) {
            return null;
        }
        return this.resources[index];
    }

    @Override
    public synchronized void deactivate() {
        if (this.lastResponse != null) {
            Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"deactivate", (Object)this);
            this.cpsm.discard(this.lastResponse.getStub());
            this.lastResponse = null;
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.cpsm != null) {
            Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"dispose", (Object)this);
            this.deactivate();
            ((CPSM)this.cpsm).disposeModel(this);
            this.resources = null;
            this.cpsm = null;
        }
    }

    public ICICSObject find(String name) {
        ICICSObject found = null;
        if (!this.isActivated()) {
            this.activate();
        }
        this.maybeFetch(0, this.size());
        int i = 0;
        while (found == null && i < this.size()) {
            ICICSObject object = this.get(i);
            if (object != null && object.getName().equals(name)) {
                found = object;
            }
            ++i;
        }
        return found;
    }

    @Override
    public String getResourceName() {
        return this.type.getResourceTableName();
    }

    public String toString() {
        return "ResourcesModel@" + Integer.toHexString(this.hashCode()) + "[" + this.type.getResourceTableName() + ", " + this.context + "]";
    }

    public synchronized void added(ICICSObject cicsObject) {
        Debug.enter((Logger)logger, (String)ResourcesModel.class.getName(), (String)"added", (Object)this, (Object)cicsObject);
        if (this.resources != null) {
            this.resources = this.createResources(this.resources.length + 1);
            this.needsReactivation = true;
            this.fireContentsInvalid();
        }
        Debug.exit((Logger)logger, (String)ResourcesModel.class.getName(), (String)"added");
    }

    public synchronized void updated(ICICSObject cicsObject) {
        Debug.enter((Logger)logger, (String)ResourcesModel.class.getName(), (String)"updated", (Object)this, (Object)cicsObject);
        if (this.resources != null) {
            IPrimaryKey updatedKey = (IPrimaryKey)((ICoreObject)cicsObject).getAdapter(IPrimaryKey.class);
            int i = 0;
            while (i < this.resources.length) {
                IPrimaryKey key;
                ICICSObject resource = this.resources[i];
                if (resource != null && (key = (IPrimaryKey)((ICoreObject)resource).getAdapter(IPrimaryKey.class)).equals(updatedKey)) {
                    Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"updated", (Object[])new Object[]{String.valueOf(i), key, resource, cicsObject});
                    this.resources[i] = cicsObject;
                    this.fireContentsChanged(i, i);
                    break;
                }
                ++i;
            }
        }
        Debug.exit((Logger)logger, (String)ResourcesModel.class.getName(), (String)"updated");
    }

    public synchronized void removed(ICICSObject cicsObject) {
        IPrimaryKey updatedKey = (IPrimaryKey)((ICoreObject)cicsObject).getAdapter(IPrimaryKey.class);
        this.removed(updatedKey);
    }

    public synchronized void removed(IPrimaryKey updatedKey) {
        Debug.enter((Logger)logger, (String)ResourcesModel.class.getName(), (String)"removed", (Object)this, (Object)updatedKey);
        if (this.resources == null) {
            return;
        }
        boolean found = false;
        int i = 0;
        while (i < this.resources.length && !found) {
            IPrimaryKey key;
            ICICSObject resource = this.resources[i];
            if (resource != null && (key = (IPrimaryKey)((ICoreObject)resource).getAdapter(IPrimaryKey.class)).equals(updatedKey)) {
                Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"removed", (Object[])new Object[]{String.valueOf(i), key, resource, updatedKey});
                int newLength = this.resources.length - 1;
                if (newLength > 0) {
                    this.fireContentsRemoved(resource);
                }
                ICICSObject[] newResources = this.createResources(newLength);
                System.arraycopy(this.resources, 0, newResources, 0, i);
                System.arraycopy(this.resources, i + 1, newResources, i, newLength - i);
                this.resources = newResources;
                found = true;
            }
            ++i;
        }
        if (found) {
            Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"removed", (Object)true);
            this.fireSizeChanged(this.resources.length, -1);
        } else if (this.resources.length > 0) {
            Debug.event((Logger)logger, (String)ResourcesModel.class.getName(), (String)"removed", (Object)false);
            this.resources = this.createResources(this.resources.length - 1);
            this.needsReactivation = true;
            this.fireContentsInvalid();
        }
        Debug.exit((Logger)logger, (String)ResourcesModel.class.getName(), (String)"removed");
    }

    @Override
    public boolean isDisposed() {
        return this.cpsm == null;
    }
}

