/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CorbaServerReference;
import com.ibm.cics.core.model.CorbaServerType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICorbaServer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableCorbaServer;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableCorbaServer
extends MutableCICSResource
implements IMutableCorbaServer {
    private ICorbaServer delegate;
    private MutableSMRecord record;

    public MutableCorbaServer(ICPSM cpsm, IContext context, ICorbaServer cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("EJCOSE");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public Long getSessbeantime() {
        String result = this.record.get("SESSBEANTIME");
        if (result == null) {
            return this.delegate.getSessbeantime();
        }
        return (Long)((CICSAttribute)CorbaServerType.SESSBEANTIME).get(result, this.record.getNormalizers());
    }

    public ICorbaServer.StateValue getState() {
        return this.delegate.getState();
    }

    public String getJndiprefix() {
        return this.delegate.getJndiprefix();
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public String getCertificate() {
        return this.delegate.getCertificate();
    }

    public String getShelf() {
        return this.delegate.getShelf();
    }

    public String getDjardir() {
        return this.delegate.getDjardir();
    }

    public ICorbaServer.AutopublishValue getAutopublish() {
        String result = this.record.get("AUTOPUBLISH");
        if (result == null) {
            return this.delegate.getAutopublish();
        }
        return (ICorbaServer.AutopublishValue)((CICSAttribute)CorbaServerType.AUTOPUBLISH).get(result, this.record.getNormalizers());
    }

    public String getUnauth() {
        return this.delegate.getUnauth();
    }

    public String getClientcert() {
        return this.delegate.getClientcert();
    }

    public String getSslunauth() {
        return this.delegate.getSslunauth();
    }

    public ICorbaServer.StatusValue getStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (ICorbaServer.StatusValue)((CICSAttribute)CorbaServerType.STATUS).get(result, this.record.getNormalizers());
    }

    public Long getObjactivates() {
        return this.delegate.getObjactivates();
    }

    public Long getObjstores() {
        return this.delegate.getObjstores();
    }

    public Long getFailactivate() {
        return this.delegate.getFailactivate();
    }

    public String getAsserted() {
        return this.delegate.getAsserted();
    }

    public ICorbaServer.OutprivacyValue getOutprivacy() {
        return this.delegate.getOutprivacy();
    }

    public String getCiphers() {
        return this.delegate.getCiphers();
    }

    public Long getNumciphers() {
        return this.delegate.getNumciphers();
    }

    public ICorbaServer.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public ICorbaServer.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getIpresolved() {
        return this.delegate.getIpresolved();
    }

    public ICorbaServer.IpfamilyValue getIpfamily() {
        return this.delegate.getIpfamily();
    }

    public ICorbaServer.HostTypeValue getHostType() {
        return this.delegate.getHostType();
    }

    public void setSessbeantime(Long _sessbeantime) {
        if (_sessbeantime.equals(this.delegate.getSessbeantime())) {
            this.record.set("SESSBEANTIME", null);
        } else {
            CorbaServerType.SESSBEANTIME.validate((Object)_sessbeantime);
            String connectionSpecificExternalValue = ((CICSAttribute)CorbaServerType.SESSBEANTIME).set(_sessbeantime, this.record.getNormalizers());
            this.record.set("SESSBEANTIME", connectionSpecificExternalValue);
        }
    }

    public void setAutopublish(ICorbaServer.AutopublishValue _autopublish) {
        if (_autopublish.equals((Object)this.delegate.getAutopublish())) {
            this.record.set("AUTOPUBLISH", null);
        } else {
            CorbaServerType.AUTOPUBLISH.validate((Object)_autopublish);
            String connectionSpecificExternalValue = ((CICSAttribute)CorbaServerType.AUTOPUBLISH).set(_autopublish, this.record.getNormalizers());
            this.record.set("AUTOPUBLISH", connectionSpecificExternalValue);
        }
    }

    public void setStatus(ICorbaServer.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            CorbaServerType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)CorbaServerType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == CorbaServerType.NAME) {
            return (V)this.getName();
        }
        if (attribute == CorbaServerType.SESSBEANTIME) {
            return (V)this.getSessbeantime();
        }
        if (attribute == CorbaServerType.STATE) {
            return (V)this.getState();
        }
        if (attribute == CorbaServerType.JNDIPREFIX) {
            return (V)this.getJndiprefix();
        }
        if (attribute == CorbaServerType.HOST) {
            return (V)this.getHost();
        }
        if (attribute == CorbaServerType.CERTIFICATE) {
            return (V)this.getCertificate();
        }
        if (attribute == CorbaServerType.SHELF) {
            return (V)this.getShelf();
        }
        if (attribute == CorbaServerType.DJARDIR) {
            return (V)this.getDjardir();
        }
        if (attribute == CorbaServerType.AUTOPUBLISH) {
            return (V)this.getAutopublish();
        }
        if (attribute == CorbaServerType.UNAUTH) {
            return (V)this.getUnauth();
        }
        if (attribute == CorbaServerType.CLIENTCERT) {
            return (V)this.getClientcert();
        }
        if (attribute == CorbaServerType.SSLUNAUTH) {
            return (V)this.getSslunauth();
        }
        if (attribute == CorbaServerType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == CorbaServerType.OBJACTIVATES) {
            return (V)this.getObjactivates();
        }
        if (attribute == CorbaServerType.OBJSTORES) {
            return (V)this.getObjstores();
        }
        if (attribute == CorbaServerType.FAILACTIVATE) {
            return (V)this.getFailactivate();
        }
        if (attribute == CorbaServerType.ASSERTED) {
            return (V)this.getAsserted();
        }
        if (attribute == CorbaServerType.OUTPRIVACY) {
            return (V)this.getOutprivacy();
        }
        if (attribute == CorbaServerType.CIPHERS) {
            return (V)this.getCiphers();
        }
        if (attribute == CorbaServerType.NUMCIPHERS) {
            return (V)this.getNumciphers();
        }
        if (attribute == CorbaServerType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == CorbaServerType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == CorbaServerType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == CorbaServerType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == CorbaServerType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == CorbaServerType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == CorbaServerType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == CorbaServerType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == CorbaServerType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == CorbaServerType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == CorbaServerType.IPRESOLVED) {
            return (V)this.getIpresolved();
        }
        if (attribute == CorbaServerType.IPFAMILY) {
            return (V)this.getIpfamily();
        }
        if (attribute == CorbaServerType.HOST_TYPE) {
            return (V)this.getHostType();
        }
        return super.getAttributeValue(attribute);
    }

    public CorbaServerType getObjectType() {
        return CorbaServerType.getInstance();
    }

    @Override
    public CorbaServerReference getCICSObjectReference() {
        return new CorbaServerReference(this.getCICSContainer(), this.getName());
    }
}

