/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.meta.IAttribute;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class CopyCICSObjectHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final LocalSelectionTransfer SUPPORTED_TRANSFER = LocalSelectionTransfer.getTransfer();

    public static void setClipboardContent(String typeName, IStructuredSelection selection, String[][] tableData) {
        String tsvRepresentation = CopyCICSObjectHelper.createSeparatedValuesString(typeName, tableData, '\t');
        File csvRepresentation = CopyCICSObjectHelper.createCsvFile(typeName, tableData);
        CopyCICSObjectHelper.setClipboardContent(selection, tsvRepresentation, csvRepresentation);
    }

    public static void setClipboardContent(IStructuredSelection selection, String tsvRepresentation, File csvRepresentation) {
        SUPPORTED_TRANSFER.setSelection((ISelection)selection);
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.setContents(new Object[]{selection, tsvRepresentation.length() > 0 ? tsvRepresentation : null, new String[]{csvRepresentation.getAbsolutePath()}}, new Transfer[]{SUPPORTED_TRANSFER, TextTransfer.getInstance(), FileTransfer.getInstance()});
        clipboard.dispose();
    }

    public static <T> List<T> getClipboardSelectionAsList(Class<T> selectionType) {
        TransferData[] transferDataArray;
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        TransferData[] transferDataArray2 = transferDataArray = clipboard.getAvailableTypes();
        int n = transferDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData transferData = transferDataArray2[n2];
            if (SUPPORTED_TRANSFER.isSupportedType(transferData)) {
                ISelection definitionSelection = SUPPORTED_TRANSFER.getSelection();
                clipboard.getContents((Transfer)SUPPORTED_TRANSFER);
                if (!definitionSelection.isEmpty() && definitionSelection instanceof IStructuredSelection) {
                    for (Object o : (IStructuredSelection)definitionSelection) {
                        if (selectionType.isAssignableFrom(o.getClass())) continue;
                        return null;
                    }
                    return ((IStructuredSelection)definitionSelection).toList();
                }
            }
            ++n2;
        }
        return null;
    }

    public static ISelection getClipboardSelection() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        TransferData[] transferDataArray = clipboard.getAvailableTypes();
        clipboard.dispose();
        TransferData[] transferDataArray2 = transferDataArray;
        int n = transferDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData transferData = transferDataArray2[n2];
            if (SUPPORTED_TRANSFER.isSupportedType(transferData)) {
                ISelection definitionSelection = SUPPORTED_TRANSFER.getSelection();
                return definitionSelection;
            }
            ++n2;
        }
        return null;
    }

    private static File createCsvFile(String typeName, String[][] data) {
        StringBuffer csvRepresentationBuffer = new StringBuffer();
        csvRepresentationBuffer.append(CopyCICSObjectHelper.createSeparatedValuesString(typeName, data, ','));
        File file = null;
        FileOutputStream fos = null;
        try {
            try {
                file = File.createTempFile(typeName, ".csv");
                fos = new FileOutputStream(file);
                fos.write(csvRepresentationBuffer.toString().getBytes());
                fos.close();
            }
            catch (IOException e) {
                UIPlugin.logWarning("Couldn't create or write to temporary file " + file.getAbsolutePath(), e);
                if (file != null) {
                    file.deleteOnExit();
                }
            }
        }
        finally {
            if (file != null) {
                file.deleteOnExit();
            }
        }
        return file;
    }

    private static String createSeparatedValuesString(String typeName, String[][] data, char separator) {
        StringBuffer stringRepresentation = new StringBuffer();
        if (data.length > 0 && data[0].length > 0) {
            stringRepresentation.append("# ");
            stringRepresentation.append(typeName);
            stringRepresentation.append("\n");
            stringRepresentation.append(CopyCICSObjectHelper.convertToSeparatedValues(data[0], separator));
            int i = 1;
            while (i < data.length) {
                stringRepresentation.append("\n");
                stringRepresentation.append(CopyCICSObjectHelper.convertToSeparatedValues(data[i], separator));
                ++i;
            }
        }
        return stringRepresentation.toString();
    }

    static String convertToSeparatedValues(String[] strings, char separator) {
        StringBuffer line = new StringBuffer();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            line.append("\"");
            line.append(string.replace("\"", "\"\""));
            line.append("\"");
            line.append(separator);
            ++n2;
        }
        return line.length() > 0 ? line.substring(0, line.length() - 1) : line.toString();
    }

    static List<String> getAttributeValues(ICICSObject cicsObject, Collection<IPropertyDescriptor> columns) {
        ArrayList<String> values = new ArrayList<String>();
        IPropertySourceProvider propertySourceProvider = (IPropertySourceProvider)Platform.getAdapterManager().getAdapter((Object)cicsObject, IPropertySourceProvider.class);
        if (propertySourceProvider != null) {
            IPropertySource propSource = propertySourceProvider.getPropertySource((Object)cicsObject);
            for (IPropertyDescriptor propDescriptor : columns) {
                ILabelProvider labelProvider = propDescriptor.getLabelProvider();
                Object id = propDescriptor.getId();
                if (id instanceof IAttribute) {
                    IAttribute idAttrib = (IAttribute)id;
                    id = idAttrib.getPropertyId();
                }
                Object propValue = propSource.getPropertyValue(id);
                values.add(labelProvider.getText(propValue));
            }
        }
        return values;
    }

    static List<String> getAttributeNames(ICICSObject cicsObject, Collection<IPropertyDescriptor> columns) {
        ArrayList<String> values = new ArrayList<String>();
        for (IPropertyDescriptor propDescriptor : columns) {
            values.add(propDescriptor.getDisplayName());
        }
        return values;
    }
}

