/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.model.ICICSObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class DeferredTreeExpansionRestorer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(DeferredTreeExpansionRestorer.class);
    private final Queue<TreePath> paths = new PriorityBlockingQueue<TreePath>(11, new Comparator<TreePath>(){

        @Override
        public int compare(TreePath o1, TreePath o2) {
            return Integer.valueOf(o1.getSegmentCount()).compareTo(o2.getSegmentCount());
        }
    });
    private final DeferredTreeContentManager deferredTreeContentManager;
    private final TreeViewer viewer;
    private final IJobChangeListener listener;

    public DeferredTreeExpansionRestorer(TreeViewer viewer, DeferredTreeContentManager deferredTreeContentManager) {
        DEBUG.enter("DeferredTreeExpansionRestorer", (Object)viewer, (Object)deferredTreeContentManager);
        this.viewer = viewer;
        this.deferredTreeContentManager = deferredTreeContentManager;
        viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DeferredTreeExpansionRestorer.this.dispose();
            }
        });
        this.listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DEBUG.enter("JobChangeAdapter.done");
                DeferredTreeExpansionRestorer.this.processPaths();
                DEBUG.exit("JobChangeAdapter.done");
            }
        };
        deferredTreeContentManager.addUpdateCompleteListener(this.listener);
        DEBUG.exit("DeferredTreeExpansionRestorer");
    }

    public void addExpandedTreeElements(TreePath[] expandedTreePaths) {
        HashSet<TreePath> allPaths = new HashSet<TreePath>(Arrays.asList(expandedTreePaths));
        Iterator<TreePath> pathIterator = allPaths.iterator();
        while (pathIterator.hasNext()) {
            TreePath path = (TreePath)pathIterator.next();
            this.checkPathIsVisible(path, pathIterator, allPaths);
        }
        this.paths.addAll(allPaths);
    }

    private void checkPathIsVisible(TreePath path, Iterator<TreePath> pathIterator, Set<TreePath> allPaths) {
        TreePath parentPath = path.getParentPath();
        if (!TreePath.EMPTY.equals((Object)parentPath)) {
            if (!allPaths.contains(parentPath)) {
                pathIterator.remove();
            } else {
                this.checkPathIsVisible(parentPath, pathIterator, allPaths);
            }
        }
    }

    private synchronized void processPaths() {
        TreePath path;
        DEBUG.enter("processPaths");
        HashSet<TreePath> pathsToReAdd = new HashSet<TreePath>();
        while ((path = this.paths.poll()) != null) {
            DEBUG.event("processPaths", "Processing path: " + this.printPath(path));
            if (path == null) continue;
            TreePath expansionResult = this.expandFirstCollapsedNode(path);
            if (expansionResult != null) {
                pathsToReAdd.add(path);
                pathsToReAdd.addAll(this.removeSubPaths(expansionResult));
                continue;
            }
            DEBUG.event("processPaths", "Didn't find the need to expand " + this.printPath(path));
        }
        this.paths.addAll(pathsToReAdd);
        DEBUG.exit("processPaths");
    }

    private Set<TreePath> removeSubPaths(TreePath path) {
        HashSet<TreePath> removedPaths = new HashSet<TreePath>();
        Iterator it = this.paths.iterator();
        while (it.hasNext()) {
            TreePath otherPath = (TreePath)it.next();
            if (!otherPath.startsWith(path, null)) continue;
            DEBUG.event("removeSubPaths", "Removing sub-path " + this.printPath(otherPath) + " for later evaluation");
            it.remove();
            removedPaths.add(otherPath);
        }
        return removedPaths;
    }

    private TreePath expandFirstCollapsedNode(TreePath path) {
        DEBUG.enter("expandFirstCollapsedNode", (Object)this.printPath(path));
        if (TreePath.EMPTY.equals((Object)path)) {
            DEBUG.exit("expandFirstCollapsedNode", null);
            return null;
        }
        TreePath parentResult = this.expandFirstCollapsedNode(path.getParentPath());
        if (parentResult != null) {
            DEBUG.exit("expandFirstCollapsedNode", (Object)this.printPath(parentResult));
            return parentResult;
        }
        if (this.pathExistsInTree(path) && this.viewer.isExpandable((Object)path) && !this.viewer.getExpandedState((Object)path)) {
            DEBUG.event("expandFirstCollapsedNode", "Decided to expand: " + this.printPath(path));
            this.viewer.expandToLevel((Object)path, 1);
            DEBUG.exit("expandFirstCollapsedNode", (Object)this.printPath(path));
            return path;
        }
        DEBUG.exit("expandFirstCollapsedNode", null);
        return null;
    }

    private boolean pathExistsInTree(TreePath target) {
        return this.canContainPath((Widget)this.viewer.getTree(), 0, target);
    }

    private boolean canContainPath(Widget w, int startIndex, TreePath target) {
        TreeItem[] children = null;
        if (w instanceof TreeItem) {
            children = ((TreeItem)w).getItems();
        } else if (w instanceof Tree) {
            children = ((Tree)w).getItems();
        }
        if (children != null) {
            TreeItem[] treeItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                if (child.getData() instanceof PendingUpdateAdapter) {
                    return true;
                }
                Object modelElement = child.getData();
                if (this.isTargetElement(target.getSegment(startIndex), modelElement)) {
                    if (startIndex < target.getSegmentCount() - 1) {
                        return this.canContainPath((Widget)child, startIndex + 1, target);
                    }
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isTargetElement(Object targetElement, Object modelElement) {
        IElementComparer comparer = this.viewer.getComparer();
        return comparer.equals(targetElement, modelElement);
    }

    public void dispose() {
        DEBUG.enter("dispose");
        if (this.listener != null) {
            this.deferredTreeContentManager.removeUpdateCompleteListener(this.listener);
        }
        DEBUG.exit("dispose");
    }

    private String printPath(TreePath path) {
        if (path == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder(this.shortenModelNames(path.getFirstSegment()));
        int i = 1;
        while (i < path.getSegmentCount()) {
            builder.append('/');
            builder.append(this.shortenModelNames(path.getSegment(i)));
            ++i;
        }
        return builder.toString();
    }

    private String shortenModelNames(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof ICICSObject) {
            return String.valueOf(object.getClass().getSimpleName()) + "[" + ((ICICSObject)object).getName() + "]";
        }
        return object.toString();
    }
}

