/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.adapters.IDecoratableWLMAdapter;
import com.ibm.cics.core.ui.adapters.WLMAbstractRuleRelatedAdapter;
import com.ibm.cics.core.ui.adapters.WLMRuleAdapter;
import com.ibm.cics.core.ui.adapters.WLMRuleTargetAdapter;
import com.ibm.cics.model.IActiveWorkloadDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class WLMRuleTargetsAdapter
extends WLMAbstractRuleRelatedAdapter
implements IAdaptableTreeNode,
IAdaptable,
IDeferredWorkbenchAdapter,
IDecoratableWLMAdapter,
IContextProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final WLMRuleAdapter ruleAdapter;
    private Object[] children;

    public WLMRuleTargetsAdapter(WLMRuleAdapter ruleAdapter, IWorkload wlmActiveWorkload) {
        super(wlmActiveWorkload);
        this.ruleAdapter = ruleAdapter;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        collector.add(this.getChildren(object), monitor);
    }

    public Object[] getChildren(Object o) {
        this.cacheChildrenIfNotKnown();
        ArrayList<WLMRuleTargetAdapter> targetsAsAdapters = new ArrayList<WLMRuleTargetAdapter>(this.children.length);
        Object[] objectArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IWorkloadTarget) {
                targetsAsAdapters.add(new WLMRuleTargetAdapter((IWorkloadTarget)object, this.activeWorkload, this));
            }
            ++n2;
        }
        return targetsAsAdapters.toArray();
    }

    @Override
    public String getDecoration() {
        this.cacheChildrenIfNotKnown();
        return "" + this.children.length;
    }

    private synchronized void cacheChildrenIfNotKnown() {
        if (this.children == null) {
            this.children = this.getTargetsForScope(this.ruleAdapter.getAdaptedRule().getTargetScope());
        }
    }

    public ICPSM getCPSM() {
        return ((ICoreObject)this.ruleAdapter.getAdaptedRule()).getCPSM();
    }

    public String getLabel(Object o) {
        return Messages.getString("WorkbenchAdapterFactory.targets");
    }

    public ICICSType getObjectType() {
        return this.ruleAdapter.getAdaptedRule().getObjectType();
    }

    public Object getParent(Object o) {
        return this.ruleAdapter;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ICICSObject getRelatedRule() {
        return this.ruleAdapter.getAdaptedRule();
    }

    public ICICSObject getEditorInputObject() {
        return this.getRelatedRule();
    }

    public Object getAdapter(Class adapterType) {
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return null;
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        return adapter;
    }

    public IContext getIContext() {
        return new ScopedContext((IContext)WLMRuleTargetsAdapter.getWorkloadBaseContext(this.activeWorkload), ((IActiveWorkloadDefinition)this.getRelatedRule()).getTargetScope());
    }
}

