/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.views.PreferenceInvocationHandlerData;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceInvocationHandler
implements InvocationHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PreferenceInvocationHandler.class.getPackage().getName());
    private PreferenceInvocationHandlerData data = new PreferenceInvocationHandlerData();

    public PreferenceInvocationHandler(String qualifier, IPreferenceStore defaultPreferenceStore) {
        if (Debug.DEBUG_PREFERENCES) {
            Debug.enter((Logger)logger, (String)PreferenceInvocationHandler.class.getName(), (String)"PreferenceInvocationHandler", (Object)("qualifier=" + qualifier));
        }
        this.data.store = new ScopedPreferenceStore(InstanceScope.INSTANCE, qualifier);
        this.data.defaultStore = defaultPreferenceStore;
        if (Debug.DEBUG_PREFERENCES) {
            Debug.exit((Logger)logger, (String)PreferenceInvocationHandler.class.getName(), (String)"PreferenceInvocationHandler", (Object)(this.data.store + ", " + this.data.defaultStore));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        if (Debug.DEBUG_PREFERENCES) {
            Debug.enter((Logger)logger, (String)PreferenceInvocationHandler.class.getName(), (String)"invoke", (Object)("method=" + method + ", object=" + Arrays.asList(args)));
        }
        if (method.getName().equals("putValue")) {
            String newValue = (String)args[1];
            String name = (String)args[0];
            String defaultValue = this.data.defaultStore.getDefaultString(name);
            if (!newValue.equals(defaultValue)) {
                object = method.invoke((Object)this.data.store, args);
                if (Debug.DEBUG_PREFERENCES) {
                    Debug.event((Logger)logger, (String)PreferenceInvocationHandler.class.getName(), (String)"invoke", (Object)("name=" + name + ", newValue=" + newValue + ", defaultValue=" + defaultValue + ", object=" + object));
                }
            } else {
                this.data.store.setToDefault(name);
                object = null;
                if (Debug.DEBUG_PREFERENCES) {
                    Debug.event((Logger)logger, (String)PreferenceInvocationHandler.class.getName(), (String)"invoke", (Object)("name=" + name + ", newValue=" + newValue + ", defaultValue=" + defaultValue));
                }
            }
            this.data.store.save();
        } else {
            object = method.invoke((Object)this.data.store, args);
            if (method.getName().startsWith("get") && this.isDefault(method, object)) {
                if (Debug.DEBUG_PREFERENCES) {
                    Debug.event((Logger)logger, (String)PreferenceInvocationHandler.class.getName(), (String)"invoke", (Object)("object=" + object));
                }
                object = method.invoke((Object)this.data.defaultStore, args);
            }
        }
        if (Debug.DEBUG_PREFERENCES) {
            Debug.exit((Logger)logger, (String)PreferenceInvocationHandler.class.getName(), (String)"invoke", (Object)object);
        }
        return object;
    }

    private boolean isDefault(Method method, Object object) {
        boolean isDefault = object.equals("");
        return isDefault;
    }
}

