/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.PlatformDefinitionType;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.model.UnsupportedTypeException;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.swt.graphics.Image;

public class ApplicationDefinitionDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(ApplicationDefinitionDeferredWorkbenchAdapter.class);
    private final IApplicationDefinition applicationDefinition;

    public ApplicationDefinitionDeferredWorkbenchAdapter(CloudInput aCloudInput, IApplicationDefinition applicationDefinition) {
        super(aCloudInput);
        this.applicationDefinition = applicationDefinition;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public Object[] getDataChildren(Object o) {
        DEBUG.enter("getDataChildren", (Object)this, o);
        Object[] children = this.getPlatform();
        DEBUG.exit("getDataChildren", (Object)children);
        return children;
    }

    private Object[] getPlatform() {
        ArrayList<ICICSObject> result = new ArrayList<ICICSObject>(1);
        try {
            FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), PlatformType.PLATFORM_DEFINITION_NAME, this.applicationDefinition.getPlatformDefinition());
            ICICSObject[] platform = this.getCICSObjects((ICICSType<?>)PlatformType.getInstance(), (IContext)filteredContext);
            if (platform.length > 0) {
                result.add(platform[0]);
            } else {
                filteredContext = this.getFilteredContextForAttribute(this.getContext(), PlatformDefinitionType.NAME, this.applicationDefinition.getPlatformDefinition());
                platform = this.getCICSObjects((ICICSType<?>)PlatformDefinitionType.getInstance(), (IContext)filteredContext);
                if (platform.length > 0) {
                    result.add(platform[0]);
                }
            }
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() instanceof UnsupportedTypeException) {
                DEBUG.event("getPlatform, type " + ((UnsupportedTypeException)e.getCause()).getResourceTableName() + " unsupported", (Object)e);
            }
            DEBUG.error("getPlatform", (Throwable)e);
        }
        return result.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = ImageDescriptor.createFromImage((Image)UIPlugin.getTableImage(ApplicationDefinitionType.getInstance().getResourceTableName()));
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    public String getLabel(Object o) {
        return this.applicationDefinition.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    @Override
    protected String getFetchingName() {
        return CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_operations;
    }
}

