/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public abstract class MultiSourcePropertySourceProvider
implements IPropertySourceProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Collection<?> propertySourceIds;
    private IPropertyDescriptor[] propertyDescriptors;

    protected MultiSourcePropertySourceProvider(Collection<?> propertySourceIds) {
        this.propertySourceIds = propertySourceIds;
    }

    public abstract Map<Object, IPropertyDescriptor> getPropertyDescriptorMap();

    private IPropertyDescriptor[] getPropertyDescriptorsArray() {
        if (this.propertyDescriptors == null) {
            Map<Object, IPropertyDescriptor> propertyDescriptorMap = this.getPropertyDescriptorMap();
            this.propertyDescriptors = propertyDescriptorMap.values().toArray(new IPropertyDescriptor[propertyDescriptorMap.size()]);
        }
        return this.propertyDescriptors;
    }

    public IPropertySource getPropertySource(Object object) {
        IdentityHashMap<Object, IPropertySource> propertySourceIdsToPropertySources = new IdentityHashMap<Object, IPropertySource>();
        for (Object propertySourceId : this.propertySourceIds) {
            IPropertySource propertySource = this.createPropertySource(propertySourceId, object);
            if (propertySource == null) continue;
            propertySourceIdsToPropertySources.put(propertySourceId, propertySource);
        }
        return new MultiSourcePropertySource(propertySourceIdsToPropertySources);
    }

    protected abstract IPropertySource createPropertySource(Object var1, Object var2);

    protected abstract Object getPropertySourceId(Object var1);

    private class MultiSourcePropertySource
    implements IPropertySource {
        private IdentityHashMap<Object, IPropertySource> propertySourceIdsToPropertySource;

        public MultiSourcePropertySource(IdentityHashMap<Object, IPropertySource> propertySourceIdsToPropertySources) {
            this.propertySourceIdsToPropertySource = propertySourceIdsToPropertySources;
        }

        public Object getEditableValue() {
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return MultiSourcePropertySourceProvider.this.getPropertyDescriptorsArray();
        }

        public Object getPropertyValue(Object id) {
            IPropertySource iPropertySource;
            Object propertySourceId = MultiSourcePropertySourceProvider.this.getPropertySourceId(id);
            if (propertySourceId != null && (iPropertySource = this.propertySourceIdsToPropertySource.get(propertySourceId)) != null) {
                return iPropertySource.getPropertyValue(id);
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

