/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties.internal;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSEnum;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Composite;

public class EnumCellEditor
extends ComboBoxViewerCellEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<ICICSEnum> myValues;
    private static Logger logger = Logger.getLogger("com.ibm.cics.core.ui");
    private final boolean allowUnspecified;
    private ICICSAttribute<ICICSEnum> enumAttribute;

    public EnumCellEditor(Composite parent, List<ICICSEnum> myValues, boolean allowUnspecified, ICICSAttribute<ICICSEnum> enumAttribute) {
        super(parent);
        this.allowUnspecified = allowUnspecified;
        this.myValues = myValues;
        this.enumAttribute = enumAttribute;
        this.populateCombo(myValues);
    }

    public int getStyle() {
        return 12;
    }

    protected void doSetValue(Object value) {
        int i = 0;
        while (i < this.myValues.size()) {
            if (value == this.myValues.get(i)) {
                super.doSetValue(this.getViewer().getElementAt(i));
                return;
            }
            if (this.allowUnspecified && value == null && ((Enum)this.myValues.get(i)).name().equals("_UNSPECIFIED")) {
                super.doSetValue(this.getViewer().getElementAt(i));
                return;
            }
            ++i;
        }
        if (Debug.DEBUG_PROPERTIES) {
            logger.logp(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "doSetValue", "Supplied value was not in list of availble items", value);
        }
        super.doSetValue(null);
    }

    protected Object doGetValue() {
        Integer value = super.getViewer().getCCombo().getSelectionIndex();
        if (value < 0) {
            return null;
        }
        if (value >= this.myValues.size()) {
            logger.logp(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "doGetValue", "combo selection index did not correspond to a possible value");
            return null;
        }
        ICICSEnum returnValue = this.myValues.get(value);
        if (this.allowUnspecified && ((Enum)returnValue).name().equals("_UNSPECIFIED")) {
            return null;
        }
        return returnValue;
    }

    public Object primGetValue() {
        return this.doGetValue();
    }

    public static EnumCellEditor newInstance(Composite parent, ICICSAttribute<ICICSEnum> enumAttribute) {
        return EnumCellEditor.newInstance(parent, enumAttribute, false);
    }

    public static EnumCellEditor newInstance(Composite parent, ICICSAttribute<ICICSEnum> enumAttribute, boolean allowUnspecified) {
        ICICSEnum[] constants = (ICICSEnum[])enumAttribute.getType().getEnumConstants();
        LinkedList<ICICSEnum> items = new LinkedList<ICICSEnum>();
        ICICSEnum[] iCICSEnumArray = constants;
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSEnum constant = iCICSEnumArray[n2];
            ICICSEnum cicsEnumConstant = constant;
            if ((!cicsEnumConstant.isSpecialValue() || allowUnspecified && ((Enum)cicsEnumConstant).name().equals("_UNSPECIFIED")) && cicsEnumConstant.getDirection() != ICICSEnum.Direction.OUT) {
                items.add(cicsEnumConstant);
            }
            ++n2;
        }
        return new EnumCellEditor(parent, items, allowUnspecified, enumAttribute);
    }

    protected boolean isCorrect(Object value) {
        if (this.allowUnspecified && value == null) {
            return true;
        }
        return super.isCorrect(value);
    }

    private void populateCombo(List<ICICSEnum> myValues) {
        ComboViewer comboViewer = this.getViewer();
        for (ICICSEnum key : myValues) {
            comboViewer.add((Object)this.enumAttribute.internalToExternal((Object)key));
        }
        this.setValueValid(true);
        super.doSetValue(comboViewer.getElementAt(0));
    }
}

