/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractTreeContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AbstractTreeViewer treeViewer;
    private Map<Object, Set<Object>> childrenMap;
    private Object input;

    protected synchronized void elementsChanged(Object[] updatedElements) {
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object updatedElement = objectArray[n2];
            this.add(updatedElement, true);
            ++n2;
        }
    }

    public void clear() {
        this.inputChanged((Viewer)this.treeViewer, this.input, this.input);
        this.treeViewer.refresh();
    }

    protected void add(Object child, boolean refresh) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.add(parent, child)) {
                if (refresh) {
                    this.treeViewer.add(parent, child);
                    this.treeViewer.refresh(child);
                }
                child = parent;
                parent = this.getParent(child);
                continue;
            }
            if (refresh) {
                this.treeViewer.refresh(parent);
            }
            return;
        }
        if (this.add(this.input, child) && refresh) {
            this.treeViewer.add(this.input, child);
        }
    }

    protected boolean add(Object parent, Object child) {
        Set<Object> children = this.childrenMap.get(parent);
        if (children == null) {
            children = new LinkedHashSet<Object>();
            this.childrenMap.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Object child, boolean refresh) {
        Object[] objectArray = this.getChildren(child);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object grandchild = objectArray[n2];
            this.remove(grandchild, false);
            ++n2;
        }
        Object parent = this.getParent(child);
        if (parent != null && this.remove(parent, child) && refresh) {
            this.treeViewer.refresh(parent);
        }
    }

    protected boolean remove(Object parent, Object child) {
        Set<Object> children = this.childrenMap.get(parent);
        if (children != null) {
            boolean removed = children.remove(child);
            if (children.isEmpty()) {
                this.childrenMap.remove(child);
            }
            return removed;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.childrenMap.get(parentElement);
        return children == null ? new Object[]{} : children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    protected void initialize(Set<?> results) {
        this.childrenMap = new LinkedHashMap<Object, Set<Object>>();
        for (Object result : results) {
            this.add(result, false);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = (AbstractTreeViewer)viewer;
        this.childrenMap = new LinkedHashMap<Object, Set<Object>>();
        this.input = newInput;
    }
}

