/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.CICSTypePropertySource;
import com.ibm.cics.core.ui.adapters.CICSTypePropertySourceAdapterFactory;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.ResourcesLabelProvider;
import com.ibm.cics.core.ui.views.ResourcesViewColumnDialog;
import com.ibm.cics.core.ui.views.Scheduler;
import com.ibm.cics.core.ui.views.TableManager;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PreferenceService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long COLUMN_SAVE_DELAY = 1000L;
    private static final Debug debug = new Debug(PreferenceService.class);
    private final Scheduler saveColumnScheduler = new Scheduler(new Runnable(){

        @Override
        public void run() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    debug.enter("Scheduler.saveColumns", (Object)this, (Object)PreferenceService.this.saveEnabled);
                    StringBuffer namesPrefValue = new StringBuffer();
                    StringBuilder widthsPrefValue = new StringBuilder();
                    List<TableManager.ColumnData> columns = PreferenceService.this.tableManager.getColumnData();
                    if (columns != null) {
                        for (TableManager.ColumnData column : columns) {
                            namesPrefValue.append(((ICICSAttribute)column.id).getPropertyId());
                            if (column.width != -1) {
                                widthsPrefValue.append(column.width);
                            }
                            namesPrefValue.append(",");
                            widthsPrefValue.append(",");
                        }
                        if (!columns.isEmpty()) {
                            namesPrefValue.deleteCharAt(namesPrefValue.length() - 1);
                            widthsPrefValue.deleteCharAt(widthsPrefValue.length() - 1);
                        }
                        String columnNamesPrefName = String.valueOf(PreferenceService.this.propertySource.getType().getResourceTableName()) + ".columnNames";
                        String columnWidthsPrefName = String.valueOf(PreferenceService.this.propertySource.getType().getResourceTableName()) + ".columnWidths";
                        debug.event("Scheduler.saveColumns()", (Object)namesPrefValue, (Object)widthsPrefValue);
                        PreferenceService.this.preferenceStore.putValue(columnNamesPrefName, namesPrefValue.toString());
                        PreferenceService.this.preferenceStore.putValue(columnWidthsPrefName, widthsPrefValue.toString());
                    }
                    debug.exit("Scheduler.saveColumns");
                }
            });
        }
    }, 1000L);
    private boolean saveEnabled;
    private final TableManager tableManager;
    private final IDefaultColumnsProvider defaultColumnsProvider;
    private IPreferenceStore preferenceStore;
    private CICSTypePropertySource propertySource;
    private final CICSTypePropertySourceAdapterFactory propertySourceFactory = new CICSTypePropertySourceAdapterFactory();

    public PreferenceService(TableManager tableManager, boolean saveEnabled, IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider) {
        this.tableManager = tableManager;
        this.propertySource = (CICSTypePropertySource)this.propertySourceFactory.getAdapter(elementTypeService.getElementType(), CICSTypePropertySource.class);
        this.defaultColumnsProvider = defaultColumnsProvider;
        this.saveEnabled = saveEnabled;
        elementTypeService.addElementTypeServiceListener(new IElementTypeService.ElementTypeServiceListener(){

            public void event(final IElementTypeService.Event event) {
                PreferenceService.this.withSuppressedSave(new Runnable(){

                    @Override
                    public void run() {
                        if (event instanceof IElementTypeService.ElementTypeChangedEvent) {
                            PreferenceService.this.propertySource = (CICSTypePropertySource)PreferenceService.this.propertySourceFactory.getAdapter(((IElementTypeService.ElementTypeChangedEvent)event).getNewType(), CICSTypePropertySource.class);
                            PreferenceService.this.tableManager.setColumnData(PreferenceService.this.refresh());
                        }
                    }
                });
            }
        });
        tableManager.addListener(new TableManager.Listener(){

            public void event(TableManager.Event event) {
                if (event instanceof TableManager.ColumnEvent) {
                    if (event instanceof TableManager.ColumnAddedEvent) {
                        TableViewerColumn tableViewerColumn = ((TableManager.ColumnAddedEvent)event).getColumn();
                        TableColumn tableColumn = tableViewerColumn.getColumn();
                        IAttributePropertyDescriptor descriptor = PreferenceService.this.propertySource.getPropertyDescriptor(((ICICSAttribute)((TableManager.ColumnAddedEvent)event).getColumnId()).getPropertyId());
                        tableColumn.setData(IPropertyDescriptor.class.getName(), (Object)descriptor);
                        tableColumn.setText(descriptor.getDisplayName());
                        tableColumn.setToolTipText(descriptor.getDescription());
                        ResourcesLabelProvider labelProvider = new ResourcesLabelProvider((CICSObjectPropertyDescriptor)descriptor);
                        tableViewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
                    }
                    PreferenceService.this.scheduleSaveColumns();
                } else if (event instanceof TableManager.TableDisposedEvent) {
                    PreferenceService.this.saveColumnScheduler.force();
                }
            }
        });
    }

    public void setPreferenceStore(final IPreferenceStore store) {
        this.withSuppressedSave(new Runnable(){

            @Override
            public void run() {
                PreferenceService.this.preferenceStore = store;
                PreferenceService.this.tableManager.setColumnData(PreferenceService.this.refresh());
            }
        });
    }

    private List<TableManager.ColumnData> refresh() {
        debug.enter("refresh");
        Map<ICICSAttribute<?>, Integer> initialColumnData = this.getSavedColumnData(this.propertySource.getType());
        List<TableManager.ColumnData> columnData = this.convertColumnData(initialColumnData);
        if (columnData.size() == 0) {
            for (ICICSAttribute<?> attribute : this.defaultColumnsProvider.getDefaultColumns()) {
                columnData.add(new TableManager.ColumnData(attribute, -1));
            }
        }
        debug.exit("refresh");
        return columnData;
    }

    private void withSuppressedSave(Runnable r) {
        boolean oldSaveEnabled = this.saveEnabled;
        try {
            this.saveColumnScheduler.force();
            this.saveEnabled = false;
            r.run();
        }
        finally {
            this.saveEnabled = oldSaveEnabled;
        }
    }

    private void scheduleSaveColumns() {
        if (this.saveEnabled) {
            this.saveColumnScheduler.scheduleUpdate();
        }
    }

    private List<TableManager.ColumnData> convertColumnData(Map<ICICSAttribute<?>, Integer> initialColumnData) {
        ArrayList<TableManager.ColumnData> columnData = new ArrayList<TableManager.ColumnData>();
        for (Map.Entry<ICICSAttribute<?>, Integer> columnDatum : initialColumnData.entrySet()) {
            ICICSAttribute<?> attribute = columnDatum.getKey();
            Integer width = columnDatum.getValue();
            columnData.add(new TableManager.ColumnData(attribute, width));
        }
        return columnData;
    }

    private Map<ICICSAttribute<?>, Integer> getSavedColumnData(ICICSType<?> elementType) {
        debug.enter("getSavedColumnData", (Object)("type=" + elementType));
        String columnNamesPrefName = String.valueOf(elementType.getResourceTableName()) + ".columnNames";
        String columnWidthsPrefName = String.valueOf(elementType.getResourceTableName()) + ".columnWidths";
        String columnNamesPrefValue = this.preferenceStore.getString(columnNamesPrefName);
        String columnWidthsPrefValue = this.preferenceStore.getString(columnWidthsPrefName);
        debug.event("getSavedColumnData", "columnNamesPref=" + columnNamesPrefName + ", value=" + columnNamesPrefValue);
        debug.event("getSavedColumnData", "columnWidthsPref=" + columnWidthsPrefName + ", value=" + columnWidthsPrefValue);
        if (columnNamesPrefValue.equals("")) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ICICSAttribute<?>, Integer> columns = this.getColumns(elementType, columnNamesPrefValue, columnWidthsPrefValue);
        debug.exit("getSavedColumnData", columns.entrySet());
        return columns;
    }

    private LinkedHashMap<ICICSAttribute<?>, Integer> getColumns(ICICSType<?> type, String columnNames, String columnWidths) {
        LinkedHashMap columns = new LinkedHashMap();
        String[] names = columnNames.split(",");
        String[] widths = columnWidths.split(",");
        int i = 0;
        while (i < names.length) {
            Integer width = -1;
            if (i < widths.length) {
                try {
                    width = Integer.parseInt(widths[i]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ICICSAttribute attribute = type.findAttributeByID(names[i]);
            columns.put(attribute, width);
            ++i;
        }
        return columns;
    }

    public void resetColumns() {
        this.saveColumnScheduler.force();
        this.preferenceStore.setToDefault(String.valueOf(this.propertySource.getType().getResourceTableName()) + ".columnNames");
        this.preferenceStore.setToDefault(String.valueOf(this.propertySource.getType().getResourceTableName()) + ".columnWidths");
        this.setPreferenceStore(this.preferenceStore);
    }

    public CICSTypePropertySource getPropertySource() {
        return this.propertySource;
    }

    public Action getCustomizeColumnsAction() {
        return new Action(Messages.getString("ResourcesView.customizeColumnsAction.text", new Object[0])){

            public void run() {
                ResourcesViewColumnDialog dialog = new ResourcesViewColumnDialog(Display.getCurrent().getActiveShell(), PreferenceService.this.propertySource, PreferenceService.this.tableManager, PreferenceService.this);
                dialog.open();
            }
        };
    }
}

