/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.CICSTypePropertySource;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.flhsupport.FLHSupport;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptorComparator;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.PreferenceService;
import com.ibm.cics.core.ui.views.TableManager;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ResourcesViewColumnDialog
extends TrayDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.core.ui.views.columns";
    static final String PROPERTY_DESCRIPTOR = "PROPERTY_DESCRIPTOR";
    private static final String DIALOG_HELP_CONTEXT_ID = "com.ibm.cics.core.ui.dialog_ResourcesViewColumnDialog";
    private static final String NAME = "NAME";
    private static final int RESET = 12345;
    protected static ICICSType<?> currentType;
    Table availableColumnsTable;
    Table currentlyUsedColumnsTable;
    private List<IPropertyDescriptor> currentlyUsedPropertyDescriptors = new ArrayList<IPropertyDescriptor>();
    private SortedSet<IPropertyDescriptor> availablePropertyDescriptors = new TreeSet<IPropertyDescriptor>(new CICSObjectPropertyDescriptorComparator());
    private Button addButton;
    private Button removeButton;
    private CICSTypePropertySource propertySource;
    private TableManager tableManager;
    private PreferenceService preferenceService;
    static final String X_LOCATION = "ResourcesView.customizeColumns.dialog.x_location";
    static final String Y_LOCATION = "ResourcesView.customizeColumns.dialog.y_location";
    static final String WIDTH = "ResourcesView.customizeColumns.dialog.width";
    static final String HEIGHT = "ResourcesView.customizeColumns.dialog.height";
    private static final Logger logger;

    static {
        logger = Logger.getLogger(ResourcesViewColumnDialog.class.getPackage().getName());
    }

    public ResourcesViewColumnDialog(Shell parentShell, CICSTypePropertySource propertySource, TableManager tableManager, PreferenceService preferenceService) {
        super(parentShell);
        this.preferenceService = preferenceService;
        Debug.enter((Logger)logger, (String)ResourcesViewColumnDialog.class.getName(), (String)"<init>", (Object)parentShell, (Object)propertySource, (Object)tableManager);
        this.tableManager = tableManager;
        this.propertySource = propertySource;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        Debug.exit((Logger)logger, (String)ResourcesViewColumnDialog.class.getName(), (String)"<init>", (Object)((Object)this));
    }

    protected void initializeBounds() {
        super.initializeBounds();
        int x_location = this.getPreferenceValue(X_LOCATION);
        int y_location = this.getPreferenceValue(Y_LOCATION);
        if (x_location != 0 && y_location != 0) {
            this.getShell().setLocation(x_location, y_location);
        }
        int width = this.getPreferenceValue(WIDTH);
        int height = this.getPreferenceValue(HEIGHT);
        if (width != 0 && height != 0) {
            this.getShell().setSize(width, height);
        }
    }

    private int getPreferenceValue(String preferenceKey) {
        return UIPlugin.getDefault().getPreferenceStore().getInt(preferenceKey);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("ResourcesViewColumnDialog.customiseColumns", this.propertySource.getCICSType().getResourceTableName()));
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite columnsComposite = new Composite(c, 0);
        columnsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        columnsComposite.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ResourcesViewColumnDialog.availableAttributes", new Object[0]));
        l = new Label(columnsComposite, 0);
        l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ResourcesViewColumnDialog.currentViewerColumns", new Object[0]));
        this.availableColumnsTable = new Table(columnsComposite, 2818);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.availableColumnsTable.setLayoutData((Object)data);
        Composite buttonArea = new Composite(columnsComposite, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(0, 4, false, true);
        buttonArea.setLayoutData((Object)data);
        this.currentlyUsedColumnsTable = new Table(columnsComposite, 2818);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.currentlyUsedColumnsTable.setLayoutData((Object)data);
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText(String.valueOf(Messages.getString("ResourcesViewColumnDialog.add", new Object[0])) + " -->");
        data = new GridData(4, 0, true, false);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setEnabled(false);
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("<-- " + Messages.getString("ResourcesViewColumnDialog.remove", new Object[0]));
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)data);
        this.currentlyUsedColumnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeButton.setEnabled(ResourcesViewColumnDialog.this.hasColumnsToRemove());
                if (ResourcesViewColumnDialog.this.getTray() != null) {
                    ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeSelectedColumn();
            }
        });
        this.availableColumnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addButton.setEnabled(ResourcesViewColumnDialog.this.availableColumnsTable.getSelectionCount() >= 1);
                if (ResourcesViewColumnDialog.this.getTray() != null) {
                    ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addSelectedColumn();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addSelectedColumn();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeSelectedColumn();
            }
        });
        this.initialize();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Point location = ResourcesViewColumnDialog.this.getShell().getLocation();
                Point size = ResourcesViewColumnDialog.this.getShell().getSize();
                IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue(ResourcesViewColumnDialog.X_LOCATION, location.x);
                preferenceStore.setValue(ResourcesViewColumnDialog.Y_LOCATION, location.y);
                preferenceStore.setValue(ResourcesViewColumnDialog.WIDTH, size.x);
                preferenceStore.setValue(ResourcesViewColumnDialog.HEIGHT, size.y);
                UIPlugin.getDefault().savePluginPreferences();
            }
        });
        HelpListener helpListener = new HelpListener(){

            public void helpRequested(HelpEvent e) {
                ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
            }
        };
        this.availableColumnsTable.addHelpListener(helpListener);
        this.currentlyUsedColumnsTable.addHelpListener(helpListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), DIALOG_HELP_CONTEXT_ID);
        return c;
    }

    private void showHelpForTableItem(TypedEvent e) {
        if (e.widget instanceof Table) {
            Table table = (Table)e.widget;
            if (table.getSelectionCount() > 0) {
                TableItem ti = table.getSelection()[0];
                IPropertyDescriptor pd = (IPropertyDescriptor)ti.getData(PROPERTY_DESCRIPTOR);
                FLHSupport.showHelp((String)pd.getHelpContextIds());
            } else {
                FLHSupport.showHelp(DIALOG_HELP_CONTEXT_ID);
            }
        }
    }

    private boolean hasColumnsToRemove() {
        if (this.currentlyUsedColumnsTable.getSelectionCount() >= 2) {
            return true;
        }
        if (this.currentlyUsedColumnsTable.getSelectionCount() == 1) {
            return !NAME.equalsIgnoreCase((String)((IPropertyDescriptor)this.currentlyUsedColumnsTable.getSelection()[0].getData(PROPERTY_DESCRIPTOR)).getId());
        }
        return false;
    }

    void addSelectedColumn() {
        TableItem[] columnsToAdd;
        TableItem[] tableItemArray = columnsToAdd = this.availableColumnsTable.getSelection();
        int n = columnsToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem[] availableTableItems;
            TableItem element = tableItemArray[n2];
            IPropertyDescriptor propertyDescriptor = (IPropertyDescriptor)element.getData(PROPERTY_DESCRIPTOR);
            this.createCurrentlyUsedTableItem(propertyDescriptor);
            this.availablePropertyDescriptors.remove(propertyDescriptor);
            TableItem[] tableItemArray2 = availableTableItems = this.availableColumnsTable.getItems();
            int n3 = availableTableItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem availableTableItem = tableItemArray2[n4];
                if (availableTableItem.getData(PROPERTY_DESCRIPTOR) == propertyDescriptor) {
                    availableTableItem.dispose();
                    this.availablePropertyDescriptors.remove(propertyDescriptor);
                    ICICSAttribute<?> attribute = ((ICICSObjectPropertyDescriptor)propertyDescriptor).getAttribute();
                    this.tableManager.addColumn(attribute);
                }
                ++n4;
            }
            ++n2;
        }
        this.addButton.setEnabled(false);
    }

    void removeSelectedColumn() {
        TableItem[] columnsToRemove = this.currentlyUsedColumnsTable.getSelection();
        ArrayList<IPropertyDescriptor> propertyDescriptorsToRemove = new ArrayList<IPropertyDescriptor>();
        TableItem[] tableItemArray = columnsToRemove;
        int n = columnsToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem columnToRemove = tableItemArray[n2];
            IPropertyDescriptor propertyDescriptor = (IPropertyDescriptor)columnToRemove.getData(PROPERTY_DESCRIPTOR);
            if (!NAME.equalsIgnoreCase((String)propertyDescriptor.getId())) {
                propertyDescriptorsToRemove.add(propertyDescriptor);
                this.currentlyUsedPropertyDescriptors.remove(propertyDescriptor);
                columnToRemove.dispose();
                ICICSAttribute<?> attribute = ((ICICSObjectPropertyDescriptor)propertyDescriptor).getAttribute();
                this.tableManager.removeColumn(attribute);
                this.availablePropertyDescriptors.add(propertyDescriptor);
            }
            ++n2;
        }
        this.availableColumnsTable.setRedraw(false);
        try {
            this.availableColumnsTable.removeAll();
            this.refreshAvailablePropertyDescriptors();
            TableItem[] items = this.availableColumnsTable.getItems();
            ArrayList<TableItem> newlyAddedItems = new ArrayList<TableItem>();
            TableItem[] tableItemArray2 = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray2[n4];
                if (propertyDescriptorsToRemove.contains(item.getData(PROPERTY_DESCRIPTOR))) {
                    newlyAddedItems.add(item);
                }
                ++n4;
            }
            TableItem[] tableItemsArray = newlyAddedItems.toArray(new TableItem[0]);
            this.availableColumnsTable.setSelection(tableItemsArray);
        }
        finally {
            this.availableColumnsTable.setRedraw(true);
        }
        this.removeButton.setEnabled(false);
    }

    private void initialize() {
        List<TableManager.ColumnData> columns = this.tableManager.getColumnData();
        for (TableManager.ColumnData column : columns) {
            IAttributePropertyDescriptor propertyDescriptor = this.propertySource.getPropertyDescriptor(((ICICSAttribute)column.id).getPropertyId());
            this.createCurrentlyUsedTableItem(propertyDescriptor);
        }
        this.refreshAvailablePropertyDescriptors();
    }

    private void refreshAvailablePropertyDescriptors() {
        TableColumn[] columns;
        int currentTopItemNumber = this.availableColumnsTable.getTopIndex();
        if (this.availableColumnsTable.getItemCount() > 0) {
            currentTopItemNumber = this.availableColumnsTable.getTopIndex();
        }
        IPropertyDescriptor[] propertyDescriptors = (IPropertyDescriptor[])this.propertySource.getPropertyDescriptors().clone();
        Arrays.sort(propertyDescriptors, new CICSObjectPropertyDescriptorComparator());
        IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors;
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor propertyDescriptor2 = iPropertyDescriptorArray[n2];
            IPropertyDescriptor propertyDescriptor = propertyDescriptor2;
            if (!this.currentlyUsedPropertyDescriptors.contains(propertyDescriptor)) {
                TableItem tableItem = new TableItem(this.availableColumnsTable, 0);
                tableItem.setText(0, propertyDescriptor.getDisplayName());
                tableItem.setData(PROPERTY_DESCRIPTOR, (Object)propertyDescriptor);
                this.availablePropertyDescriptors.add(propertyDescriptor);
            }
            ++n2;
        }
        TableColumn[] tableColumnArray = columns = this.availableColumnsTable.getColumns();
        int n3 = columns.length;
        n = 0;
        while (n < n3) {
            TableColumn column = tableColumnArray[n];
            column.pack();
            ++n;
        }
        if (currentTopItemNumber != -1) {
            this.availableColumnsTable.setTopIndex(currentTopItemNumber);
        }
    }

    private void createCurrentlyUsedTableItem(IPropertyDescriptor aPropertyDescriptor) {
        TableItem currentlyUsedTableItem = new TableItem(this.currentlyUsedColumnsTable, 0);
        currentlyUsedTableItem.setText(aPropertyDescriptor.getDisplayName());
        currentlyUsedTableItem.setData(PROPERTY_DESCRIPTOR, (Object)aPropertyDescriptor);
        this.currentlyUsedPropertyDescriptors.add(aPropertyDescriptor);
        if (NAME.equalsIgnoreCase((String)aPropertyDescriptor.getId())) {
            currentlyUsedTableItem.setForeground(this.availableColumnsTable.getDisplay().getSystemColor(15));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12345) {
            this.preferenceService.resetColumns();
            this.currentlyUsedColumnsTable.removeAll();
            this.availableColumnsTable.removeAll();
            this.availablePropertyDescriptors.clear();
            this.currentlyUsedPropertyDescriptors.clear();
            this.initialize();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12345, Messages.getString("ResourcesViewColumnDialog.reset", new Object[0]), false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    public void init(IWorkbench workbench) {
    }
}

