/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import java.util.Timer;
import java.util.TimerTask;

public class Scheduler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Timer TIMER = new Timer("UI Event Scheduler Timer");
    private TimerTask timerTask;
    private final Runnable runnable;
    private final long delay;

    public Scheduler(Runnable r, long delay) {
        this.runnable = r;
        this.delay = delay;
    }

    public void scheduleUpdate() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new UpdateTimerTask();
        TIMER.schedule(this.timerTask, this.delay);
    }

    public void cancel() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    public void force() {
        if (this.timerTask != null) {
            this.cancel();
            this.runnable.run();
        }
    }

    private class UpdateTimerTask
    extends TimerTask {
        private UpdateTimerTask() {
        }

        @Override
        public void run() {
            Scheduler.this.runnable.run();
            Scheduler.this.timerTask = null;
        }
    }
}

